/*
 * Decompiled with CFR 0.152.
 */
package webwork.dispatcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.Action;
import webwork.action.ActionContext;
import webwork.action.CleanupAware;
import webwork.action.factory.ActionFactory;
import webwork.config.Configuration;
import webwork.dispatcher.ActionResult;
import webwork.dispatcher.ViewActionWrapper;
import webwork.dispatcher.ViewMapping;
import webwork.util.BeanUtil;
import webwork.util.ValueStack;
import webwork.util.injection.ObjectFactory;

public class GenericDispatcher {
    protected static Log log;
    private static ViewMapping mapping;
    boolean prepared = false;
    Map oldContextTable;
    ActionContext context;
    ArrayList actions = new ArrayList();
    String result;
    String actionName;
    LazyValueHolder lazyValueHolder;
    boolean lazy = false;
    Object view;
    Exception actionException;
    int initialStackSize;
    static /* synthetic */ Class class$webwork$dispatcher$GenericDispatcher;
    static /* synthetic */ Class class$webwork$dispatcher$DefaultViewMapping;

    public GenericDispatcher(String actionName) {
        this.actionName = actionName;
    }

    public GenericDispatcher(String actionName, boolean lazy) {
        this.actionName = actionName;
        this.lazy = lazy;
    }

    public ActionContext prepareContext() {
        if (ActionContext.getContext() != null) {
            this.oldContextTable = ActionContext.getContext().getTable();
        }
        this.context = new ActionContext();
        ActionContext.setContext(this.context);
        this.context.put("action.chain", this.actions);
        return this.context;
    }

    public void prepareValueStack() {
        this.initialStackSize = ActionContext.getValueStack().size();
        this.prepared = true;
    }

    public ActionContext getOldContext() {
        ActionContext oldContext = new ActionContext();
        oldContext.setTable(this.oldContextTable);
        return oldContext;
    }

    public List getActions() {
        return this.actions;
    }

    public void executeAction() throws Exception {
        if (!this.prepared) {
            throw new Exception("You must prepare the dispatcher first");
        }
        Action action = ActionFactory.getAction(this.actionName);
        if (this.lazy) {
            this.lazyValueHolder = new LazyValueHolder(action);
            ActionContext.getValueStack().pushValue(this.lazyValueHolder);
            return;
        }
        try {
            this.result = action.execute();
        }
        catch (Exception e) {
            this.actionException = e;
            return;
        }
        ActionContext.getValueStack().pushValue(action);
        if (this.result != null) {
            try {
                this.view = mapping.getView(this.actionName, this.result);
            }
            catch (Exception e) {
                this.view = null;
            }
        }
        while (this.view instanceof ViewActionWrapper) {
            ViewActionWrapper viewActionWrapper = (ViewActionWrapper)this.view;
            this.actionName = viewActionWrapper.getActionName();
            action = ActionFactory.getAction(this.actionName);
            if (viewActionWrapper.hasParams()) {
                BeanUtil.setProperties(viewActionWrapper.getParams(), action);
            }
            try {
                this.result = action.execute();
            }
            catch (Exception e) {
                this.actionException = e;
                return;
            }
            ActionContext.getValueStack().pushValue(action);
            if (this.result == null) continue;
            try {
                this.view = mapping.getView(this.actionName, this.result);
            }
            catch (Exception e) {
                this.view = null;
            }
        }
    }

    public ActionResult finish() {
        if (this.lazy) {
            this.lazyValueHolder.getValue();
            if (this.result != null) {
                try {
                    this.view = mapping.getView(this.actionName, this.result);
                }
                catch (Exception e) {
                    this.view = null;
                }
            }
        }
        return new ActionResult(this.result, this.view, this.actions, this.actionException);
    }

    public void finalizeContext() {
        ValueStack vs = ActionContext.getValueStack();
        int finalStackSize = vs.size();
        int count = finalStackSize - this.initialStackSize;
        for (int i = 0; i < count; ++i) {
            Object o = vs.popValue();
            if (o instanceof ValueStack.ValueHolder) {
                o = ((ValueStack.ValueHolder)o).getValue();
            }
            if (!(o instanceof CleanupAware)) continue;
            ((CleanupAware)o).cleanup();
        }
        ActionContext newContext = new ActionContext();
        newContext.setTable(this.oldContextTable);
        ActionContext.setContext(newContext);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String mappingName;
        log = LogFactory.getLog((Class)(class$webwork$dispatcher$GenericDispatcher == null ? (class$webwork$dispatcher$GenericDispatcher = GenericDispatcher.class$("webwork.dispatcher.GenericDispatcher")) : class$webwork$dispatcher$GenericDispatcher));
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            mappingName = Configuration.getString("webwork.viewmapping");
        }
        catch (IllegalArgumentException e) {
            mappingName = (class$webwork$dispatcher$DefaultViewMapping == null ? (class$webwork$dispatcher$DefaultViewMapping = GenericDispatcher.class$("webwork.dispatcher.DefaultViewMapping")) : class$webwork$dispatcher$DefaultViewMapping).getName();
        }
        try {
            mapping = (ViewMapping)ObjectFactory.instantiateBean(classLoader, mappingName);
        }
        catch (Throwable t) {
            log.error((Object)("GenericDispatcher could not create ViewMapping object of class: " + mappingName), t);
        }
    }

    public class LazyValueHolder
    implements ValueStack.ValueHolder {
        private Action action;
        private boolean hasExecuted = false;

        public LazyValueHolder(Action action) {
            this.action = action;
        }

        public Object getValue() {
            if (!this.hasExecuted) {
                this.hasExecuted = true;
                try {
                    GenericDispatcher.this.result = this.action.execute();
                }
                catch (Exception e) {
                    GenericDispatcher.this.actionException = e;
                    GenericDispatcher.this.result = null;
                    return null;
                }
            }
            return this.action;
        }
    }
}

