/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.IllegalArgumentAware;
import webwork.action.ValidationEditorSupport;
import webwork.util.InjectionUtils;
import webwork.util.Query;
import webwork.util.QuerySegment;
import webwork.util.editor.FastPropertyEditor;
import webwork.util.editor.PropertyEditorException;
import webwork.util.injection.ObjectFactory;

public final class BeanUtil {
    static Map propertyDescriptors = new WeakHashMap();
    static Map propertyEditors = new HashMap();
    static Map objectMap = new WeakHashMap();
    static final Log log = LogFactory.getLog((Class)(class$webwork$util$BeanUtil == null ? (class$webwork$util$BeanUtil = BeanUtil.class$("webwork.util.BeanUtil")) : class$webwork$util$BeanUtil));
    static /* synthetic */ Class class$webwork$util$BeanUtil;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$webwork$util$editor$IntegerObjectEditor;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class class$webwork$util$editor$IntegerEditor;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$webwork$util$editor$DoubleObjectEditor;
    static /* synthetic */ Class array$Ljava$lang$Double;
    static /* synthetic */ Class class$webwork$util$editor$DoubleEditor;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$webwork$util$editor$ByteObjectEditor;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class class$webwork$util$editor$ByteEditor;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$webwork$util$editor$ShortObjectEditor;
    static /* synthetic */ Class array$Ljava$lang$Short;
    static /* synthetic */ Class class$webwork$util$editor$ShortEditor;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$webwork$util$editor$LongObjectEditor;
    static /* synthetic */ Class array$Ljava$lang$Long;
    static /* synthetic */ Class class$webwork$util$editor$LongEditor;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$webwork$util$editor$FloatObjectEditor;
    static /* synthetic */ Class array$Ljava$lang$Float;
    static /* synthetic */ Class class$webwork$util$editor$FloatEditor;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$webwork$util$editor$BooleanObjectEditor;
    static /* synthetic */ Class array$Ljava$lang$Boolean;
    static /* synthetic */ Class class$webwork$util$editor$BooleanEditor;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$webwork$util$editor$StringEditor;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$webwork$util$editor$BigDecimalEditor;
    static /* synthetic */ Class array$Ljava$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$webwork$util$editor$DateEditor;
    static /* synthetic */ Class array$Ljava$util$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$webwork$util$editor$TimestampEditor;
    static /* synthetic */ Class array$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$java$text$DateFormat;
    static /* synthetic */ Class class$webwork$util$editor$DateFormatEditor;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$ResourceBundle;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;

    public static void copy(Object from, Object to) throws IllegalArgumentException {
        BeanUtil.copy(from, to, true);
    }

    public static void copy(Object from, Object to, boolean includeNull) throws IllegalArgumentException {
        try {
            Object[] readParameters = new Object[]{};
            Object[] writeParameters = new Object[1];
            PropertyDescriptor[] propertiesFrom = BeanUtil.getPropertyDescriptors(from.getClass());
            Map fieldMap = BeanUtil.getFieldMapForClass(to.getClass());
            for (int i = 0; i < propertiesFrom.length; ++i) {
                PropertyDescriptor pdFrom = propertiesFrom[i];
                PropertyDescriptor pdTo = (PropertyDescriptor)fieldMap.get(pdFrom.getName());
                if (pdTo == null) continue;
                Method readMethod = pdFrom.getReadMethod();
                Method writeMethod = pdTo.getWriteMethod();
                if (writeMethod == null || readMethod == null) continue;
                writeParameters[0] = InjectionUtils.invoke(pdFrom.getReadMethod(), from, readParameters);
                if (!includeNull && writeParameters[0] == null) continue;
                InjectionUtils.invoke(pdTo.getWriteMethod(), to, writeParameters);
            }
        }
        catch (Exception e) {
            log.warn((Object)("Bean copy failed:" + e), (Throwable)e);
            throw new IllegalArgumentException("Bean copy failed:" + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setProperties(Map from, Object to) throws IllegalArgumentException {
        String key = null;
        Object value = null;
        try {
            Iterator keys = from.keySet().iterator();
            Map fieldMap = null;
            if (keys.hasNext()) {
                fieldMap = BeanUtil.getFieldMapForClass(to.getClass());
            }
            while (keys.hasNext()) {
                key = (String)keys.next();
                try {
                    value = from.get(key);
                    BeanUtil.setProperty(key, value, to, fieldMap);
                }
                catch (IllegalArgumentException e) {
                    if (!(to instanceof IllegalArgumentAware)) throw e;
                    ((IllegalArgumentAware)to).addIllegalArgumentException(key, e);
                    continue;
                    return;
                }
            }
        }
        catch (Throwable e) {
            log.warn((Object)("Could not set parameter \"" + key + "\" with value \"" + value + "\" on class " + to.getClass() + ":" + e), e);
            throw new IllegalArgumentException("Could not set parameter \"" + key + "\":" + e);
        }
    }

    public static void setProperty(String propertyName, Object val, Object obj) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException("The target object for property '" + propertyName + "'. The target object needs to be initialized to a non-null value in order to set this property.");
        }
        Map fieldMap = BeanUtil.getFieldMapForClass(obj.getClass());
        BeanUtil.setProperty(propertyName, val, obj, fieldMap);
    }

    private static void setProperty(String propertyName, Object val, Object obj, Map fieldMap) throws IllegalArgumentException {
        Query query = Query.getQuery(propertyName);
        QuerySegment[] segments = query.getSegments();
        Object curObject = obj;
        int totalNumberOfSegments = BeanUtil.findTheActualNumberOfSegments(segments);
        for (int i = 0; i < totalNumberOfSegments; ++i) {
            QuerySegment curSegment;
            if (curObject == null) {
                throw new IllegalArgumentException("The target object for property '" + propertyName + "'. The target object needs to be initialized to a non-null value in order to set this property.");
            }
            Map curFieldMap = curObject != obj ? BeanUtil.getFieldMapForClass(curObject.getClass()) : fieldMap;
            PropertyDescriptor descriptor = (PropertyDescriptor)curFieldMap.get((curSegment = segments[i]).getId());
            if (descriptor == null && curSegment.getType() != 9) {
                return;
            }
            if (curSegment.getType() == 9) {
                String key = curSegment.getId();
                if ((class$java$util$Map == null ? BeanUtil.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(curObject.getClass())) {
                    curObject = ((Map)curObject).get(key);
                    continue;
                }
                if ((class$java$util$ResourceBundle == null ? BeanUtil.class$("java.util.ResourceBundle") : class$java$util$ResourceBundle).isAssignableFrom(curObject.getClass())) {
                    curObject = ((ResourceBundle)curObject).getObject(key);
                    continue;
                }
                if (curObject.getClass().isArray()) {
                    curObject = ((Object[])curObject)[Integer.parseInt(key)];
                    continue;
                }
                if ((class$java$util$List == null ? BeanUtil.class$("java.util.List") : class$java$util$List).isAssignableFrom(curObject.getClass())) {
                    curObject = ((List)curObject).get(Integer.parseInt(key));
                    continue;
                }
                if (!(class$java$util$Collection == null ? BeanUtil.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(curObject.getClass())) continue;
                curObject = ((Collection)curObject).toArray()[Integer.parseInt(key)];
                continue;
            }
            if (curSegment.getType() == 8) {
                try {
                    if (descriptor instanceof IndexedPropertyDescriptor) {
                        throw new IllegalArgumentException("Attempting to set a indexed field " + curSegment.getId() + " as an non-indexed field");
                    }
                    if (i + 1 == totalNumberOfSegments) {
                        BeanUtil.setValue(curObject, descriptor, val);
                        return;
                    }
                    Method m = descriptor.getReadMethod();
                    if (m == null) {
                        throw new IllegalArgumentException("Read Method " + descriptor.getName() + " for " + curObject.getClass().getName() + " was not found");
                    }
                    curObject = InjectionUtils.invoke(m, curObject, new Object[0]);
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    throw iae;
                }
                catch (Exception e) {
                    log.warn((Object)("Error executing read method for " + descriptor.getName() + " on " + curObject.getClass().getName()), (Throwable)e);
                    throw new IllegalArgumentException("Error executing read method for " + descriptor.getName() + " on " + curObject.getClass().getName());
                }
            }
            if (curSegment.getType() != 10) continue;
            Integer index = BeanUtil.getIndexedPropertyIndex(curSegment);
            try {
                Method m;
                if (i + 1 == totalNumberOfSegments) {
                    if (descriptor instanceof IndexedPropertyDescriptor) {
                        BeanUtil.setIndexedValue(curObject, (IndexedPropertyDescriptor)descriptor, val, index);
                        return;
                    }
                    throw new IllegalArgumentException("Attempting to set non-indexed field \"" + curSegment.getId() + "\" as an indexed field");
                }
                if (descriptor instanceof IndexedPropertyDescriptor) {
                    m = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
                    if (m == null) {
                        throw new IllegalArgumentException("Indexed Read Method " + descriptor.getName() + " for " + curObject.getClass().getName() + " was not found");
                    }
                } else {
                    throw new IllegalArgumentException("Attempting to access non-indexed field \"" + curSegment.getId() + "\" as an indexed field");
                }
                curObject = InjectionUtils.invoke(m, curObject, new Object[]{index});
                continue;
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error executing index read method for " + (descriptor != null ? descriptor.getName() : "<null>") + " on " + (curObject != null ? curObject.getClass().getName() : "<null>"));
            }
        }
    }

    public static PropertyEditor getPropertyEditor(Class clazz) {
        Object editor = propertyEditors.get(clazz);
        if (editor == null) {
            editor = PropertyEditorManager.findEditor(clazz);
            if (editor == null) {
                Map newEditorMap = (Map)((HashMap)propertyEditors).clone();
                newEditorMap.put(clazz, new Byte("0"));
                propertyEditors = newEditorMap;
                log.debug((Object)("PropertyEditorManager.findEditor returned null for class: " + clazz.getName()));
            } else if (editor instanceof FastPropertyEditor) {
                Map newEditorMap = (Map)((HashMap)propertyEditors).clone();
                newEditorMap.put(clazz, editor);
                propertyEditors = newEditorMap;
            }
        } else if (editor instanceof Byte) {
            return null;
        }
        return (PropertyEditor)editor;
    }

    public static Object getAsValue(PropertyEditor pe, String txt) {
        if (pe instanceof FastPropertyEditor) {
            return ((FastPropertyEditor)((Object)pe)).getAsValue(txt);
        }
        pe.setAsText(txt);
        return pe.getValue();
    }

    public static String toStringValue(Object obj) {
        String result = "";
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            PropertyEditor pe = BeanUtil.getPropertyEditor(obj.getClass());
            if (pe != null) {
                if (pe instanceof FastPropertyEditor) {
                    result = ((FastPropertyEditor)((Object)pe)).getAsText(obj);
                } else if (pe instanceof ValidationEditorSupport) {
                    pe.setValue(obj);
                    result = pe.getAsText();
                } else {
                    result = obj.toString();
                }
            } else {
                result = obj.toString();
            }
        }
        return result;
    }

    private static Integer getIndexedPropertyIndex(QuerySegment curSegment) {
        Integer index;
        try {
            List values = curSegment.getValues();
            if (values.size() != 1) {
                throw new IllegalArgumentException("Only Indexed properties allowed!");
            }
            Object value = values.get(0);
            index = value instanceof Query ? new Integer(((Query)value).getSegments()[0].getValues().get(0).toString()) : new Integer(values.get(0).toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Only Indexed properties allowed! - Parameter must be an integer ");
        }
        return index;
    }

    private static int findTheActualNumberOfSegments(QuerySegment[] segments) {
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i] != null) continue;
            return i;
        }
        return segments.length;
    }

    private static boolean setValue(Object obj, PropertyDescriptor descriptor, Object val) throws IllegalArgumentException {
        if (descriptor == null || descriptor.getWriteMethod() == null) {
            log.debug((Object)"No descriptor found for. Unable to set value. ");
            return false;
        }
        if (val == null) {
            return false;
        }
        Method m = descriptor.getWriteMethod();
        Class<?> valueClass = val.getClass();
        Class<?>[] parameterClasses = m.getParameterTypes();
        Class<?> parameterClass = parameterClasses[0];
        if (!(valueClass.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String) || valueClass.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || parameterClass.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String))) {
            return BeanUtil.setObjectDirectly(parameterClass, valueClass, val, m, obj);
        }
        String[] value = BeanUtil.convertObjectToStringArray(val);
        if (value != null) {
            if (descriptor.getPropertyEditorClass() == null && BeanUtil.setStringValueDirectly(obj, descriptor, value)) {
                return true;
            }
            BeanUtil.setStringValueWithPropertyEditor(obj, descriptor, value, parameterClass);
            return true;
        }
        return false;
    }

    private static String[] convertObjectToStringArray(Object val) {
        Class<?> valueClass = val.getClass();
        if (valueClass.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String)) {
            return new String[]{(String)val};
        }
        if (valueClass.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            return (String[])val;
        }
        return new String[]{val.toString()};
    }

    private static boolean setIndexedValue(Object obj, IndexedPropertyDescriptor descriptor, Object val, Integer index) {
        if (descriptor == null) {
            log.info((Object)"no descriptor found");
            return false;
        }
        Method m = descriptor.getIndexedWriteMethod();
        Class<?> valueClass = val.getClass();
        Class<?> parameterClass = m.getParameterTypes()[1];
        if (!(valueClass.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String) || valueClass.equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || parameterClass.equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String))) {
            return BeanUtil.setIndexedObjectDirectly(parameterClass, valueClass, val, m, obj, index);
        }
        String[] value = BeanUtil.convertObjectToStringArray(val);
        if (value != null) {
            if (descriptor.getPropertyEditorClass() == null && BeanUtil.setIndexedStringValueDirectly(obj, descriptor, value, index)) {
                return true;
            }
            BeanUtil.setIndexedStringValueWithPropertyEditor(obj, descriptor, value, index);
            return true;
        }
        return false;
    }

    private static boolean setIndexedObjectDirectly(Class parameterClass, Class valueClass, Object val, Method m, Object obj, Integer index) {
        if (!parameterClass.isAssignableFrom(valueClass)) {
            if (parameterClass.equals(Integer.TYPE)) {
                parameterClass = class$java$lang$Integer == null ? (class$java$lang$Integer = BeanUtil.class$("java.lang.Integer")) : class$java$lang$Integer;
            } else if (parameterClass.equals(Long.TYPE)) {
                parameterClass = class$java$lang$Long == null ? (class$java$lang$Long = BeanUtil.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if ((class$java$lang$Number == null ? (class$java$lang$Number = BeanUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(valueClass) && (class$java$lang$Number == null ? (class$java$lang$Number = BeanUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(parameterClass)) {
                if ((class$java$lang$Long == null ? (class$java$lang$Long = BeanUtil.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(parameterClass)) {
                    val = new Long(((Number)val).longValue());
                } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = BeanUtil.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(parameterClass)) {
                    val = new Integer(((Number)val).intValue());
                }
            }
        }
        try {
            Object[] writeParameter = new Object[]{index, val};
            InjectionUtils.invoke(m, obj, writeParameter);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean setObjectDirectly(Class parameterClass, Class valueClass, Object val, Method m, Object obj) {
        if (!parameterClass.isAssignableFrom(valueClass)) {
            if (parameterClass.equals(Integer.TYPE)) {
                parameterClass = class$java$lang$Integer == null ? (class$java$lang$Integer = BeanUtil.class$("java.lang.Integer")) : class$java$lang$Integer;
            } else if (parameterClass.equals(Long.TYPE)) {
                parameterClass = class$java$lang$Long == null ? (class$java$lang$Long = BeanUtil.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if ((class$java$lang$Number == null ? (class$java$lang$Number = BeanUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(valueClass) && (class$java$lang$Number == null ? (class$java$lang$Number = BeanUtil.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(parameterClass)) {
                if ((class$java$lang$Long == null ? (class$java$lang$Long = BeanUtil.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(parameterClass)) {
                    val = new Long(((Number)val).longValue());
                } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = BeanUtil.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(parameterClass)) {
                    val = new Integer(((Number)val).intValue());
                }
            }
        }
        try {
            Object[] writeParameter = new Object[]{val};
            InjectionUtils.invoke(m, obj, writeParameter);
            return true;
        }
        catch (Exception e) {
            Throwable t;
            if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            return false;
        }
    }

    private static boolean setStringValueDirectly(Object obj, PropertyDescriptor descriptor, String[] values) throws IllegalArgumentException {
        try {
            Method m = descriptor.getWriteMethod();
            if (descriptor.getPropertyType().equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String) || descriptor.getPropertyType().equals(class$java$lang$Object == null ? (class$java$lang$Object = BeanUtil.class$("java.lang.Object")) : class$java$lang$Object)) {
                InjectionUtils.invoke(m, obj, new Object[]{values[0]});
                return true;
            }
            if (descriptor.getPropertyType().equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                InjectionUtils.invoke(m, obj, new Object[]{values});
                return true;
            }
        }
        catch (Exception e) {
            Throwable t;
            if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IllegalArgumentException(e.toString());
        }
        return false;
    }

    private static void setStringValueWithPropertyEditor(Object obj, PropertyDescriptor descriptor, String[] values, Class paramClass) throws IllegalArgumentException {
        block13: {
            try {
                PropertyEditor pe = BeanUtil.getPropertyEditor(descriptor);
                Method m = descriptor.getWriteMethod();
                if (pe == null) {
                    throw new IllegalArgumentException("No property editor registered for this type");
                }
                try {
                    try {
                        Class<?> compType = paramClass.getComponentType();
                        if (compType != null) {
                            Object a = Array.newInstance(compType, values.length);
                            for (int i = 0; i < values.length; ++i) {
                                Array.set(a, i, BeanUtil.getAsValue(pe, values[i]));
                            }
                            InjectionUtils.invoke(m, obj, new Object[]{a});
                        } else {
                            Object realValue = BeanUtil.getAsValue(pe, values[0]);
                            InjectionUtils.invoke(m, obj, new Object[]{realValue});
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new PropertyEditorException("BAD_VALUE", values[0]);
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (obj instanceof IllegalArgumentAware) {
                        ((IllegalArgumentAware)obj).addIllegalArgumentException(descriptor.getName(), ex);
                        break block13;
                    }
                    throw ex;
                }
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (Exception e) {
                Throwable t;
                if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)t;
                }
                throw new IllegalArgumentException(e.toString());
            }
        }
    }

    private static void setIndexedStringValueWithPropertyEditor(Object obj, IndexedPropertyDescriptor descriptor, String[] values, Integer index) throws IllegalArgumentException {
        try {
            PropertyEditor pe = BeanUtil.getPropertyEditor(descriptor);
            Method m = descriptor.getIndexedWriteMethod();
            if (pe == null) {
                throw new IllegalArgumentException("No property editor registered for this type");
            }
            Object realValue = BeanUtil.getAsValue(pe, values[0]);
            InjectionUtils.invoke(m, obj, new Object[]{index, realValue});
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Throwable t;
            if (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IllegalArgumentException(e.toString());
        }
    }

    private static boolean setIndexedStringValueDirectly(Object obj, IndexedPropertyDescriptor descriptor, String[] values, Integer index) throws IllegalArgumentException {
        try {
            Method m = descriptor.getIndexedWriteMethod();
            if (descriptor.getIndexedPropertyType().equals(class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String) || descriptor.getIndexedPropertyType().equals(class$java$lang$Object == null ? (class$java$lang$Object = BeanUtil.class$("java.lang.Object")) : class$java$lang$Object)) {
                InjectionUtils.invoke(m, obj, new Object[]{index, values[0]});
                return true;
            }
            if (descriptor.getIndexedPropertyType().equals(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
                InjectionUtils.invoke(m, obj, new Object[]{index, values});
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                if (t instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)t;
                }
                log.error((Object)("Error invoking indexed property method " + descriptor.getIndexedWriteMethod().getName() + " index=" + index + " values=" + Arrays.asList(values)), t);
                throw new IllegalArgumentException(t.toString());
            }
            throw new IllegalArgumentException(e.toString());
        }
        return false;
    }

    private static PropertyDescriptor getPropertyDescriptor(String property, Object obj) {
        Map fieldMap = BeanUtil.getFieldMapForClass(obj.getClass());
        return (PropertyDescriptor)fieldMap.get(property);
    }

    private static Map getFieldMapForClass(Class objClass) {
        Map fieldMap = (Map)objectMap.get(objClass);
        if (fieldMap == null && (fieldMap = BeanUtil.buildFieldMap(objClass)) != null) {
            objectMap.put(objClass, fieldMap);
        }
        return fieldMap;
    }

    private static Map buildFieldMap(Class objClass) {
        WeakHashMap<String, PropertyDescriptor> fieldMap = new WeakHashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] descriptors = BeanUtil.getPropertyDescriptors(objClass);
        if (descriptors != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                fieldMap.put(descriptors[i].getName(), descriptors[i]);
            }
            return fieldMap;
        }
        return null;
    }

    private static PropertyEditor getPropertyEditor(PropertyDescriptor descriptor) {
        Class<?> peClass = descriptor.getPropertyEditorClass();
        try {
            if (peClass == null) {
                if (descriptor instanceof IndexedPropertyDescriptor) {
                    return BeanUtil.getPropertyEditor(((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType());
                }
                return BeanUtil.getPropertyEditor(descriptor.getPropertyType());
            }
            return (PropertyEditor)ObjectFactory.instantiate(peClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    private static synchronized PropertyDescriptor[] getPropertyDescriptors(Class objClass) {
        PropertyDescriptor[] descriptors = (PropertyDescriptor[])propertyDescriptors.get(objClass);
        if (descriptors == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(objClass, class$java$lang$Object == null ? (class$java$lang$Object = BeanUtil.class$("java.lang.Object")) : class$java$lang$Object);
            }
            catch (IntrospectionException e) {
                return new PropertyDescriptor[0];
            }
            descriptors = beanInfo.getPropertyDescriptors();
            ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(descriptors.length);
            for (int i = 0; i < descriptors.length; ++i) {
                Method writeMethod;
                Method readMethod;
                PropertyDescriptor descriptor = descriptors[i];
                if (descriptor instanceof IndexedPropertyDescriptor) {
                    readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
                    if (!BeanUtil.verifyNotObjectProperty(readMethod, writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod())) continue;
                    list.add(descriptor);
                    continue;
                }
                readMethod = descriptor.getReadMethod();
                if (!BeanUtil.verifyNotObjectProperty(readMethod, writeMethod = descriptor.getWriteMethod())) continue;
                list.add(descriptor);
            }
            descriptors = new PropertyDescriptor[list.size()];
            list.toArray(descriptors);
            propertyDescriptors.put(objClass, descriptors);
        }
        return descriptors;
    }

    private static boolean verifyNotObjectProperty(Method readMethod, Method writeMethod) {
        return readMethod != null && !readMethod.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = BeanUtil.class$("java.lang.Object")) : class$java$lang$Object) || writeMethod != null && !writeMethod.getDeclaringClass().equals(class$java$lang$Object == null ? (class$java$lang$Object = BeanUtil.class$("java.lang.Object")) : class$java$lang$Object);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyEditorManager.registerEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanUtil.class$("java.lang.Integer")) : class$java$lang$Integer, class$webwork$util$editor$IntegerObjectEditor == null ? (class$webwork$util$editor$IntegerObjectEditor = BeanUtil.class$("webwork.util.editor.IntegerObjectEditor")) : class$webwork$util$editor$IntegerObjectEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = BeanUtil.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer, class$webwork$util$editor$IntegerObjectEditor == null ? (class$webwork$util$editor$IntegerObjectEditor = BeanUtil.class$("webwork.util.editor.IntegerObjectEditor")) : class$webwork$util$editor$IntegerObjectEditor);
        PropertyEditorManager.registerEditor(Integer.TYPE, class$webwork$util$editor$IntegerEditor == null ? (class$webwork$util$editor$IntegerEditor = BeanUtil.class$("webwork.util.editor.IntegerEditor")) : class$webwork$util$editor$IntegerEditor);
        PropertyEditorManager.registerEditor(array$I == null ? (array$I = BeanUtil.class$("[I")) : array$I, class$webwork$util$editor$IntegerEditor == null ? (class$webwork$util$editor$IntegerEditor = BeanUtil.class$("webwork.util.editor.IntegerEditor")) : class$webwork$util$editor$IntegerEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Double == null ? (class$java$lang$Double = BeanUtil.class$("java.lang.Double")) : class$java$lang$Double, class$webwork$util$editor$DoubleObjectEditor == null ? (class$webwork$util$editor$DoubleObjectEditor = BeanUtil.class$("webwork.util.editor.DoubleObjectEditor")) : class$webwork$util$editor$DoubleObjectEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Double == null ? (array$Ljava$lang$Double = BeanUtil.class$("[Ljava.lang.Double;")) : array$Ljava$lang$Double, class$webwork$util$editor$DoubleObjectEditor == null ? (class$webwork$util$editor$DoubleObjectEditor = BeanUtil.class$("webwork.util.editor.DoubleObjectEditor")) : class$webwork$util$editor$DoubleObjectEditor);
        PropertyEditorManager.registerEditor(Double.TYPE, class$webwork$util$editor$DoubleEditor == null ? (class$webwork$util$editor$DoubleEditor = BeanUtil.class$("webwork.util.editor.DoubleEditor")) : class$webwork$util$editor$DoubleEditor);
        PropertyEditorManager.registerEditor(array$D == null ? (array$D = BeanUtil.class$("[D")) : array$D, class$webwork$util$editor$DoubleEditor == null ? (class$webwork$util$editor$DoubleEditor = BeanUtil.class$("webwork.util.editor.DoubleEditor")) : class$webwork$util$editor$DoubleEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanUtil.class$("java.lang.Byte")) : class$java$lang$Byte, class$webwork$util$editor$ByteObjectEditor == null ? (class$webwork$util$editor$ByteObjectEditor = BeanUtil.class$("webwork.util.editor.ByteObjectEditor")) : class$webwork$util$editor$ByteObjectEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = BeanUtil.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, class$webwork$util$editor$ByteObjectEditor == null ? (class$webwork$util$editor$ByteObjectEditor = BeanUtil.class$("webwork.util.editor.ByteObjectEditor")) : class$webwork$util$editor$ByteObjectEditor);
        PropertyEditorManager.registerEditor(Byte.TYPE, class$webwork$util$editor$ByteEditor == null ? (class$webwork$util$editor$ByteEditor = BeanUtil.class$("webwork.util.editor.ByteEditor")) : class$webwork$util$editor$ByteEditor);
        PropertyEditorManager.registerEditor(array$B == null ? (array$B = BeanUtil.class$("[B")) : array$B, class$webwork$util$editor$ByteEditor == null ? (class$webwork$util$editor$ByteEditor = BeanUtil.class$("webwork.util.editor.ByteEditor")) : class$webwork$util$editor$ByteEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Short == null ? (class$java$lang$Short = BeanUtil.class$("java.lang.Short")) : class$java$lang$Short, class$webwork$util$editor$ShortObjectEditor == null ? (class$webwork$util$editor$ShortObjectEditor = BeanUtil.class$("webwork.util.editor.ShortObjectEditor")) : class$webwork$util$editor$ShortObjectEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Short == null ? (array$Ljava$lang$Short = BeanUtil.class$("[Ljava.lang.Short;")) : array$Ljava$lang$Short, class$webwork$util$editor$ShortObjectEditor == null ? (class$webwork$util$editor$ShortObjectEditor = BeanUtil.class$("webwork.util.editor.ShortObjectEditor")) : class$webwork$util$editor$ShortObjectEditor);
        PropertyEditorManager.registerEditor(Short.TYPE, class$webwork$util$editor$ShortEditor == null ? (class$webwork$util$editor$ShortEditor = BeanUtil.class$("webwork.util.editor.ShortEditor")) : class$webwork$util$editor$ShortEditor);
        PropertyEditorManager.registerEditor(array$S == null ? (array$S = BeanUtil.class$("[S")) : array$S, class$webwork$util$editor$ShortEditor == null ? (class$webwork$util$editor$ShortEditor = BeanUtil.class$("webwork.util.editor.ShortEditor")) : class$webwork$util$editor$ShortEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Long == null ? (class$java$lang$Long = BeanUtil.class$("java.lang.Long")) : class$java$lang$Long, class$webwork$util$editor$LongObjectEditor == null ? (class$webwork$util$editor$LongObjectEditor = BeanUtil.class$("webwork.util.editor.LongObjectEditor")) : class$webwork$util$editor$LongObjectEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Long == null ? (array$Ljava$lang$Long = BeanUtil.class$("[Ljava.lang.Long;")) : array$Ljava$lang$Long, class$webwork$util$editor$LongObjectEditor == null ? (class$webwork$util$editor$LongObjectEditor = BeanUtil.class$("webwork.util.editor.LongObjectEditor")) : class$webwork$util$editor$LongObjectEditor);
        PropertyEditorManager.registerEditor(Long.TYPE, class$webwork$util$editor$LongEditor == null ? (class$webwork$util$editor$LongEditor = BeanUtil.class$("webwork.util.editor.LongEditor")) : class$webwork$util$editor$LongEditor);
        PropertyEditorManager.registerEditor(array$J == null ? (array$J = BeanUtil.class$("[J")) : array$J, class$webwork$util$editor$LongEditor == null ? (class$webwork$util$editor$LongEditor = BeanUtil.class$("webwork.util.editor.LongEditor")) : class$webwork$util$editor$LongEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Float == null ? (class$java$lang$Float = BeanUtil.class$("java.lang.Float")) : class$java$lang$Float, class$webwork$util$editor$FloatObjectEditor == null ? (class$webwork$util$editor$FloatObjectEditor = BeanUtil.class$("webwork.util.editor.FloatObjectEditor")) : class$webwork$util$editor$FloatObjectEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Float == null ? (array$Ljava$lang$Float = BeanUtil.class$("[Ljava.lang.Float;")) : array$Ljava$lang$Float, class$webwork$util$editor$FloatObjectEditor == null ? (class$webwork$util$editor$FloatObjectEditor = BeanUtil.class$("webwork.util.editor.FloatObjectEditor")) : class$webwork$util$editor$FloatObjectEditor);
        PropertyEditorManager.registerEditor(Float.TYPE, class$webwork$util$editor$FloatEditor == null ? (class$webwork$util$editor$FloatEditor = BeanUtil.class$("webwork.util.editor.FloatEditor")) : class$webwork$util$editor$FloatEditor);
        PropertyEditorManager.registerEditor(array$F == null ? (array$F = BeanUtil.class$("[F")) : array$F, class$webwork$util$editor$FloatEditor == null ? (class$webwork$util$editor$FloatEditor = BeanUtil.class$("webwork.util.editor.FloatEditor")) : class$webwork$util$editor$FloatEditor);
        PropertyEditorManager.registerEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanUtil.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$webwork$util$editor$BooleanObjectEditor == null ? (class$webwork$util$editor$BooleanObjectEditor = BeanUtil.class$("webwork.util.editor.BooleanObjectEditor")) : class$webwork$util$editor$BooleanObjectEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$Boolean == null ? (array$Ljava$lang$Boolean = BeanUtil.class$("[Ljava.lang.Boolean;")) : array$Ljava$lang$Boolean, class$webwork$util$editor$BooleanObjectEditor == null ? (class$webwork$util$editor$BooleanObjectEditor = BeanUtil.class$("webwork.util.editor.BooleanObjectEditor")) : class$webwork$util$editor$BooleanObjectEditor);
        PropertyEditorManager.registerEditor(Boolean.TYPE, class$webwork$util$editor$BooleanEditor == null ? (class$webwork$util$editor$BooleanEditor = BeanUtil.class$("webwork.util.editor.BooleanEditor")) : class$webwork$util$editor$BooleanEditor);
        PropertyEditorManager.registerEditor(array$Z == null ? (array$Z = BeanUtil.class$("[Z")) : array$Z, class$webwork$util$editor$BooleanEditor == null ? (class$webwork$util$editor$BooleanEditor = BeanUtil.class$("webwork.util.editor.BooleanEditor")) : class$webwork$util$editor$BooleanEditor);
        PropertyEditorManager.registerEditor(class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String, class$webwork$util$editor$StringEditor == null ? (class$webwork$util$editor$StringEditor = BeanUtil.class$("webwork.util.editor.StringEditor")) : class$webwork$util$editor$StringEditor);
        PropertyEditorManager.registerEditor(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$webwork$util$editor$StringEditor == null ? (class$webwork$util$editor$StringEditor = BeanUtil.class$("webwork.util.editor.StringEditor")) : class$webwork$util$editor$StringEditor);
        PropertyEditorManager.registerEditor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BeanUtil.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$webwork$util$editor$BigDecimalEditor == null ? (class$webwork$util$editor$BigDecimalEditor = BeanUtil.class$("webwork.util.editor.BigDecimalEditor")) : class$webwork$util$editor$BigDecimalEditor);
        PropertyEditorManager.registerEditor(array$Ljava$math$BigDecimal == null ? (array$Ljava$math$BigDecimal = BeanUtil.class$("[Ljava.math.BigDecimal;")) : array$Ljava$math$BigDecimal, class$webwork$util$editor$BigDecimalEditor == null ? (class$webwork$util$editor$BigDecimalEditor = BeanUtil.class$("webwork.util.editor.BigDecimalEditor")) : class$webwork$util$editor$BigDecimalEditor);
        PropertyEditorManager.registerEditor(class$java$util$Date == null ? (class$java$util$Date = BeanUtil.class$("java.util.Date")) : class$java$util$Date, class$webwork$util$editor$DateEditor == null ? (class$webwork$util$editor$DateEditor = BeanUtil.class$("webwork.util.editor.DateEditor")) : class$webwork$util$editor$DateEditor);
        PropertyEditorManager.registerEditor(array$Ljava$util$Date == null ? (array$Ljava$util$Date = BeanUtil.class$("[Ljava.util.Date;")) : array$Ljava$util$Date, class$webwork$util$editor$DateEditor == null ? (class$webwork$util$editor$DateEditor = BeanUtil.class$("webwork.util.editor.DateEditor")) : class$webwork$util$editor$DateEditor);
        PropertyEditorManager.registerEditor(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = BeanUtil.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, class$webwork$util$editor$TimestampEditor == null ? (class$webwork$util$editor$TimestampEditor = BeanUtil.class$("webwork.util.editor.TimestampEditor")) : class$webwork$util$editor$TimestampEditor);
        PropertyEditorManager.registerEditor(array$Ljava$sql$Timestamp == null ? (array$Ljava$sql$Timestamp = BeanUtil.class$("[Ljava.sql.Timestamp;")) : array$Ljava$sql$Timestamp, class$webwork$util$editor$TimestampEditor == null ? (class$webwork$util$editor$TimestampEditor = BeanUtil.class$("webwork.util.editor.TimestampEditor")) : class$webwork$util$editor$TimestampEditor);
        PropertyEditorManager.registerEditor(class$java$text$DateFormat == null ? (class$java$text$DateFormat = BeanUtil.class$("java.text.DateFormat")) : class$java$text$DateFormat, class$webwork$util$editor$DateFormatEditor == null ? (class$webwork$util$editor$DateFormatEditor = BeanUtil.class$("webwork.util.editor.DateFormatEditor")) : class$webwork$util$editor$DateFormatEditor);
    }
}

