/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.util.ComplexException;
import webwork.util.ConcurrentReaderHashMap;
import webwork.util.Query;
import webwork.util.QuerySegment;
import webwork.util.ValueStack;

public class SimpleTest {
    private static final Log log = LogFactory.getLog((Class)(class$webwork$util$SimpleTest == null ? (class$webwork$util$SimpleTest = SimpleTest.class$("webwork.util.SimpleTest")) : class$webwork$util$SimpleTest));
    private static Map simpleTestMap = new ConcurrentReaderHashMap();
    private static final SimpleTest COMPLEX_TEST = new SimpleTest();
    private static final Object NO_CONSTANT = new Object();
    protected static final int NONE = 0;
    protected static final int AND = 1;
    protected static final int OR = 2;
    protected static final char AND_CHAR = '&';
    protected static final char OR_CHAR = '|';
    protected static final char QUOTE_CHAR = '\'';
    protected static final char EQUAL_CHAR = '=';
    protected static final char NOT_CHAR = '!';
    protected static final char GREATER_CHAR = '>';
    protected static final char LESS_CHAR = '<';
    protected static final int CHECK_NULL = 0;
    protected static final int EQUAL = 1;
    protected static final int NOT_EQUAL = 2;
    protected static final int GREATER = 3;
    protected static final int GREATER_EQUAL = 4;
    protected static final int LESS = 5;
    protected static final int LESS_EQUAL = 6;
    protected int condition;
    protected boolean neg1;
    protected boolean neg2;
    protected Query q1;
    protected Query q2;
    protected String exp1;
    protected String exp2;
    protected Object value1;
    protected Object value2;
    protected SimpleTest nextTest;
    protected int operator = 0;
    protected int sameVal1;
    protected int sameVal2;
    static /* synthetic */ Class class$webwork$util$SimpleTest;

    public static SimpleTest getSimpleTest(String expression) {
        SimpleTest test = (SimpleTest)simpleTestMap.get(expression);
        if (test != null) {
            if (test != COMPLEX_TEST) {
                return test;
            }
            return null;
        }
        try {
            test = new SimpleTest(expression);
            simpleTestMap.put(expression, test);
            return test;
        }
        catch (ComplexException e) {
            simpleTestMap.put(expression, COMPLEX_TEST);
            return null;
        }
    }

    public SimpleTest() {
    }

    public SimpleTest(SimpleTest prevTest, String exp) throws ComplexException {
        this(exp);
        if (this.value1 == NO_CONSTANT) {
            if (this.exp1.equals(prevTest.exp1)) {
                this.sameVal1 = 1;
            } else if (this.exp1.equals(prevTest.exp2)) {
                this.sameVal1 = 2;
            }
        }
        if (this.exp2 != null && this.value2 == NO_CONSTANT) {
            if (this.exp2.equals(prevTest.exp1)) {
                this.sameVal2 = 1;
            } else if (this.exp2.equals(prevTest.exp2)) {
                this.sameVal2 = 2;
            }
        }
    }

    public SimpleTest(String exp) throws ComplexException {
        exp = exp.trim();
        String nextExp = null;
        int opIndex = this.checkOperator(exp);
        if (this.operator != 0) {
            nextExp = exp.substring(opIndex + 2).trim();
            exp = exp.substring(0, opIndex).trim();
        }
        if (this.condition == 0) {
            if (exp.charAt(0) == '!') {
                this.neg1 = true;
                this.exp1 = exp.substring(1).trim();
            } else {
                this.exp1 = exp;
            }
            if (this.exp1.charAt(0) == '(') {
                throw new ComplexException("Expression too complex because it starts with ( : " + exp);
            }
            this.value1 = this.getConstant(this.exp1);
        } else {
            if (this.exp1.charAt(0) == '!' || this.exp2.charAt(0) == '!') {
                throw new IllegalArgumentException("Invalid expression, misplaced '!' : " + exp);
            }
            if (this.exp1.charAt(0) == '(' || this.exp2.charAt(0) == '(') {
                throw new ComplexException("Expression too complex because it starts with ( : " + exp);
            }
            this.value1 = this.getConstant(this.exp1);
            this.value2 = this.getConstant(this.exp2);
        }
        if (this.value1 == NO_CONSTANT) {
            this.q1 = Query.getQuery(this.exp1);
        }
        if (this.condition != 0 && this.value2 == NO_CONSTANT) {
            this.q2 = Query.getQuery(this.exp2);
        }
        if (nextExp != null) {
            this.nextTest = new SimpleTest(this, nextExp);
        }
    }

    protected int checkOperator(String str) throws ComplexException {
        int length = str.length();
        int i = 0;
        int exp2Index = -1;
        while (i < length) {
            char c;
            if ((c = str.charAt(i++)) == '&' && i < length && str.charAt(i) == '&') {
                this.operator = 1;
                if (exp2Index >= 0) {
                    this.exp2 = this.exp2.substring(0, i - exp2Index - 1).trim();
                }
                return i - 1;
            }
            if (c == '|' && i < length && str.charAt(i) == '|') {
                this.operator = 2;
                if (exp2Index >= 0) {
                    this.exp2 = this.exp2.substring(0, i - exp2Index - 1).trim();
                }
                return i - 1;
            }
            if (c == '\'' && i < length) {
                if ((i = str.indexOf(39, i)) < 0) {
                    throw new IllegalArgumentException("Invalid expression, no matching quote found: " + str);
                }
                ++i;
                continue;
            }
            if (c == '=' && i < length && str.charAt(i) == '=') {
                this.condition = 1;
                this.exp1 = str.substring(0, i - 1).trim();
                this.exp2 = str.substring(++i);
                exp2Index = i;
                continue;
            }
            if (c == '!' && i < length && str.charAt(i) == '=') {
                this.condition = 2;
                this.exp1 = str.substring(0, i - 1).trim();
                this.exp2 = str.substring(++i);
                exp2Index = i;
                continue;
            }
            if (c == '<' && i < length && str.charAt(i) == '=') {
                this.condition = 6;
                this.exp1 = str.substring(0, i - 1).trim();
                this.exp2 = str.substring(++i);
                exp2Index = i;
                continue;
            }
            if (c == '<') {
                this.condition = 5;
                this.exp1 = str.substring(0, i - 1).trim();
                this.exp2 = str.substring(i);
                exp2Index = i;
                continue;
            }
            if (c == '>' && i < length && str.charAt(i) == '=') {
                this.condition = 4;
                this.exp1 = str.substring(0, i - 1).trim();
                this.exp2 = str.substring(++i);
                exp2Index = i;
                continue;
            }
            if (c != '>') continue;
            this.condition = 3;
            this.exp1 = str.substring(0, i - 1).trim();
            this.exp2 = str.substring(i);
            exp2Index = i;
        }
        if (this.exp2 != null) {
            this.exp2 = this.exp2.trim();
        }
        return -1;
    }

    protected Object getConstant(String exp) {
        Query q = Query.getQuery(exp);
        QuerySegment[] segments = q.getSegments();
        QuerySegment segment = segments[0];
        switch (segment.getType()) {
            case 0: {
                return segment.getId();
            }
            case 12: {
                return segment.getValues().get(0);
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 13: {
                return null;
            }
        }
        return NO_CONSTANT;
    }

    public boolean test(ValueStack stack) {
        return this.test(stack, null, null);
    }

    protected boolean test(ValueStack stack, Object prevVal1, Object prevVal2) {
        Object val2 = null;
        boolean result = false;
        Object val1 = this.value1 == NO_CONSTANT ? (this.sameVal1 == 0 ? stack.findValue(this.q1) : (this.sameVal1 == 1 ? prevVal1 : prevVal2)) : this.value1;
        if (this.condition == 0) {
            boolean bl = result = val1 != null;
            if (this.neg1) {
                result = !result;
            }
        } else {
            val2 = this.value2 == NO_CONSTANT ? (this.sameVal2 == 0 ? stack.findValue(this.q2) : (this.sameVal2 == 1 ? prevVal1 : prevVal2)) : this.value2;
            int comparison = -1;
            if (val1 == null || val2 == null) {
                if (val1 == null && val2 == null) {
                    comparison = 0;
                } else if (val2 == null) {
                    comparison = 1;
                }
            } else if (val1 instanceof Number && val2 instanceof Number) {
                double number2;
                double number1 = ((Number)val1).doubleValue();
                if (number1 > (number2 = ((Number)val2).doubleValue())) {
                    comparison = 1;
                } else if (number1 == number2) {
                    long longBits2;
                    long longBits1 = Double.doubleToLongBits(number1);
                    if (longBits1 > (longBits2 = Double.doubleToLongBits(number2))) {
                        comparison = 1;
                    } else if (longBits1 == longBits2) {
                        comparison = 0;
                    }
                }
            } else {
                comparison = val1.getClass().equals(val2.getClass()) && val1 instanceof Comparable ? ((Comparable)val1).compareTo((Comparable)val2) : val1.toString().compareTo(val2.toString());
            }
            result = this.resolve(comparison, this.condition);
        }
        switch (this.operator) {
            case 0: {
                return result;
            }
            case 1: {
                if (result) {
                    return this.nextTest.test(stack, val1, val2);
                }
                return false;
            }
            case 2: {
                if (result) {
                    return true;
                }
                return this.nextTest.test(stack, val1, val2);
            }
        }
        return false;
    }

    protected boolean resolve(int comp, int condition) {
        if (comp == 0) {
            switch (condition) {
                case 1: 
                case 4: 
                case 6: {
                    return true;
                }
            }
            return false;
        }
        if (comp > 0) {
            switch (condition) {
                case 2: 
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
        switch (condition) {
            case 2: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

