/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.client;

import com.opensymphony.webwork.dispatcher.client.ClientException;
import com.opensymphony.webwork.dispatcher.client.ClientRequestInvocation;
import com.opensymphony.webwork.dispatcher.client.ProgressInputStream;
import com.opensymphony.webwork.dispatcher.client.ProgressNotification;
import com.opensymphony.webwork.dispatcher.client.ProgressOutputStream;
import com.opensymphony.webwork.dispatcher.client.RemoteResult;
import com.opensymphony.webwork.dispatcher.client.TransportFactoryBase;
import com.opensymphony.webwork.dispatcher.client.TransportHttpTrust;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.net.www.protocol.https.HttpsURLConnectionImpl;

public class TransportHttp
extends TransportFactoryBase {
    private static final Log log = LogFactory.getLog(TransportHttp.class);
    public static final String REPLY_CONTENT_SIZE = new String("Reply_Content_Size");
    public static final String KEY_LOOKUP_SSL = "com.opensymphony.webwork.dispatcher.client.lookupSslInformation";
    public static final String KEY_URL = "com.opensymphony.webwork.dispatcher.client.url";
    public static final String KEY_RETRY_MAXIMUM = "com.opensymphony.webwork.dispatcher.client.retryMaximum";
    public static final String KEY_RETRY_DELAY = "com.opensymphony.webwork.dispatcher.client.retryDelay";
    public static final String KEY_TRUST_MANAGER = "com.opensymphony.webwork.dispatcher.client.trustManager";
    private Properties factoryInformation;
    private URL url;
    private boolean lookupSslInformation;
    private int retryMaximum;
    private int securityLevel = 1;
    private long retryDelay;

    public TransportHttp(Properties properties) throws ClientException {
        this.setProperties(properties);
    }

    @Override
    public void setProperties(Properties properties) throws ClientException {
        super.setProperties(properties);
        try {
            this.url = new URL(properties.getProperty(KEY_URL));
        }
        catch (MalformedURLException mfe) {
            throw new ClientException(mfe);
        }
        Boolean ssl = new Boolean(properties.getProperty(KEY_LOOKUP_SSL, "true"));
        this.lookupSslInformation = ssl;
        try {
            this.retryMaximum = new Integer(properties.getProperty(KEY_RETRY_MAXIMUM, "3"));
            this.retryDelay = new Long(properties.getProperty(KEY_RETRY_DELAY, "5000"));
        }
        catch (NumberFormatException nfe) {
            throw new ClientException(nfe);
        }
        this.factoryInformation = new Properties();
        this.factoryInformation.setProperty("Transport", "WebWork 2 HTTP(S) Provider");
        this.factoryInformation.setProperty("URL", this.url.toString());
        this.factoryInformation.setProperty("Retry Maximum", new Integer(this.retryMaximum).toString());
        this.factoryInformation.setProperty("Retry Delay", new Long(this.retryDelay).toString());
        if (this.url.getProtocol().equals("https")) {
            this.factoryInformation.setProperty("Lookup SSL Information", new Boolean(this.lookupSslInformation).toString());
            String trustManager = properties.getProperty(KEY_TRUST_MANAGER, "none");
            if (trustManager.equals("none")) {
                log.debug((Object)"HTTPS URL; using standard Java certificate trusts");
            } else {
                SSLSocketFactory sslSocketFactory;
                log.debug((Object)("HTTPS URL; creating customised trust manager " + trustManager));
                try {
                    Class<?> clazz = Class.forName(trustManager);
                    TransportHttpTrust trust = (TransportHttpTrust)clazz.newInstance();
                    sslSocketFactory = trust.start(properties);
                    this.factoryInformation.setProperty("Trust Manager", trustManager);
                    this.factoryInformation.putAll((Map<?, ?>)trust.serviceInformation());
                    if (trust.isEncrypted()) {
                        this.securityLevel = 2;
                    }
                    if (trust.isIdentified()) {
                        this.securityLevel = 3;
                    }
                }
                catch (ClassCastException cce) {
                    throw new ClientException(cce);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new ClientException(cnfe);
                }
                catch (InstantiationException ie) {
                    throw new ClientException(ie);
                }
                catch (IllegalAccessException iae) {
                    throw new ClientException(iae);
                }
                HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
                log.debug((Object)"Completed setup of customised SSL Socket Factory");
            }
        }
    }

    @Override
    public RemoteResult execute(ClientRequestInvocation invocation) throws ClientException {
        RemoteResult actionResult = null;
        String id = this.generateRequestId();
        ProgressNotification notification = new ProgressNotification(id);
        notification.setFactoryInformation(this.factoryInformation);
        notification.setSecurity(this.securityLevel);
        int count = 0;
        int transmitSize = -1;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(invocation);
            oos.flush();
            oos.close();
            transmitSize = baos.size();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        while (actionResult == null && count < this.retryMaximum) {
            try {
                int contentLength;
                HttpURLConnection uc;
                block25: {
                    notification.setStatus(10);
                    this.getProgressConsumer().notify(notification);
                    ++count;
                    uc = (HttpURLConnection)this.url.openConnection();
                    uc.setUseCaches(false);
                    uc.setDefaultUseCaches(false);
                    uc.setDoInput(true);
                    uc.setDoOutput(true);
                    uc.setRequestProperty("Content-Type", "application/octet-stream");
                    if (this.sessionId.equals(SESSION_UNDEFINED)) {
                        log.debug((Object)("Session ID is undefined (" + id + ")"));
                    } else {
                        uc.setRequestProperty("Cookie", "JSESSIONID=" + this.sessionId);
                        log.debug((Object)("Sending session ID: " + this.sessionId + " (" + id + ")"));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Attempt " + count + " to connect to " + this.url + " (" + id + ")"));
                    }
                    notification.setStatus(1);
                    this.getProgressConsumer().notify(notification);
                    uc.connect();
                    Properties security = new Properties();
                    security.setProperty("Status", "Not a secure connection");
                    if (this.url.getProtocol().equals("https") && !this.lookupSslInformation) {
                        security.setProperty("Status", "X509 Certificates not looked up");
                    }
                    if (this.url.getProtocol().equals("https") && this.lookupSslInformation) {
                        if (uc instanceof HttpsURLConnectionImpl) {
                            HttpsURLConnectionImpl sslUc = (HttpsURLConnectionImpl)uc;
                            X509Certificate[] cert = (X509Certificate[])sslUc.getServerCertificates();
                            security.setProperty("Status", "Found " + cert.length + " X509 certificates");
                            for (int i = 0; i < cert.length; ++i) {
                                try {
                                    byte[] abyte0 = cert[i].getEncoded();
                                    MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                                    byte[] abyte1 = messageDigest.digest(abyte0);
                                    String decryptedDigest = this.toHexString(abyte1);
                                    security.setProperty("Cert " + i + " Fingerprint (SHA)", decryptedDigest);
                                }
                                catch (Exception ignored) {
                                    // empty catch block
                                }
                                String validity = "Valid";
                                try {
                                    cert[i].checkValidity();
                                }
                                catch (CertificateExpiredException ex) {
                                    validity = "Expired!";
                                }
                                catch (CertificateNotYetValidException ex) {
                                    validity = "Not Yet Valid";
                                }
                                security.setProperty("Cert " + i + " Validity", validity);
                                security.setProperty("Cert " + i + " Valid From", cert[i].getNotBefore().toString());
                                security.setProperty("Cert " + i + " Valid Until", cert[i].getNotAfter().toString());
                                security.setProperty("Cert " + i + " Version", new Integer(cert[i].getVersion()).toString());
                                security.setProperty("Cert " + i + " Serial No", cert[i].getSerialNumber().toString());
                                security.setProperty("Cert " + i + " Cipher", sslUc.getCipherSuite());
                                security.setProperty("Cert " + i + " Subject", cert[i].getSubjectDN().getName());
                                security.setProperty("Cert " + i + " Issuer", cert[i].getIssuerDN().getName());
                            }
                        } else {
                            security.setProperty("Status", "Unknown HTTPS Provider");
                        }
                    }
                    notification.setSecurityInformation(security);
                    ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new ProgressOutputStream(notification, this.getProgressConsumer(), this.getProperties(), uc.getOutputStream(), transmitSize)));
                    out.writeObject(invocation);
                    out.flush();
                    out.close();
                    contentLength = -1;
                    try {
                        contentLength = uc.getHeaderFieldInt(REPLY_CONTENT_SIZE, -1);
                    }
                    catch (Exception ex) {
                        if (!log.isDebugEnabled()) break block25;
                        log.debug((Object)("Could not determine content length (" + id + ")"));
                    }
                }
                BufferedInputStream bis = new BufferedInputStream(new ProgressInputStream(notification, this.getProgressConsumer(), this.getProperties(), uc.getInputStream(), contentLength));
                ObjectInputStream in = new ObjectInputStream(bis);
                actionResult = (RemoteResult)in.readObject();
                in.close();
                notification.setStatus(10);
                this.getProgressConsumer().notify(notification);
                if (this.sessionId.equals(actionResult.getSessionId())) continue;
                log.debug((Object)("Received new session ID: " + actionResult.getSessionId() + " (" + id + ")"));
                this.sessionId = actionResult.getSessionId();
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)ioe);
                }
                if (count < this.retryMaximum) {
                    log.debug((Object)("Delaying retry for " + this.retryDelay + " milliseconds (" + id + ")"));
                    notification.setStatus(6);
                    this.getProgressConsumer().notify(notification);
                    try {
                        Thread.sleep(this.retryDelay);
                    }
                    catch (InterruptedException ignored) {}
                    continue;
                }
                log.debug((Object)("Maximum retry count reached (" + id + ")"));
                notification.setStatus(10);
                this.getProgressConsumer().notify(notification);
                throw new ClientException("Maximum retry count reached; aborting");
            }
            catch (ClassNotFoundException ce) {
                log.error((Object)ce);
                notification.setStatus(10);
                this.getProgressConsumer().notify(notification);
                throw new ClientException(ce);
            }
        }
        return actionResult;
    }

    private void byte2hex(byte byte0, StringBuffer stringbuffer) {
        char[] ac = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int i = (byte0 & 0xF0) >> 4;
        int j = byte0 & 0xF;
        stringbuffer.append(ac[i]);
        stringbuffer.append(ac[j]);
    }

    private String toHexString(byte[] abyte0) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = abyte0.length;
        for (int j = 0; j < i; ++j) {
            this.byte2hex(abyte0[j], stringbuffer);
            if (j >= i - 1) continue;
            stringbuffer.append(":");
        }
        return stringbuffer.toString();
    }
}

