/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.dispatcher.multipart;

import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequest;
import http.utils.multipartrequest.MultipartRequest;
import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class PellMultiPartRequest
extends MultiPartRequest {
    private ServletMultipartRequest multi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PellMultiPartRequest(HttpServletRequest servletRequest, String saveDir, int maxSize) throws IOException {
        PellMultiPartRequest pellMultiPartRequest = this;
        synchronized (pellMultiPartRequest) {
            PellMultiPartRequest.setEncoding();
            this.multi = new ServletMultipartRequest(servletRequest, saveDir, maxSize);
        }
    }

    @Override
    public Enumeration getFileParameterNames() {
        return this.multi.getFileParameterNames();
    }

    @Override
    public String[] getContentType(String fieldName) {
        return new String[]{this.multi.getContentType(fieldName)};
    }

    @Override
    public File[] getFile(String fieldName) {
        return new File[]{this.multi.getFile(fieldName)};
    }

    @Override
    public String[] getFileNames(String fieldName) {
        return new String[]{this.multi.getFile(fieldName).getName()};
    }

    @Override
    public String[] getFilesystemName(String fieldName) {
        return new String[]{this.multi.getFileSystemName(fieldName)};
    }

    @Override
    public String getParameter(String name) {
        return this.multi.getURLParameter(name);
    }

    @Override
    public Enumeration getParameterNames() {
        return this.multi.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        Enumeration enumeration = this.multi.getURLParameters(name);
        if (!enumeration.hasMoreElements()) {
            return null;
        }
        ArrayList values = new ArrayList();
        while (enumeration.hasMoreElements()) {
            values.add(enumeration.nextElement());
        }
        return values.toArray(new String[values.size()]);
    }

    private static void setEncoding() {
        String encoding = null;
        try {
            encoding = Configuration.getString("webwork.i18n.encoding");
            if (encoding != null) {
                MultipartRequest.setEncoding((String)encoding);
            } else {
                MultipartRequest.setEncoding((String)"UTF-8");
            }
        }
        catch (IllegalArgumentException e) {
            log.info((Object)"Could not get encoding property 'webwork.i18n.encoding' for file upload.  Using system default");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Encoding " + encoding + " is not a valid encoding.  Please check your webwork.properties file."));
        }
    }
}

