/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.jasperreports;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.dispatcher.WebWorkResultSupport;
import com.opensymphony.webwork.views.jasperreports.JasperReportConstants;
import com.opensymphony.webwork.views.jasperreports.OgnlValueStackDataSource;
import com.opensymphony.webwork.views.jasperreports.OgnlValueStackShadowMap;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporter;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JasperExportManager;
import dori.jasper.engine.JasperFillManager;
import dori.jasper.engine.JasperManager;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.JasperReport;
import dori.jasper.engine.export.JRCsvExporter;
import dori.jasper.engine.export.JRHtmlExporter;
import dori.jasper.engine.export.JRHtmlExporterParameter;
import dori.jasper.engine.export.JRXlsExporter;
import dori.jasper.engine.export.JRXmlExporter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JasperReportsResult
extends WebWorkResultSupport
implements JasperReportConstants {
    private static final Log LOG = LogFactory.getLog(JasperReportsResult.class);
    protected String IMAGES_DIR = "/images/";
    private String dataSource;
    private String format;

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        if (this.format == null) {
            this.format = "PDF";
        }
        if (this.dataSource == null) {
            String message = "No dataSource specified...";
            LOG.error((Object)message);
            throw new RuntimeException(message);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating JasperReport for dataSource = " + this.dataSource + ", format = " + this.format));
        }
        HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.dispatcher.HttpServletResponse");
        OgnlValueStack stack = invocation.getStack();
        OgnlValueStackDataSource stackDataSource = new OgnlValueStackDataSource(stack, this.dataSource);
        if (this.parse) {
            this.format = TextParseUtil.translateVariables((String)this.format, (OgnlValueStack)stack);
            this.dataSource = TextParseUtil.translateVariables((String)this.dataSource, (OgnlValueStack)stack);
        }
        if (!TextUtils.stringSet((String)this.format)) {
            this.format = "PDF";
        }
        if (!"contype".equals(request.getHeader("User-Agent"))) {
            ServletContext servletContext = ((ServletConfig)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.dispatcher.ServletConfig")).getServletContext();
            String systemId = servletContext.getRealPath(finalLocation);
            OgnlValueStackShadowMap parameters = new OgnlValueStackShadowMap(stack);
            File directory = new File(systemId.substring(0, systemId.lastIndexOf(File.separator)));
            parameters.put("reportDirectory", directory);
            byte[] output = null;
            JasperPrint jasperPrint = null;
            try {
                JasperReport jasperReport = JasperManager.loadReport((String)systemId);
                jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)stackDataSource);
            }
            catch (JRException e) {
                LOG.error((Object)("Error building report for uri " + systemId), (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            try {
                if (this.format.equals("PDF")) {
                    response.setContentType("application/pdf");
                    output = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
                } else {
                    JRCsvExporter exporter = null;
                    if (this.format.equals("CSV")) {
                        response.setContentType("text/plain");
                        exporter = new JRCsvExporter();
                    } else if (this.format.equals("HTML")) {
                        response.setContentType("text/html");
                        HashMap imagesMap = new HashMap();
                        request.getSession().setAttribute("IMAGES_MAP", imagesMap);
                        exporter = new JRHtmlExporter();
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
                        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(request.getContextPath() + this.IMAGES_DIR));
                    } else if (this.format.equals("XLS")) {
                        response.setContentType("application/vnd.ms-excel");
                        exporter = new JRXlsExporter();
                    } else if (this.format.equals("XML")) {
                        response.setContentType("text/xml");
                        exporter = new JRXmlExporter();
                    } else {
                        throw new ServletException("Unknown report format: " + this.format);
                    }
                    output = this.exportReportToBytes(jasperPrint, (JRExporter)exporter);
                }
            }
            catch (JRException e) {
                String message = "Error producing " + this.format + " report for uri " + systemId;
                LOG.error((Object)message, (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            response.setContentLength(output.length);
            try {
                ServletOutputStream ouputStream = response.getOutputStream();
                ouputStream.write(output);
                ouputStream.flush();
                ouputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error writing report output", (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            response.setContentType("application/pdf");
            response.setContentLength(0);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error writing report output", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] exportReportToBytes(JasperPrint jasperPrint, JRExporter exporter) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        exporter.exportReport();
        byte[] output = baos.toByteArray();
        return output;
    }
}

