/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config;

import com.opensymphony.util.FileManager;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.impl.DefaultConfiguration;
import com.opensymphony.xwork.config.providers.XmlConfigurationProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManager {
    protected static final Log LOG = LogFactory.getLog(ConfigurationManager.class);
    protected static Configuration configurationInstance;
    private static List configurationProviders;

    private ConfigurationManager() {
    }

    public static synchronized void setConfiguration(Configuration configuration) {
        configurationInstance = configuration;
    }

    public static synchronized Configuration getConfiguration() {
        if (configurationInstance == null) {
            configurationInstance = new DefaultConfiguration();
            configurationInstance.reload();
        } else {
            ConfigurationManager.conditionalReload();
        }
        return configurationInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getConfigurationProviders() {
        List list = configurationProviders;
        synchronized (list) {
            if (configurationProviders.size() == 0) {
                configurationProviders.add(new XmlConfigurationProvider());
            }
            return configurationProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfigurationProvider(ConfigurationProvider provider) {
        List list = configurationProviders;
        synchronized (list) {
            if (!configurationProviders.contains(provider)) {
                configurationProviders.add(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearConfigurationProviders() {
        List list = configurationProviders;
        synchronized (list) {
            for (ConfigurationProvider provider : configurationProviders) {
                provider.destroy();
            }
            configurationProviders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void destroyConfiguration() {
        List list = configurationProviders;
        synchronized (list) {
            configurationProviders = new ArrayList();
            configurationInstance = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void conditionalReload() {
        if (FileManager.isReloadingConfigs()) {
            boolean reload;
            List list = configurationProviders;
            synchronized (list) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Checking ConfigurationProviders for reload.");
                }
                reload = false;
                for (ConfigurationProvider provider : ConfigurationManager.getConfigurationProviders()) {
                    if (!provider.needsReload()) continue;
                    reload = true;
                    break;
                }
            }
            if (reload) {
                configurationInstance.reload();
            }
        }
    }

    static {
        configurationProviders = new ArrayList();
        ConfigurationManager.destroyConfiguration();
    }
}

