/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.basicauth;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BasicProcessingFilterEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private String realmName;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.realmName, (String)"realmName must be specified");
    }

    public void commence(ServletRequest request, ServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realmName + "\"");
        httpResponse.sendError(401, authException.getMessage());
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }
}

