/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.dome;

import java.util.ArrayList;
import java.util.HashMap;
import org.agmip.ace.AcePathfinder;
import org.agmip.ace.util.AcePathfinderUtil;
import org.agmip.dome.Command;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assume
extends Command {
    public static final Logger log = LoggerFactory.getLogger(Assume.class);

    public static void run(HashMap m, String var, String[] args, boolean replace) {
        var = var.toLowerCase();
        String assumedValue = args[0].startsWith("$") ? Command.getRawValue(m, args[0].substring(1).toLowerCase()) : args[0];
        String path = AcePathfinder.INSTANCE.getPath(var);
        if (path == null) {
            path = "";
        }
        if (replace) {
            Assume.replace(m, var, assumedValue, path);
        } else {
            Assume.fill(m, var, assumedValue, path);
        }
    }

    private static void fill(HashMap m, String var, String val, String path) {
        log.debug("Filling {} with {}", (Object)path, (Object)val);
        val = Assume.formatVal(var, val);
        if (path.contains("@")) {
            boolean isEvent = false;
            String eventType = "";
            if (path.contains("!")) {
                String[] tmp = path.split("[@!]");
                eventType = tmp[2];
                isEvent = true;
            }
            ArrayList<HashMap<String, Object>> contents = Command.traverseAndGetSiblings(m, var);
            log.debug("Pre-insert contents: {}", (Object)contents.toString());
            if (contents.size() != 0) {
                for (HashMap<String, Object> item : contents) {
                    String liveEvent = MapUtil.getValueOr(item, (String)"event", (String)"");
                    if (isEvent && (!isEvent || !eventType.equals(liveEvent)) || Assume.varHasValue(item, var, isEvent)) continue;
                    item.put(AcePathfinderUtil.setEventDateVar((String)var, (boolean)isEvent), val);
                }
            } else if (path.contains("!")) {
                log.debug("Creating new event in fill for {}", (Object)var);
                AcePathfinderUtil.insertValue((HashMap)m, (String)var, (String)val, (String)path);
            }
        } else {
            HashMap pointer = AcePathfinderUtil.traverseToPoint((HashMap)m, (String)path);
            if (pointer == null) {
                pointer = m;
            }
            if (!Assume.varHasValue(pointer, var, false)) {
                AcePathfinderUtil.insertValue((HashMap)m, (String)var, (String)val, (String)path);
            }
        }
    }

    private static void replace(HashMap m, String var, String val, String path) {
        log.debug("Replacing {} with path {}", (Object)var, (Object)path);
        val = Assume.formatVal(var, val);
        if (path.contains("@")) {
            ArrayList<HashMap<String, Object>> contents;
            boolean isEvent = false;
            String eventType = "";
            if (path.contains("!")) {
                isEvent = true;
                String[] tmp = path.split("[@!]");
                eventType = tmp[2];
            }
            if ((contents = Assume.traverseAndGetSiblings(m, var)).size() == 0) {
                AcePathfinderUtil.insertValue((HashMap)m, (String)var, (String)val, (String)path);
            } else {
                boolean replaced = false;
                for (HashMap<String, Object> item : contents) {
                    if ((!isEvent || !MapUtil.getValueOr(item, (String)"event", (String)"").equals(eventType)) && isEvent) continue;
                    replaced = true;
                    item.put(AcePathfinderUtil.setEventDateVar((String)var, (boolean)isEvent), val);
                }
                if (!replaced) {
                    AcePathfinderUtil.insertValue((HashMap)m, (String)var, (String)val, (String)path);
                }
            }
            log.debug("Current contents: {}", (Object)contents.toString());
        } else {
            HashMap pointer = AcePathfinderUtil.traverseToPoint((HashMap)m, (String)path);
            if (pointer == null) {
                log.debug("pointer not found - creating new");
                AcePathfinderUtil.insertValue((HashMap)m, (String)var, (String)val, (String)path);
            } else {
                pointer.put(var, val);
            }
        }
    }

    private static String formatVal(String var, String val) {
        if (val == null) {
            return val;
        }
        String ret = val;
        if (AcePathfinderUtil.isDate((String)var) && !(ret = val.replaceAll("[-/:]", "")).matches("\\d{8,8}")) {
            log.error("Found unsupported date format: {} for {}", (Object)val, (Object)var);
            ret = val;
        }
        return ret;
    }
}

