/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.dome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.agmip.ace.AcePathfinder;
import org.agmip.ace.util.AcePathfinderUtil;
import org.agmip.common.Functions;
import org.agmip.dome.Command;
import org.agmip.dome.DomeFunctions;
import org.agmip.functions.ExperimentHelper;
import org.agmip.functions.SoilHelper;
import org.agmip.functions.WeatherHelper;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Calculate
extends Command {
    public static final Logger log = LoggerFactory.getLogger(Calculate.class);

    public static void run(HashMap m, String var, String[] args, boolean replace) {
        var = var.toLowerCase();
        String fun = args[0].toUpperCase();
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        HashMap calcResults = null;
        boolean mapModified = false;
        boolean destructiveMode = false;
        log.debug("Attempting to apply DOME function: {}", (Object)fun);
        if (fun.equals("OFFSET_DATE()") || fun.equals("DATE_OFFSET()")) {
            if (newArgs.length < 2) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            calcResults = DomeFunctions.dateOffset(m, var, newArgs[0], newArgs[1]);
        } else if (fun.equals("OFFSET()")) {
            if (newArgs.length < 2) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            calcResults = DomeFunctions.numericOffset(m, var, newArgs[0], newArgs[1]);
        } else if (fun.equals("MULTIPLY()")) {
            if (newArgs.length < 2) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            calcResults = DomeFunctions.multiply(m, var, newArgs[0], newArgs[1]);
        } else if (fun.equals("TRANSPOSE()")) {
            if (newArgs.length < 1) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            ArrayList<String> inputArr = new ArrayList<String>();
            inputArr.addAll(Arrays.asList(newArgs));
            calcResults = new HashMap();
            calcResults.put((String)var, inputArr);
        } else if (fun.equals("PCTAWC()")) {
            if (newArgs.length != 1) {
                log.error("Invalid number of arguments for {}", (Object)fun);
                return;
            }
            destructiveMode = true;
            calcResults = DomeFunctions.percentAvailWaterContent(m, newArgs[0]);
        } else if (fun.equals("TAVAMP()")) {
            if (newArgs.length != 0) {
                log.warn("Too many arguments for {}", (Object)fun);
            }
            calcResults = DomeFunctions.getTavAndAmp(m);
        } else if (fun.equals("REFET()")) {
            if (newArgs.length != 0) {
                log.warn("Too many arguments for {}", (Object)fun);
            }
            calcResults = WeatherHelper.getEto((HashMap)m);
        } else if (fun.equals("ICN_DIST()")) {
            if (newArgs.length < 1) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            calcResults = SoilHelper.getIcnDistribution((HashMap)m, (String)newArgs[0]);
        } else if (fun.equals("FERT_DIST()")) {
            if (newArgs.length < 6) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            int numOfApplications = Functions.numericStringToBigInteger((String)newArgs[0]).intValue();
            if (newArgs.length < numOfApplications * 2 + 4) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            ArrayList<String> offset = new ArrayList<String>();
            ArrayList<String> pct = new ArrayList<String>();
            for (int i = 4; i < newArgs.length; ++i) {
                if (i % 2 == 0) {
                    offset.add(newArgs[i]);
                    continue;
                }
                pct.add(newArgs[i]);
            }
            log.debug("Calling with offset: {} and pct: {}", offset, pct);
            String[] offsetArr = offset.toArray(new String[offset.size()]);
            String[] pctArr = pct.toArray(new String[pct.size()]);
            ArrayList feEvents = ExperimentHelper.getFertDistribution((HashMap)m, (String)newArgs[0], (String)newArgs[1], (String)newArgs[2], (String)newArgs[3], (String[])offsetArr, (String[])pctArr);
            ArrayList events = MapUtil.getBucket((Map)m, (String)"management").getDataList();
            events.addAll(feEvents);
            mapModified = true;
        } else if (fun.equals("OM_DIST()")) {
            if (newArgs.length < 6) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            ArrayList newEvents = ExperimentHelper.getOMDistribution((HashMap)m, (String)newArgs[0], (String)newArgs[1], (String)newArgs[2], (String)newArgs[3], (String)newArgs[4], (String)newArgs[5]);
            ArrayList events = MapUtil.getBucket((Map)m, (String)"management").getDataList();
            events.addAll(newEvents);
            mapModified = true;
        } else if (fun.equals("ROOT_DIST()")) {
            if (newArgs.length < 3) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            calcResults = SoilHelper.getRootDistribution((HashMap)m, (String)var, (String)newArgs[0], (String)newArgs[1], (String)newArgs[2]);
        } else if (fun.equals("STABLEC()")) {
            HashMap soilData = (HashMap)MapUtil.getObjectOr((Map)m, (Object)"soil", new HashMap());
            String appliedDomeFuns = MapUtil.getValueOr((Map)soilData, (String)"applied_dome_functions", (String)"").toUpperCase();
            if (appliedDomeFuns.contains("STABLEC()")) {
                log.debug("Skip applying STABLEC since it has already been applied to this soil site data.");
                mapModified = true;
            } else {
                if (newArgs.length < 3) {
                    log.error("Not enough arguments for {}", (Object)fun);
                    return;
                }
                calcResults = ExperimentHelper.getStableCDistribution((HashMap)m, (String)newArgs[0], (String)newArgs[1], (String)newArgs[2]);
                appliedDomeFuns = appliedDomeFuns.equals("") ? "STABLEC()" : appliedDomeFuns + "|STABLEC()";
                soilData.put("applied_dome_functions", appliedDomeFuns);
            }
        } else if (fun.equals("REMOVE_ALL_EVENTS()")) {
            if (!replace) {
                log.error("Cannot remove all events from a FILL command");
                return;
            }
            DomeFunctions.removeAllEventsExceptCropInfo(m);
            mapModified = true;
        } else if (fun.equals("AUTO_PDATE()")) {
            if (newArgs.length < 4) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            calcResults = ExperimentHelper.getAutoFillPlantingDate((HashMap)m, (String)newArgs[0], (String)newArgs[1], (String)newArgs[2], (String)newArgs[3]);
        } else if (fun.equals("PADDY()")) {
            if (newArgs.length < 6) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            int numOfApplications = Functions.numericStringToBigInteger((String)newArgs[0]).intValue();
            int reqNum = numOfApplications * 3 + 3;
            if (newArgs.length < reqNum) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            ArrayList<String> offset = new ArrayList<String>();
            ArrayList<String> maxVal = new ArrayList<String>();
            ArrayList<String> minVal = new ArrayList<String>();
            if (newArgs.length > reqNum) {
                log.warn("Too many arguments for {}, will only apply first {} group of bund information", (Object)fun, (Object)numOfApplications);
            }
            for (int i = 3; i < reqNum; ++i) {
                if (i % 3 == 0) {
                    offset.add(newArgs[i]);
                    continue;
                }
                if (i % 3 == 1) {
                    maxVal.add(newArgs[i]);
                    continue;
                }
                minVal.add(newArgs[i]);
            }
            log.debug("Calling with offset: {}, max: {} and min: {}", new Object[]{offset, maxVal, minVal});
            String[] offsetArr = offset.toArray(new String[offset.size()]);
            String[] maxArr = maxVal.toArray(new String[maxVal.size()]);
            String[] minArr = minVal.toArray(new String[minVal.size()]);
            ArrayList irEvents = ExperimentHelper.getPaddyIrrigation((HashMap)m, (String)newArgs[0], (String)newArgs[1], (String)newArgs[2], (String[])offsetArr, (String[])maxArr, (String[])minArr);
            ArrayList events = MapUtil.getBucket((Map)m, (String)"management").getDataList();
            events.addAll(irEvents);
            mapModified = true;
        } else if (fun.equals("AUTO_IDATE()")) {
            if (newArgs.length < 4) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            int numOfApplications = Functions.numericStringToBigInteger((String)newArgs[0]).intValue();
            int reqNum = numOfApplications * 2 + 2;
            if (newArgs.length < reqNum) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            ArrayList<String> gddArr = new ArrayList<String>();
            ArrayList<String> irvalArr = new ArrayList<String>();
            if (newArgs.length > reqNum) {
                log.warn("Too many arguments for {}, will only apply first {} group of irrigation information", (Object)fun, (Object)numOfApplications);
            }
            for (int i = 2; i < reqNum; ++i) {
                if (i % 2 == 0) {
                    gddArr.add(newArgs[i]);
                    continue;
                }
                irvalArr.add(newArgs[i]);
            }
            log.debug("Calling with GDD: {} and IRVAL: {}", gddArr, irvalArr);
            String[] maxArr = gddArr.toArray(new String[gddArr.size()]);
            String[] minArr = irvalArr.toArray(new String[irvalArr.size()]);
            ArrayList irEvents = ExperimentHelper.getAutoIrrigationEvent((HashMap)m, (String)newArgs[0], (String)newArgs[1], (String[])maxArr, (String[])minArr);
            ArrayList events = MapUtil.getBucket((Map)m, (String)"management").getDataList();
            if (replace) {
                ArrayList<HashMap> newEvents = new ArrayList<HashMap>();
                for (HashMap event : events) {
                    if ("irrigation".equals(MapUtil.getValueOr((Map)event, (String)"event", (String)""))) continue;
                    newEvents.add(event);
                }
                if (newEvents.size() != events.size()) {
                    events.clear();
                    events.addAll(newEvents);
                }
            }
            events.addAll(irEvents);
            mapModified = true;
        } else if (fun.equals("LYRSET()")) {
            HashMap soilData;
            String path = AcePathfinder.INSTANCE.getPath(var);
            boolean isICLayers = false;
            if (path == null || !path.contains("soilLayer")) {
                log.warn("LYRSET() could not work for {}, please try SLLB or ICBL instead", (Object)var);
                return;
            }
            if (path.contains("initial_conditions")) {
                isICLayers = true;
            }
            if (!isICLayers) {
                soilData = (HashMap)MapUtil.getObjectOr((Map)m, (Object)"soil", new HashMap());
                String appliedDomeFuns = MapUtil.getValueOr((Map)soilData, (String)"applied_dome_functions", (String)"").toUpperCase();
                if (appliedDomeFuns.contains("LYRSET()")) {
                    log.debug("Skip applying LYRSET since it has already been applied to this soil site data.");
                    return;
                }
                appliedDomeFuns = appliedDomeFuns.equals("") ? "LYRSET()" : appliedDomeFuns + "|LYRSET()";
                soilData.put("applied_dome_functions", appliedDomeFuns);
            } else {
                soilData = (HashMap)MapUtil.getObjectOr((Map)m, (Object)"initial_conditions", new HashMap());
            }
            if (newArgs.length != 0) {
                log.warn("Too many arguments for {}", (Object)fun);
            }
            ArrayList newLayers = SoilHelper.splittingSoillayer((HashMap)m, (boolean)isICLayers);
            ArrayList layers = new MapUtil.BucketEntry(soilData).getDataList();
            if (newLayers.size() > layers.size()) {
                soilData.put("soilLayer", newLayers);
            }
            mapModified = true;
        } else if (fun.equals("PTCALC()")) {
            if (newArgs.length < 2) {
                log.error("Not enough arguments for {}", (Object)fun);
                return;
            }
            ArrayList<String> vars = new ArrayList<String>();
            for (int i = 1; i < newArgs.length; ++i) {
                vars.add(newArgs[i].toLowerCase());
            }
            calcResults = SoilHelper.getSoilValsFromOthPara((HashMap)m, (String)newArgs[0], vars);
        } else {
            log.error("DOME Function {} unsupported", (Object)fun);
            return;
        }
        if (!mapModified) {
            Calculate.execute(m, calcResults, replace, destructiveMode);
        }
    }

    public static void create(HashMap m, String var, String[] args) {
        var = var.toLowerCase();
        String fun = args[0].toUpperCase();
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        log.debug("Attempting to apply DOME function: {}", (Object)fun);
        if (fun.equals("NEW_EVENT()")) {
            if (newArgs.length < 1) {
                log.error("Not enough arguments for {}", (Object)fun);
            } else if (newArgs.length % 2 != 1) {
                log.warn("There is unpaired variable for {}", (Object)fun);
            }
            HashMap<String, String> info = new HashMap<String, String>();
            for (int i = 2; i < newArgs.length; i += 2) {
                info.put(newArgs[i - 1].toLowerCase(), newArgs[i]);
            }
            HashMap newEvent = ExperimentHelper.createEvent((HashMap)m, (String)var, (String)newArgs[0], info, (boolean)true);
            if (!newEvent.isEmpty()) {
                MapUtil.getBucket((Map)m, (String)"management").getDataList().add(newEvent);
            } else {
                log.warn("No event has been generated");
            }
        } else {
            log.error("DOME Function {} unsupported", (Object)fun);
        }
    }

    private static void execute(HashMap<String, Object> m, HashMap<String, ArrayList<String>> calcResults, boolean replace, boolean destructiveMode) {
        log.debug("Executing with: {}", calcResults);
        if (calcResults.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ArrayList<String>> entry : calcResults.entrySet()) {
            String targetVariable = entry.getKey();
            String targetPath = Command.getPathOrRoot(targetVariable);
            ArrayList<String> values = entry.getValue();
            String var = targetVariable;
            if (targetPath.contains("@")) {
                boolean isEvent = false;
                String eventType = "";
                if (targetPath.contains("!")) {
                    String[] tmp = targetPath.split("[@!]");
                    eventType = tmp[2];
                    isEvent = true;
                    var = AcePathfinderUtil.setEventDateVar((String)targetVariable, (boolean)isEvent);
                }
                ArrayList<HashMap<String, Object>> pointer = Calculate.traverseAndGetSiblings(m, targetVariable);
                log.debug("CALC EXECUTE() pointer: {}", pointer);
                int pointerSize = pointer.size();
                int sourceSize = values.size();
                if (destructiveMode && pointerSize == 0) {
                    log.debug("Destructive adding values for {}", (Object)targetVariable);
                    for (String value : values) {
                        AcePathfinderUtil.insertValue(m, (String)targetVariable, (String)value, (String)targetPath);
                    }
                    continue;
                }
                int j = 0;
                for (int i = 0; i < pointerSize; ++i) {
                    String liveEvent = "";
                    Object objEvent = pointer.get(i).get("event");
                    if (objEvent != null) {
                        liveEvent = (String)objEvent;
                    }
                    if (liveEvent.equals(eventType)) {
                        log.debug("Level 1 passed, i: {} ss: {}", (Object)i, (Object)sourceSize);
                        if (j < sourceSize) {
                            log.debug("Level 2 passed");
                            if (replace || !replace && !Calculate.varHasValue(pointer.get(i), targetVariable, isEvent)) {
                                log.debug("Level 3, writing [{}] now", (Object)var);
                                pointer.get(i).put(var, values.get(j));
                                if (isEvent) {
                                    ++j;
                                }
                            }
                        }
                    }
                    if (isEvent) continue;
                    ++j;
                }
                continue;
            }
            log.debug("targetPath is [{}]", (Object)targetPath);
            if (values.isEmpty()) continue;
            if (targetPath.equals("")) {
                if (!replace && (replace || Calculate.varHasValue(m, targetVariable, false))) continue;
                m.put(targetVariable, values.get(0));
                continue;
            }
            HashMap pointer = AcePathfinderUtil.traverseToPoint(m, (String)targetPath);
            if (pointer == null) {
                log.debug("pointer not found - creating new");
                AcePathfinderUtil.insertValue(m, (String)targetVariable, (String)values.get(0), (String)targetPath);
                continue;
            }
            if (!replace && (replace || Calculate.varHasValue(pointer, targetVariable, false))) continue;
            pointer.put(targetVariable, values.get(0));
        }
    }
}

