/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.dome;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.agmip.ace.AcePathfinder;
import org.agmip.ace.util.AcePathfinderUtil;
import org.agmip.common.Functions;
import org.agmip.dome.Command;
import org.agmip.functions.WeatherHelper;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomeFunctions {
    private static final Logger log = LoggerFactory.getLogger(DomeFunctions.class);
    private static final String MULTIPLY_DEFAULT_FACTOR = "1";

    private DomeFunctions() {
    }

    public static HashMap<String, ArrayList<String>> dateOffset(HashMap m, String var, String base, String offset) {
        return DomeFunctions.offset(m, var, base, offset, true);
    }

    public static HashMap<String, ArrayList<String>> numericOffset(HashMap m, String var, String base, String offset) {
        return DomeFunctions.offset(m, var, base, offset, false);
    }

    private static HashMap<String, ArrayList<String>> offset(HashMap m, String targetVariable, String source, String offset, boolean isDateOffset) {
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        ArrayList<String> toOffset = DomeFunctions.buildInputArray(m, source);
        String sourceVariable = "";
        String sourceEventType = "";
        String targetPath = AcePathfinder.INSTANCE.getPath(targetVariable);
        if (source.startsWith("$")) {
            sourceVariable = source.substring(1).toLowerCase();
        }
        if (targetPath == null) {
            targetPath = "";
        }
        if (targetPath.contains("@")) {
            boolean targetIsEvent = false;
            String targetEventType = "";
            if (targetPath.contains("!")) {
                targetIsEvent = true;
                String[] tmp = targetPath.split("[@!]");
                targetEventType = tmp[2];
                if (!sourceVariable.equals(targetVariable.toLowerCase())) {
                    log.error("Unable to use OFFSET methods with different event variables. [{}] [{}]", (Object)sourceVariable, (Object)targetVariable.toLowerCase());
                    return results;
                }
            }
        }
        log.debug("Items to offset: {}", (Object)toOffset.toString());
        ArrayList<String> result = new ArrayList<String>();
        for (String entry : toOffset) {
            if (isDateOffset) {
                log.debug("Calling dateOffset() with {}, {}", (Object)entry, (Object)offset);
                result.add(Functions.dateOffset((String)entry, (String)offset));
                continue;
            }
            log.debug("Calling numericOffset() with {}, {}", (Object)entry, (Object)offset);
            result.add(Functions.numericOffset((String)entry, (String)offset));
        }
        results.put(targetVariable, result);
        log.debug("Offset results: {}", (Object)results.toString());
        return results;
    }

    public static HashMap<String, ArrayList<String>> multiply(HashMap m, String targetVariable, String f1, String f2) {
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        ArrayList<String> factors1 = DomeFunctions.buildInputArray(m, f1);
        ArrayList<String> factors2 = DomeFunctions.buildInputArray(m, f2);
        ArrayList<String> output = new ArrayList<String>();
        log.debug("F1: {}", (Object)factors1.toString());
        log.debug("F2: {}", (Object)factors2.toString());
        int f1Size = factors1.size();
        if (f1Size < 2) {
            String fact1 = MULTIPLY_DEFAULT_FACTOR;
            if (f1Size == 1 && (fact1 = factors1.get(0)) == null) {
                log.error("Missing factor to multiply: {}", (Object)f1);
                return results;
            }
            for (String fact2 : factors2) {
                if (fact2 == null) {
                    log.error("Missing factor to multiply: {}", (Object)f2);
                    return new HashMap<String, ArrayList<String>>();
                }
                output.add(Functions.multiply((String)fact1, (String)fact2));
            }
        } else {
            int f2Size = factors2.size();
            int iter = f1Size >= f2Size ? f1Size : f2Size;
            for (int i = 0; i < iter; ++i) {
                String fact2;
                String fact1 = MULTIPLY_DEFAULT_FACTOR;
                String string = fact2 = f2Size == 1 ? factors2.get(0) : MULTIPLY_DEFAULT_FACTOR;
                if (i < f1Size && (fact1 = factors1.get(i)) == null) {
                    log.error("Missing factor to multiply: {}", (Object)f1);
                    return new HashMap<String, ArrayList<String>>();
                }
                if (i < f2Size && (fact2 = factors2.get(i)) == null) {
                    log.error("Missing factor to multiply: {}", (Object)f2);
                    return new HashMap<String, ArrayList<String>>();
                }
                output.add(Functions.multiply((String)fact1, (String)fact2));
            }
        }
        results.put(targetVariable, output);
        log.debug("Multiply() results: {}", (Object)results.toString());
        return results;
    }

    public static HashMap<String, ArrayList<String>> percentAvailWaterContent(HashMap m, String icswp) {
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        ArrayList<String> outputICH2O = new ArrayList<String>();
        ArrayList<String> outputICBL = new ArrayList<String>();
        ArrayList<HashMap<String, Object>> soils = Command.traverseAndGetSiblings(m, "sllb");
        if (soils.isEmpty()) {
            log.error("Missing required soil information to calculate ICH2O");
            return results;
        }
        for (HashMap<String, Object> sl : soils) {
            BigDecimal icswpd;
            BigDecimal sllb;
            BigDecimal sldul;
            BigDecimal slll;
            if (!(sl.containsKey("slll") && sl.containsKey("sldul") && sl.containsKey("sllb"))) {
                log.error("Missing SLLL, SLDUL, or SLLB. Cannot calculate ICH2O");
                return results;
            }
            try {
                slll = new BigDecimal(MapUtil.getValueOr(sl, (String)"slll", (String)"0.01"));
                sldul = new BigDecimal(MapUtil.getValueOr(sl, (String)"sldul", (String)"0.0"));
                sllb = new BigDecimal(MapUtil.getValueOr(sl, (String)"sllb", (String)"0.0"));
                icswpd = new BigDecimal(icswp);
                icswpd = icswpd.divide(new BigDecimal(100));
            }
            catch (Exception ex) {
                log.error("Unable to convert a string to a number for PCTAWC()");
                return new HashMap<String, ArrayList<String>>();
            }
            String icsw = sldul.subtract(slll).multiply(icswpd).add(slll).toString();
            outputICH2O.add(icsw);
            outputICBL.add(sllb.toString());
        }
        results.put("icbl", outputICBL);
        results.put("ich2o", outputICH2O);
        log.debug("PCTAWC() returned: {}", (Object)results.toString());
        return results;
    }

    public static HashMap<String, ArrayList<String>> getTavAndAmp(HashMap m) {
        HashMap<String, ArrayList<String>> results = new HashMap<String, ArrayList<String>>();
        HashMap wthData = m.containsKey("weather") || !m.containsKey("dailyWeather") ? (HashMap)MapUtil.getObjectOr((Map)m, (Object)"weather", new HashMap()) : m;
        String appliedDomeFuns = MapUtil.getValueOr((Map)wthData, (String)"applied_dome_functions", (String)"").toUpperCase();
        if (appliedDomeFuns.contains("TAVAMP()")) {
            log.debug("Skip applying TAVAMP since it has already been applied to this weather site data.");
            return results;
        }
        appliedDomeFuns = appliedDomeFuns.equals("") ? "TAVAMP()" : appliedDomeFuns + "|TAVAMP()";
        HashMap ret = WeatherHelper.getTavAndAmp((HashMap)m);
        String tav = (String)ret.get("tav");
        if (tav == null) {
            log.error("Failed to calculate TAV with given data set");
        } else {
            ArrayList<String> arr = new ArrayList<String>();
            arr.add(tav);
            results.put("tav", arr);
        }
        String tamp = (String)ret.get("tamp");
        if (tamp == null) {
            log.error("Failed to calculate TAMP with given data set");
        } else {
            ArrayList<String> arr = new ArrayList<String>();
            arr.add(tamp);
            results.put("tamp", arr);
        }
        wthData.put("applied_dome_functions", appliedDomeFuns);
        return results;
    }

    public static void removeAllEvents(HashMap m) {
        log.debug("ENTERING THE FRAY!!!");
        String path = AcePathfinder.INSTANCE.getPath("pdate");
        log.debug("Looking for path ! {}", (Object)path);
        HashMap pointer = AcePathfinderUtil.traverseToPoint((HashMap)m, (String)path);
        if (pointer != null) {
            log.debug("Pointer RAE: {}", (Object)pointer.toString());
            pointer.remove("events");
        }
    }

    public static void removeAllEventsExceptCropInfo(HashMap m) {
        log.debug("ENTERING THE FRAY2!!!");
        String path = AcePathfinder.INSTANCE.getPath("pdate");
        log.debug("Looking for path ! {}", (Object)path);
        HashMap pointer = AcePathfinderUtil.traverseToPoint((HashMap)m, (String)path);
        if (pointer != null) {
            log.debug("Pointer RAE: {}", (Object)pointer.toString());
            ArrayList events = new MapUtil.BucketEntry(pointer).getDataList();
            ArrayList newEvents = new ArrayList();
            for (HashMap event : events) {
                if (!MapUtil.getValueOr((Map)event, (String)"event", (String)"").equals("planting")) continue;
                HashMap plEvent = new HashMap();
                plEvent.putAll(event);
                plEvent.remove("date");
                newEvents.add(plEvent);
            }
            events.clear();
            events.addAll(newEvents);
        }
    }

    private static ArrayList<String> buildInputArray(HashMap<String, Object> m, String source) {
        log.debug("BIA source: [{}]", (Object)source);
        String sourceVariable = "";
        String sourceEventType = "";
        ArrayList<String> results = new ArrayList<String>();
        if (source.startsWith("$")) {
            sourceVariable = source.substring(1).toLowerCase();
            String sourcePath = Command.getPathOrRoot(sourceVariable);
            boolean sourceIsEvent = false;
            if (sourcePath.contains("@")) {
                if (sourcePath.contains("!")) {
                    String[] tmp = sourcePath.split("[@!]");
                    sourceIsEvent = true;
                    sourceEventType = tmp[2];
                }
                ArrayList<HashMap<String, Object>> pointer = Command.traverseAndGetSiblings(m, sourceVariable);
                for (HashMap<String, Object> entry : pointer) {
                    if ((!sourceIsEvent || !((String)entry.get("event")).equals(sourceEventType)) && sourceIsEvent) continue;
                    String var = AcePathfinderUtil.setEventDateVar((String)sourceVariable, (boolean)sourceIsEvent);
                    log.debug("Looking for var {} in {}", (Object)var, (Object)entry.toString());
                    results.add((String)entry.get(var));
                }
            } else {
                String sourceValue = Command.getRawValue(m, sourceVariable);
                results.add(sourceValue);
            }
        } else {
            results.add(source);
        }
        return results;
    }

    protected static class KVPair {
        private final String key;
        private final String value;

        public KVPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return 47 * (this.key.hashCode() + this.value.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KVPair)) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            return this.key == ((KVPair)obj).getKey() && this.value == ((KVPair)obj).getValue();
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

