/*
 * Decompiled with CFR 0.152.
 */
package org.agmip.dome;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.agmip.dome.Assume;
import org.agmip.functions.ExperimentHelper;
import org.agmip.util.MapUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generate {
    public static final Logger log = LoggerFactory.getLogger(Generate.class);

    public static ArrayList<HashMap<String, String>> run(HashMap m, String[] args, ArrayList<HashMap<String, String>> modifiers) {
        ArrayList<HashMap<String, String>> results = new ArrayList();
        String fun = args[0].toUpperCase();
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        if (modifiers.isEmpty()) {
            HashMap<String, ArrayList<String>> genResults = Generate.execute(m, fun, newArgs);
            for (Map.Entry<String, ArrayList<String>> entry : genResults.entrySet()) {
                String key = entry.getKey();
                boolean i = false;
                for (String value : entry.getValue()) {
                    HashMap<String, String> output = new HashMap<String, String>();
                    output.put(key, value);
                    results.add(output);
                }
            }
        } else {
            log.error("Multiple generators are unsupported in this version.");
            results = modifiers;
        }
        return results;
    }

    public static ArrayList<ArrayList<HashMap<String, String>>> runEvent(HashMap m, String[] args, ArrayList<ArrayList<HashMap<String, String>>> modifiers) {
        ArrayList<ArrayList<HashMap<String, String>>> results;
        String fun = args[0].toUpperCase();
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        if (modifiers.isEmpty()) {
            results = Generate.executeEvent(m, fun, newArgs);
        } else {
            log.error("Multiple generators are unsupported in this version.");
            results = modifiers;
        }
        return results;
    }

    protected static void applyGeneratedRules(HashMap m, HashMap<String, String> rules, String id) {
        String exname = MapUtil.getValueOr((Map)m, (String)"exname", (String)"");
        if (exname.contains("__")) {
            exname = exname.substring(0, exname.indexOf("__"));
        }
        if (id != null) {
            String[] exvalue = new String[]{exname + "__" + id};
            Assume.run(m, "exname", exvalue, true);
        }
        for (Map.Entry<String, String> rule : rules.entrySet()) {
            String[] value = new String[]{rule.getValue()};
            Assume.run(m, rule.getKey(), value, true);
        }
    }

    protected static void applyReplicatedEvents(HashMap m, ArrayList<HashMap<String, String>> events, String id) {
        Generate.applyGeneratedRules(m, new HashMap<String, String>(), id);
        ArrayList oringEvents = MapUtil.getBucket((Map)m, (String)"management").getDataList();
        oringEvents.clear();
        oringEvents.addAll(events);
    }

    private static HashMap<String, ArrayList<String>> execute(HashMap m, String fun, String[] args) {
        if (fun.equals("AUTO_PDATE()")) {
            if (args.length < 4) {
                log.error("Not enough arguments for {}", (Object)fun);
                return new HashMap<String, ArrayList<String>>();
            }
            m.put("origin_pdate", ExperimentHelper.getFstPdate((Map)m, (String)""));
            return ExperimentHelper.getAutoPlantingDate((HashMap)m, (String)args[0], (String)args[1], (String)args[2], (String)args[3]);
        }
        log.error("DOME Function {} unsupported.", (Object)fun);
        return new HashMap<String, ArrayList<String>>();
    }

    private static ArrayList<ArrayList<HashMap<String, String>>> executeEvent(HashMap m, String fun, String[] args) {
        if (fun.equals("AUTO_REPLICATE_EVENTS()")) {
            if (args.length != 0) {
                log.warn("Too many arguments for {}", (Object)fun);
            }
            return ExperimentHelper.getAutoEvent((Map)m);
        }
        log.error("DOME Function {} unsupported. 2", (Object)fun);
        return new ArrayList<ArrayList<HashMap<String, String>>>();
    }
}

