/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.keyvalue;

import alluxio.AlluxioURI;
import alluxio.exception.AccessControlException;
import alluxio.exception.AlluxioException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.master.AbstractMaster;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.options.CreateDirectoryOptions;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalOutputStream;
import alluxio.master.journal.JournalProtoUtils;
import alluxio.master.keyvalue.KeyValueMasterClientServiceHandler;
import alluxio.proto.journal.Journal;
import alluxio.proto.journal.KeyValue;
import alluxio.thrift.KeyValueMasterClientService;
import alluxio.thrift.PartitionInfo;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueMaster
extends AbstractMaster {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final FileSystemMaster mFileSystemMaster;
    private final Map<Long, List<PartitionInfo>> mCompleteStoreToPartitions;
    private final Map<Long, List<PartitionInfo>> mIncompleteStoreToPartitions;

    public static String getJournalDirectory(String baseDirectory) {
        return PathUtils.concatPath((Object)baseDirectory, (Object[])new Object[]{"KeyValueMaster"});
    }

    public KeyValueMaster(FileSystemMaster fileSystemMaster, Journal journal) {
        super(journal, 2);
        this.mFileSystemMaster = fileSystemMaster;
        this.mCompleteStoreToPartitions = new HashMap<Long, List<PartitionInfo>>();
        this.mIncompleteStoreToPartitions = new HashMap<Long, List<PartitionInfo>>();
    }

    public Map<String, TProcessor> getServices() {
        HashMap<String, TProcessor> services = new HashMap<String, TProcessor>();
        services.put("KeyValueMasterClient", (TProcessor)new KeyValueMasterClientService.Processor((KeyValueMasterClientService.Iface)new KeyValueMasterClientServiceHandler(this)));
        return services;
    }

    public String getName() {
        return "KeyValueMaster";
    }

    public synchronized void processJournalEntry(Journal.JournalEntry entry) throws IOException {
        block8: {
            Message innerEntry = JournalProtoUtils.unwrap((Journal.JournalEntry)entry);
            try {
                if (innerEntry instanceof KeyValue.CreateStoreEntry) {
                    this.createStoreFromEntry((KeyValue.CreateStoreEntry)innerEntry);
                    break block8;
                }
                if (innerEntry instanceof KeyValue.CompletePartitionEntry) {
                    this.completePartitionFromEntry((KeyValue.CompletePartitionEntry)innerEntry);
                    break block8;
                }
                if (innerEntry instanceof KeyValue.CompleteStoreEntry) {
                    this.completeStoreFromEntry((KeyValue.CompleteStoreEntry)innerEntry);
                    break block8;
                }
                if (innerEntry instanceof KeyValue.DeleteStoreEntry) {
                    this.deleteStoreFromEntry((KeyValue.DeleteStoreEntry)innerEntry);
                    break block8;
                }
                if (innerEntry instanceof KeyValue.RenameStoreEntry) {
                    this.renameStoreFromEntry((KeyValue.RenameStoreEntry)innerEntry);
                    break block8;
                }
                if (innerEntry instanceof KeyValue.MergeStoreEntry) {
                    this.mergeStoreFromEntry((KeyValue.MergeStoreEntry)innerEntry);
                    break block8;
                }
                throw new IOException(ExceptionMessage.UNEXPECTED_JOURNAL_ENTRY.getMessage(new Object[]{innerEntry}));
            }
            catch (AlluxioException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public synchronized void streamToJournalCheckpoint(JournalOutputStream outputStream) throws IOException {
        List<PartitionInfo> partitions;
        long fileId;
        for (Map.Entry<Long, List<PartitionInfo>> entry : this.mCompleteStoreToPartitions.entrySet()) {
            fileId = entry.getKey();
            partitions = entry.getValue();
            outputStream.writeEntry(this.newCreateStoreEntry(fileId));
            for (PartitionInfo info : partitions) {
                outputStream.writeEntry(this.newCompletePartitionEntry(fileId, info));
            }
            outputStream.writeEntry(this.newCompleteStoreEntry(fileId));
        }
        for (Map.Entry<Long, List<PartitionInfo>> entry : this.mIncompleteStoreToPartitions.entrySet()) {
            fileId = entry.getKey();
            partitions = entry.getValue();
            outputStream.writeEntry(this.newCreateStoreEntry(fileId));
            for (PartitionInfo info : partitions) {
                outputStream.writeEntry(this.newCompletePartitionEntry(fileId, info));
            }
        }
    }

    public void start(boolean isLeader) throws IOException {
        super.start(isLeader);
    }

    public synchronized void completePartition(AlluxioURI path, PartitionInfo info) throws AccessControlException, FileDoesNotExistException, InvalidPathException {
        long fileId = this.mFileSystemMaster.getFileId(path);
        if (fileId == -1L) {
            throw new FileDoesNotExistException(String.format("Failed to completePartition: path %s does not exist", path));
        }
        this.completePartitionInternal(fileId, info);
        this.writeJournalEntry(this.newCompletePartitionEntry(fileId, info));
        this.flushJournal();
    }

    private void completePartitionFromEntry(KeyValue.CompletePartitionEntry entry) throws FileDoesNotExistException {
        PartitionInfo info = new PartitionInfo(entry.getKeyStartBytes().asReadOnlyByteBuffer(), entry.getKeyLimitBytes().asReadOnlyByteBuffer(), entry.getBlockId(), entry.getKeyCount());
        this.completePartitionInternal(entry.getStoreId(), info);
    }

    private void completePartitionInternal(long fileId, PartitionInfo info) throws FileDoesNotExistException {
        if (!this.mIncompleteStoreToPartitions.containsKey(fileId)) {
            throw new FileDoesNotExistException(String.format("Failed to completeStore: KeyValueStore (fileId=%d) was not created before", fileId));
        }
        this.mIncompleteStoreToPartitions.get(fileId).add(new PartitionInfo(info));
    }

    public synchronized void completeStore(AlluxioURI path) throws FileDoesNotExistException, InvalidPathException, AccessControlException {
        long fileId = this.mFileSystemMaster.getFileId(path);
        if (fileId == -1L) {
            throw new FileDoesNotExistException(String.format("Failed to completeStore: path %s does not exist", path));
        }
        this.completeStoreInternal(fileId);
        this.writeJournalEntry(this.newCompleteStoreEntry(fileId));
        this.flushJournal();
    }

    private void completeStoreFromEntry(KeyValue.CompleteStoreEntry entry) throws FileDoesNotExistException {
        this.completeStoreInternal(entry.getStoreId());
    }

    private void completeStoreInternal(long fileId) throws FileDoesNotExistException {
        if (!this.mIncompleteStoreToPartitions.containsKey(fileId)) {
            throw new FileDoesNotExistException(String.format("Failed to completeStore: KeyValueStore (fileId=%d) was not created before", fileId));
        }
        List<PartitionInfo> partitions = this.mIncompleteStoreToPartitions.remove(fileId);
        this.mCompleteStoreToPartitions.put(fileId, partitions);
    }

    public synchronized void createStore(AlluxioURI path) throws FileAlreadyExistsException, InvalidPathException, AccessControlException {
        try {
            this.mFileSystemMaster.createDirectory(path, (CreateDirectoryOptions)CreateDirectoryOptions.defaults().setRecursive(true));
        }
        catch (IOException e) {
            throw new InvalidPathException(String.format("Failed to createStore: can not create path %s", path), (Throwable)e);
        }
        catch (FileDoesNotExistException e) {
            throw Throwables.propagate((Throwable)e);
        }
        long fileId = this.mFileSystemMaster.getFileId(path);
        Preconditions.checkState((fileId != -1L ? 1 : 0) != 0);
        this.createStoreInternal(fileId);
        this.writeJournalEntry(this.newCreateStoreEntry(fileId));
        this.flushJournal();
    }

    private void createStoreFromEntry(KeyValue.CreateStoreEntry entry) throws FileAlreadyExistsException {
        this.createStoreInternal(entry.getStoreId());
    }

    private void createStoreInternal(long fileId) throws FileAlreadyExistsException {
        if (this.mIncompleteStoreToPartitions.containsKey(fileId)) {
            throw new FileAlreadyExistsException(String.format("Failed to createStore: KeyValueStore (fileId=%d) is already created", fileId));
        }
        this.mIncompleteStoreToPartitions.put(fileId, new ArrayList());
    }

    public synchronized void deleteStore(AlluxioURI uri) throws IOException, InvalidPathException, FileDoesNotExistException, AlluxioException {
        long fileId = this.getFileId(uri);
        this.checkIsCompletePartition(fileId, uri);
        this.mFileSystemMaster.delete(uri, true);
        this.deleteStoreInternal(fileId);
        this.writeJournalEntry(this.newDeleteStoreEntry(fileId));
        this.flushJournal();
    }

    private void deleteStoreFromEntry(KeyValue.DeleteStoreEntry entry) {
        this.deleteStoreInternal(entry.getStoreId());
    }

    private void deleteStoreInternal(long fileId) {
        this.mCompleteStoreToPartitions.remove(fileId);
    }

    private long getFileId(AlluxioURI uri) throws AccessControlException, FileDoesNotExistException, InvalidPathException {
        long fileId = this.mFileSystemMaster.getFileId(uri);
        if (fileId == -1L) {
            throw new FileDoesNotExistException(ExceptionMessage.PATH_DOES_NOT_EXIST.getMessage(new Object[]{uri}));
        }
        return fileId;
    }

    void checkIsCompletePartition(long fileId, AlluxioURI uri) throws InvalidPathException {
        if (!this.mCompleteStoreToPartitions.containsKey(fileId)) {
            throw new InvalidPathException(ExceptionMessage.INVALID_KEY_VALUE_STORE_URI.getMessage(new Object[]{uri}));
        }
    }

    public synchronized void renameStore(AlluxioURI oldUri, AlluxioURI newUri) throws IOException, AlluxioException {
        long oldFileId = this.getFileId(oldUri);
        this.checkIsCompletePartition(oldFileId, oldUri);
        try {
            this.mFileSystemMaster.rename(oldUri, newUri);
        }
        catch (FileAlreadyExistsException e) {
            throw new FileAlreadyExistsException(String.format("failed to rename store:the path %s has been used", newUri), (Throwable)e);
        }
        long newFileId = this.mFileSystemMaster.getFileId(newUri);
        Preconditions.checkState((newFileId != -1L ? 1 : 0) != 0);
        this.renameStoreInternal(oldFileId, newFileId);
        this.writeJournalEntry(this.newRenameStoreEntry(oldFileId, newFileId));
        this.flushJournal();
    }

    private void renameStoreInternal(long oldFileId, long newFileId) {
        List<PartitionInfo> partitionsRenamed = this.mCompleteStoreToPartitions.remove(oldFileId);
        this.mCompleteStoreToPartitions.put(newFileId, partitionsRenamed);
    }

    private void renameStoreFromEntry(KeyValue.RenameStoreEntry entry) {
        this.renameStoreInternal(entry.getOldStoreId(), entry.getNewStoreId());
    }

    public synchronized void mergeStore(AlluxioURI fromUri, AlluxioURI toUri) throws IOException, FileDoesNotExistException, InvalidPathException, AlluxioException {
        long fromFileId = this.getFileId(fromUri);
        long toFileId = this.getFileId(toUri);
        this.checkIsCompletePartition(fromFileId, fromUri);
        this.checkIsCompletePartition(toFileId, toUri);
        this.mFileSystemMaster.rename(fromUri, new AlluxioURI(PathUtils.concatPath((Object)toUri.toString(), (Object[])new Object[]{String.format("%s-%s", fromUri.getName(), UUID.randomUUID().toString())})));
        this.mergeStoreInternal(fromFileId, toFileId);
        this.writeJournalEntry(this.newMergeStoreEntry(fromFileId, toFileId));
        this.flushJournal();
    }

    private void mergeStoreInternal(long fromFileId, long toFileId) {
        List<PartitionInfo> partitionsToBeMerged = this.mCompleteStoreToPartitions.remove(fromFileId);
        this.mCompleteStoreToPartitions.get(toFileId).addAll(partitionsToBeMerged);
    }

    private void mergeStoreFromEntry(KeyValue.MergeStoreEntry entry) {
        this.mergeStoreInternal(entry.getFromStoreId(), entry.getToStoreId());
    }

    public synchronized List<PartitionInfo> getPartitionInfo(AlluxioURI path) throws FileDoesNotExistException, AccessControlException, InvalidPathException {
        long fileId = this.getFileId(path);
        List<PartitionInfo> partitions = this.mCompleteStoreToPartitions.get(fileId);
        if (partitions == null) {
            return new ArrayList<PartitionInfo>();
        }
        return partitions;
    }

    private Journal.JournalEntry newCreateStoreEntry(long fileId) {
        KeyValue.CreateStoreEntry createStore = KeyValue.CreateStoreEntry.newBuilder().setStoreId(fileId).build();
        return Journal.JournalEntry.newBuilder().setCreateStore(createStore).build();
    }

    private Journal.JournalEntry newCompletePartitionEntry(long fileId, PartitionInfo info) {
        KeyValue.CompletePartitionEntry completePartition = KeyValue.CompletePartitionEntry.newBuilder().setStoreId(fileId).setBlockId(info.getBlockId()).setKeyStartBytes(ByteString.copyFrom((ByteBuffer)info.bufferForKeyStart())).setKeyLimitBytes(ByteString.copyFrom((ByteBuffer)info.bufferForKeyLimit())).setKeyCount(info.getKeyCount()).build();
        return Journal.JournalEntry.newBuilder().setCompletePartition(completePartition).build();
    }

    private Journal.JournalEntry newCompleteStoreEntry(long fileId) {
        KeyValue.CompleteStoreEntry completeStore = KeyValue.CompleteStoreEntry.newBuilder().setStoreId(fileId).build();
        return Journal.JournalEntry.newBuilder().setCompleteStore(completeStore).build();
    }

    private Journal.JournalEntry newDeleteStoreEntry(long fileId) {
        KeyValue.DeleteStoreEntry deleteStore = KeyValue.DeleteStoreEntry.newBuilder().setStoreId(fileId).build();
        return Journal.JournalEntry.newBuilder().setDeleteStore(deleteStore).build();
    }

    private Journal.JournalEntry newRenameStoreEntry(long oldFileId, long newFileId) {
        KeyValue.RenameStoreEntry renameStore = KeyValue.RenameStoreEntry.newBuilder().setOldStoreId(oldFileId).setNewStoreId(newFileId).build();
        return Journal.JournalEntry.newBuilder().setRenameStore(renameStore).build();
    }

    private Journal.JournalEntry newMergeStoreEntry(long fromFileId, long toFileId) {
        KeyValue.MergeStoreEntry mergeStore = KeyValue.MergeStoreEntry.newBuilder().setFromStoreId(fromFileId).setToStoreId(toFileId).build();
        return Journal.JournalEntry.newBuilder().setMergeStore(mergeStore).build();
    }
}

