/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.keyvalue;

import alluxio.AlluxioURI;
import alluxio.RpcUtils;
import alluxio.exception.AlluxioException;
import alluxio.master.keyvalue.KeyValueMaster;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.KeyValueMasterClientService;
import alluxio.thrift.PartitionInfo;
import alluxio.thrift.ThriftIOException;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class KeyValueMasterClientServiceHandler
implements KeyValueMasterClientService.Iface {
    private final KeyValueMaster mKeyValueMaster;

    public KeyValueMasterClientServiceHandler(KeyValueMaster keyValueMaster) {
        this.mKeyValueMaster = keyValueMaster;
    }

    public long getServiceVersion() {
        return 1L;
    }

    public void completePartition(final String path, final PartitionInfo info) throws AlluxioTException {
        RpcUtils.call((RpcUtils.RpcCallable)new RpcUtils.RpcCallable<Void>(){

            public Void call() throws AlluxioException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.completePartition(new AlluxioURI(path), info);
                return null;
            }
        });
    }

    public void createStore(final String path) throws AlluxioTException {
        RpcUtils.call((RpcUtils.RpcCallable)new RpcUtils.RpcCallable<Void>(){

            public Void call() throws AlluxioException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.createStore(new AlluxioURI(path));
                return null;
            }
        });
    }

    public void completeStore(final String path) throws AlluxioTException {
        RpcUtils.call((RpcUtils.RpcCallable)new RpcUtils.RpcCallable<Void>(){

            public Void call() throws AlluxioException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.completeStore(new AlluxioURI(path));
                return null;
            }
        });
    }

    public List<PartitionInfo> getPartitionInfo(final String path) throws AlluxioTException {
        return (List)RpcUtils.call((RpcUtils.RpcCallable)new RpcUtils.RpcCallable<List<PartitionInfo>>(){

            public List<PartitionInfo> call() throws AlluxioException {
                return KeyValueMasterClientServiceHandler.this.mKeyValueMaster.getPartitionInfo(new AlluxioURI(path));
            }
        });
    }

    public void deleteStore(final String path) throws AlluxioTException, ThriftIOException {
        RpcUtils.call((RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<Void>(){

            public Void call() throws AlluxioException, IOException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.deleteStore(new AlluxioURI(path));
                return null;
            }
        });
    }

    public void renameStore(final String oldPath, final String newPath) throws AlluxioTException, ThriftIOException {
        RpcUtils.call((RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<Void>(){

            public Void call() throws AlluxioException, IOException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.renameStore(new AlluxioURI(oldPath), new AlluxioURI(newPath));
                return null;
            }
        });
    }

    public void mergeStore(final String fromPath, final String toPath) throws AlluxioTException, ThriftIOException {
        RpcUtils.call((RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<Void>(){

            public Void call() throws AlluxioException, IOException {
                KeyValueMasterClientServiceHandler.this.mKeyValueMaster.mergeStore(new AlluxioURI(fromPath), new AlluxioURI(toPath));
                return null;
            }
        });
    }
}

