/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.keyvalue;

import alluxio.RpcUtils;
import alluxio.client.keyvalue.ByteBufferKeyValuePartitionReader;
import alluxio.client.keyvalue.Index;
import alluxio.client.keyvalue.PayloadReader;
import alluxio.exception.AlluxioException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.KeyValueWorkerClientService;
import alluxio.thrift.ThriftIOException;
import alluxio.util.io.BufferUtils;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.block.io.BlockReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class KeyValueWorkerClientServiceHandler
implements KeyValueWorkerClientService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final BlockWorker mBlockWorker;

    public KeyValueWorkerClientServiceHandler(BlockWorker blockWorker) {
        this.mBlockWorker = (BlockWorker)Preconditions.checkNotNull((Object)blockWorker);
    }

    public long getServiceVersion() {
        return 1L;
    }

    public ByteBuffer get(final long blockId, final ByteBuffer key) throws AlluxioTException, ThriftIOException {
        return (ByteBuffer)RpcUtils.call((RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<ByteBuffer>(){

            public ByteBuffer call() throws AlluxioException, IOException {
                ByteBuffer value = KeyValueWorkerClientServiceHandler.this.getInternal(blockId, key);
                if (value == null) {
                    return ByteBuffer.allocate(0);
                }
                return KeyValueWorkerClientServiceHandler.this.copyAsNonDirectBuffer(value);
            }
        });
    }

    private ByteBuffer copyAsNonDirectBuffer(ByteBuffer directBuffer) {
        return BufferUtils.cloneByteBuffer((ByteBuffer)directBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getInternal(long blockId, ByteBuffer keyBuffer) throws BlockDoesNotExistException, IOException {
        long sessionId = -6L;
        long lockId = this.mBlockWorker.lockBlock(-6L, blockId);
        try {
            ByteBuffer byteBuffer = this.getReader(-6L, lockId, blockId).get(keyBuffer);
            return byteBuffer;
        }
        catch (InvalidWorkerStateException e) {
            LOG.error("Reaching invalid state to get a key", (Throwable)e);
        }
        finally {
            this.mBlockWorker.unlockBlock(lockId);
        }
        return null;
    }

    private ByteBufferKeyValuePartitionReader getReader(long sessionId, long lockId, long blockId) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException {
        BlockReader blockReader = this.mBlockWorker.readBlockRemote(sessionId, blockId, lockId);
        ByteBuffer fileBuffer = blockReader.read(0L, blockReader.getLength());
        ByteBufferKeyValuePartitionReader reader = new ByteBufferKeyValuePartitionReader(fileBuffer);
        blockReader.close();
        return reader;
    }

    public List<ByteBuffer> getNextKeys(final long blockId, final ByteBuffer key, final int numKeys) throws AlluxioTException, ThriftIOException {
        return (List)RpcUtils.call((RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<List<ByteBuffer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<ByteBuffer> call() throws AlluxioException, IOException {
                long sessionId = -6L;
                long lockId = KeyValueWorkerClientServiceHandler.this.mBlockWorker.lockBlock(-6L, blockId);
                try {
                    ByteBuffer nextKey;
                    ByteBufferKeyValuePartitionReader reader = KeyValueWorkerClientServiceHandler.this.getReader(-6L, lockId, blockId);
                    Index index = reader.getIndex();
                    PayloadReader payloadReader = reader.getPayloadReader();
                    ArrayList ret = Lists.newArrayListWithExpectedSize((int)numKeys);
                    ByteBuffer currentKey = key;
                    for (int i = 0; i < numKeys && (nextKey = index.nextKey(currentKey, payloadReader)) != null; ++i) {
                        ret.add(KeyValueWorkerClientServiceHandler.this.copyAsNonDirectBuffer(nextKey));
                        currentKey = nextKey;
                    }
                    ArrayList arrayList = ret;
                    return arrayList;
                }
                catch (InvalidWorkerStateException e) {
                    LOG.error("Reaching invalid state to get all keys", (Throwable)e);
                }
                finally {
                    KeyValueWorkerClientServiceHandler.this.mBlockWorker.unlockBlock(lockId);
                }
                return Collections.emptyList();
            }
        });
    }

    public int getSize(final long blockId) throws AlluxioTException, ThriftIOException {
        return (Integer)RpcUtils.call((RpcUtils.RpcCallableThrowsIOException)new RpcUtils.RpcCallableThrowsIOException<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer call() throws AlluxioException, IOException {
                long sessionId = -6L;
                long lockId = KeyValueWorkerClientServiceHandler.this.mBlockWorker.lockBlock(-6L, blockId);
                try {
                    Integer n = KeyValueWorkerClientServiceHandler.this.getReader(-6L, lockId, blockId).size();
                    return n;
                }
                catch (InvalidWorkerStateException e) {
                    LOG.error("Reaching invalid state to get size", (Throwable)e);
                }
                finally {
                    KeyValueWorkerClientServiceHandler.this.mBlockWorker.unlockBlock(lockId);
                }
                return 0;
            }
        });
    }
}

