/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.automata;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.AtomTransition;
import org.antlr.v4.runtime.atn.BlockEndState;
import org.antlr.v4.runtime.atn.DecisionState;
import org.antlr.v4.runtime.atn.EpsilonTransition;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.RangeTransition;
import org.antlr.v4.runtime.atn.SetTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;

public class ATNOptimizer {
    public static void optimize(Grammar g, ATN atn) {
        ATNOptimizer.optimizeSets(g, atn);
        ATNOptimizer.optimizeStates(atn);
    }

    private static void optimizeSets(Grammar g, ATN atn) {
        if (g.isParser()) {
            return;
        }
        int removedStates = 0;
        List decisions = atn.decisionToState;
        for (DecisionState decision : decisions) {
            int i;
            if (decision.ruleIndex >= 0) {
                Rule rule = g.getRule(decision.ruleIndex);
                if (Character.isLowerCase(rule.name.charAt(0))) continue;
            }
            IntervalSet setTransitions = new IntervalSet(new int[0]);
            for (i = 0; i < decision.getNumberOfTransitions(); ++i) {
                Transition epsTransition = decision.transition(i);
                if (!(epsTransition instanceof EpsilonTransition) || epsTransition.target.getNumberOfTransitions() != 1) continue;
                Transition transition = epsTransition.target.transition(0);
                if (!(transition.target instanceof BlockEndState) || transition instanceof NotSetTransition || !(transition instanceof AtomTransition) && !(transition instanceof RangeTransition) && !(transition instanceof SetTransition)) continue;
                setTransitions.add(i);
            }
            for (i = setTransitions.getIntervals().size() - 1; i >= 0; --i) {
                SetTransition newTransition;
                Interval interval = (Interval)setTransitions.getIntervals().get(i);
                if (interval.length() <= 1) continue;
                ATNState blockEndState = decision.transition((int)interval.a).target.transition((int)0).target;
                IntervalSet matchSet = new IntervalSet(new int[0]);
                for (int j = interval.a; j <= interval.b; ++j) {
                    Transition matchTransition = decision.transition((int)j).target.transition(0);
                    if (matchTransition instanceof NotSetTransition) {
                        throw new UnsupportedOperationException("Not yet implemented.");
                    }
                    IntervalSet set = matchTransition.label();
                    int minElem = set.getMinElement();
                    int maxElem = set.getMaxElement();
                    for (int k = minElem; k <= maxElem; ++k) {
                        if (!matchSet.contains(k)) continue;
                        char setMin = (char)set.getMinElement();
                        char setMax = (char)set.getMaxElement();
                        g.tool.errMgr.grammarError(ErrorType.CHARACTERS_COLLISION_IN_SET, g.fileName, null, (char)minElem + "-" + (char)maxElem, "[" + setMin + "-" + setMax + "]");
                        break;
                    }
                    matchSet.addAll((IntSet)set);
                }
                if (matchSet.getIntervals().size() == 1) {
                    if (matchSet.size() == 1) {
                        newTransition = new AtomTransition(blockEndState, matchSet.getMinElement());
                    } else {
                        Interval matchInterval = (Interval)matchSet.getIntervals().get(0);
                        newTransition = new RangeTransition(blockEndState, matchInterval.a, matchInterval.b);
                    }
                } else {
                    newTransition = new SetTransition(blockEndState, matchSet);
                }
                decision.transition((int)interval.a).target.setTransition(0, (Transition)newTransition);
                for (int j = interval.a + 1; j <= interval.b; ++j) {
                    Transition removed = decision.removeTransition(interval.a + 1);
                    atn.removeState(removed.target);
                    ++removedStates;
                }
            }
        }
    }

    private static void optimizeStates(ATN atn) {
        ArrayList<ATNState> compressed = new ArrayList<ATNState>();
        int i = 0;
        for (ATNState s : atn.states) {
            if (s == null) continue;
            compressed.add(s);
            s.stateNumber = i++;
        }
        atn.states.clear();
        atn.states.addAll(compressed);
    }

    private ATNOptimizer() {
    }
}

