/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.VerifiableComponent;
import org.apache.camel.component.rest.RestComponent;
import org.apache.camel.impl.verifier.CatalogVerifierCustomizer;
import org.apache.camel.impl.verifier.DefaultComponentVerifier;
import org.apache.camel.impl.verifier.ResultBuilder;
import org.apache.camel.impl.verifier.ResultErrorBuilder;
import org.apache.camel.runtimecatalog.JSonSchemaHelper;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;

public class RestComponentVerifier
extends DefaultComponentVerifier {
    private static final CatalogVerifierCustomizer CUSTOMIZER = new CatalogVerifierCustomizer().excludeUnknown();
    private final RestComponent component;

    RestComponentVerifier(RestComponent component) {
        super("rest", component.getCamelContext());
        this.component = component;
    }

    @Override
    protected ComponentVerifier.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifier.Result.Status.OK, ComponentVerifier.Scope.PARAMETERS);
        super.verifyParametersAgainstCatalog(builder, parameters, CUSTOMIZER);
        this.verifyUnderlyingComponent(ComponentVerifier.Scope.PARAMETERS, builder, parameters);
        return builder.build();
    }

    @Override
    protected ComponentVerifier.Result verifyConnectivity(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifier.Result.Status.OK, ComponentVerifier.Scope.CONNECTIVITY);
        this.verifyUnderlyingComponent(ComponentVerifier.Scope.CONNECTIVITY, builder, parameters);
        return builder.build();
    }

    protected void verifyUnderlyingComponent(ComponentVerifier.Scope scope, ResultBuilder builder, Map<String, Object> parameters) {
        block8: {
            String componentName = (String)parameters.get("componentName");
            if (ObjectHelper.isNotEmpty(componentName)) {
                try {
                    Component component = this.getTransportComponent(componentName);
                    if (component instanceof VerifiableComponent) {
                        Object val;
                        String name;
                        RuntimeCamelCatalog catalog = this.getCamelContext().getRuntimeCamelCatalog();
                        String json = catalog.componentJSonSchema("rest");
                        HashMap<String, Object> restParameters = new HashMap<String, Object>(parameters);
                        for (Map<String, String> m : JSonSchemaHelper.parseJsonSchema("componentProperties", json, true)) {
                            name = m.get("name");
                            val = restParameters.remove(name);
                            if (val == null) continue;
                            restParameters.put("rest." + name, parameters.get(name));
                        }
                        for (Map<String, String> m : JSonSchemaHelper.parseJsonSchema("properties", json, true)) {
                            name = m.get("name");
                            val = restParameters.remove(name);
                            if (val == null) continue;
                            restParameters.put("rest." + name, parameters.get(name));
                        }
                        ComponentVerifier verifier = ((VerifiableComponent)((Object)component)).getVerifier();
                        ComponentVerifier.Result result = verifier.verify(scope, restParameters);
                        for (ComponentVerifier.VerificationError error : result.getErrors()) {
                            builder.error(ResultErrorBuilder.fromError(error).detail("component", (Object)componentName).build());
                        }
                        break block8;
                    }
                    builder.error(ResultErrorBuilder.withUnsupportedComponent(componentName).build());
                }
                catch (Exception e) {
                    builder.error(ResultErrorBuilder.withException(e).build());
                }
            } else {
                builder.error(ResultErrorBuilder.withMissingOption("componentName").build());
            }
        }
    }

    private Component getTransportComponent(String componentName) throws Exception {
        return Suppliers.firstMatching(comp -> comp != null && (comp instanceof RestConsumerFactory || comp instanceof RestProducerFactory), () -> this.getCamelContext().getRegistry().lookupByNameAndType(componentName, Component.class), () -> this.getCamelContext().getComponent(componentName, true, false)).orElse(null);
    }
}

