/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.thread;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.thread.DedicatedTaskRunner;
import org.apache.activemq.thread.PooledTaskRunner;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.util.ThreadPoolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunnerFactory
implements Executor {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRunnerFactory.class);
    private ExecutorService executor;
    private int maxIterationsPerRun;
    private String name;
    private int priority;
    private boolean daemon;
    private final AtomicLong id = new AtomicLong(0L);
    private boolean dedicatedTaskRunner;
    private long shutdownAwaitTermination = 30000L;
    private final AtomicBoolean initDone = new AtomicBoolean(false);
    private int maxThreadPoolSize = Integer.MAX_VALUE;
    private RejectedExecutionHandler rejectedTaskHandler = null;

    public TaskRunnerFactory() {
        this("ActiveMQ Task");
    }

    public TaskRunnerFactory(String name) {
        this(name, 5, true, 1000);
    }

    private TaskRunnerFactory(String name, int priority, boolean daemon, int maxIterationsPerRun) {
        this(name, priority, daemon, maxIterationsPerRun, false);
    }

    public TaskRunnerFactory(String name, int priority, boolean daemon, int maxIterationsPerRun, boolean dedicatedTaskRunner) {
        this(name, priority, daemon, maxIterationsPerRun, dedicatedTaskRunner, Integer.MAX_VALUE);
    }

    public TaskRunnerFactory(String name, int priority, boolean daemon, int maxIterationsPerRun, boolean dedicatedTaskRunner, int maxThreadPoolSize) {
        this.name = name;
        this.priority = priority;
        this.daemon = daemon;
        this.maxIterationsPerRun = maxIterationsPerRun;
        this.dedicatedTaskRunner = dedicatedTaskRunner;
        this.maxThreadPoolSize = maxThreadPoolSize;
    }

    public void init() {
        if (this.initDone.compareAndSet(false, true)) {
            if (this.dedicatedTaskRunner || "true".equalsIgnoreCase(System.getProperty("org.apache.activemq.UseDedicatedTaskRunner"))) {
                this.executor = null;
            } else if (this.executor == null) {
                this.executor = this.createDefaultExecutor();
            }
            LOG.debug("Initialized TaskRunnerFactory[{}] using ExecutorService: {}", (Object)this.name, (Object)this.executor);
        }
    }

    public void shutdown() {
        if (this.executor != null) {
            ThreadPoolUtils.shutdown(this.executor);
            this.executor = null;
        }
        this.initDone.set(false);
    }

    public void shutdownNow() {
        if (this.executor != null) {
            ThreadPoolUtils.shutdownNow(this.executor);
            this.executor = null;
        }
        this.initDone.set(false);
    }

    public void shutdownGraceful() {
        if (this.executor != null) {
            ThreadPoolUtils.shutdownGraceful(this.executor, this.shutdownAwaitTermination);
            this.executor = null;
        }
        this.initDone.set(false);
    }

    public TaskRunner createTaskRunner(Task task, String name) {
        this.init();
        if (this.executor != null) {
            return new PooledTaskRunner(this.executor, task, this.maxIterationsPerRun);
        }
        return new DedicatedTaskRunner(task, name, this.priority, this.daemon);
    }

    @Override
    public void execute(Runnable runnable) {
        this.execute(runnable, this.name);
    }

    public void execute(Runnable runnable, String name) {
        this.init();
        LOG.trace("Execute[{}] runnable: {}", (Object)name, (Object)runnable);
        if (this.executor != null) {
            this.executor.execute(runnable);
        } else {
            this.doExecuteNewThread(runnable, name);
        }
    }

    private void doExecuteNewThread(Runnable runnable, String name) {
        String threadName = name + "-" + this.id.incrementAndGet();
        Thread thread = new Thread(runnable, threadName);
        thread.setDaemon(this.daemon);
        LOG.trace("Created and running thread[{}]: {}", (Object)threadName, (Object)thread);
        thread.start();
    }

    protected ExecutorService createDefaultExecutor() {
        ThreadPoolExecutor rc = new ThreadPoolExecutor(0, this.getMaxThreadPoolSize(), (long)TaskRunnerFactory.getDefaultKeepAliveTime(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                String threadName = TaskRunnerFactory.this.name + "-" + TaskRunnerFactory.this.id.incrementAndGet();
                Thread thread = new Thread(runnable, threadName);
                thread.setDaemon(TaskRunnerFactory.this.daemon);
                thread.setPriority(TaskRunnerFactory.this.priority);
                LOG.trace("Created thread[{}]: {}", (Object)threadName, (Object)thread);
                return thread;
            }
        });
        if (this.rejectedTaskHandler != null) {
            rc.setRejectedExecutionHandler(this.rejectedTaskHandler);
        }
        return rc;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public int getMaxIterationsPerRun() {
        return this.maxIterationsPerRun;
    }

    public void setMaxIterationsPerRun(int maxIterationsPerRun) {
        this.maxIterationsPerRun = maxIterationsPerRun;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public boolean isDedicatedTaskRunner() {
        return this.dedicatedTaskRunner;
    }

    public void setDedicatedTaskRunner(boolean dedicatedTaskRunner) {
        this.dedicatedTaskRunner = dedicatedTaskRunner;
    }

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public void setMaxThreadPoolSize(int maxThreadPoolSize) {
        this.maxThreadPoolSize = maxThreadPoolSize;
    }

    public RejectedExecutionHandler getRejectedTaskHandler() {
        return this.rejectedTaskHandler;
    }

    public void setRejectedTaskHandler(RejectedExecutionHandler rejectedTaskHandler) {
        this.rejectedTaskHandler = rejectedTaskHandler;
    }

    public long getShutdownAwaitTermination() {
        return this.shutdownAwaitTermination;
    }

    public void setShutdownAwaitTermination(long shutdownAwaitTermination) {
        this.shutdownAwaitTermination = shutdownAwaitTermination;
    }

    private static int getDefaultKeepAliveTime() {
        return Integer.getInteger("org.apache.activemq.thread.TaskRunnerFactory.keepAliveTime", 30);
    }
}

