/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.activemq.artemis.shaded.org.jgroups.BatchMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.BytesMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.CompositeMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.EmptyMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.FragmentedMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.LongMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.MessageFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.NioMessage;
import org.apache.activemq.artemis.shaded.org.jgroups.ObjectMessage;

public class DefaultMessageFactory
implements MessageFactory {
    protected static final byte MIN_TYPE = 32;
    protected final Supplier<? extends Message>[] creators = new Supplier[32];
    protected Map<Short, Supplier<? extends Message>> map;

    public DefaultMessageFactory() {
        this.creators[0] = BytesMessage::new;
        this.creators[1] = NioMessage::new;
        this.creators[2] = EmptyMessage::new;
        this.creators[3] = ObjectMessage::new;
        this.creators[4] = LongMessage::new;
        this.creators[5] = CompositeMessage::new;
        this.creators[6] = FragmentedMessage::new;
        this.creators[7] = BatchMessage::new;
    }

    @Override
    public <T extends Message> T create(short type) {
        Supplier<? extends Message> creator;
        Supplier<? extends Message> supplier = creator = type < 32 ? this.creators[type] : this.map.get(type);
        if (creator == null) {
            throw new IllegalArgumentException("no creator found for type " + type);
        }
        return (T)creator.get();
    }

    public <T extends MessageFactory> T register(short type, Supplier<? extends Message> generator) {
        Objects.requireNonNull(generator, "the creator must be non-null");
        if (type < 32) {
            throw new IllegalArgumentException(String.format("type (%d) must be >= 32", type));
        }
        if (this.map == null) {
            this.map = new HashMap<Short, Supplier<? extends Message>>();
        }
        if (this.map.containsKey(type)) {
            throw new IllegalArgumentException(String.format("type %d is already taken", type));
        }
        this.map.put(type, generator);
        return (T)this;
    }
}

