package org.apache.activemq.artemis.jms.bridge;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import javax.management.ObjectName;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-11-02T18:47:56-0500")
public class ActiveMQJMSBridgeLogger_$logger extends DelegatingBasicLogger implements ActiveMQJMSBridgeLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQJMSBridgeLogger_$logger.class.getName();
    public ActiveMQJMSBridgeLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void failedToSetUpBridge(final long failureRetryInterval, final String bridgeName) {
        super.log.logv(FQCN, INFO, null, failedToSetUpBridge$str(), failureRetryInterval, bridgeName);
    }
    protected String failedToSetUpBridge$str() {
        return "AMQ341000: Failed to set up JMS bridge {1} connections. Most probably the source or target servers are unavailable. Will retry after a pause of {0} ms";
    }
    @Override
    public final void bridgeReconnected(final String bridgeName) {
        super.log.logv(FQCN, INFO, null, bridgeReconnected$str(), bridgeName);
    }
    protected String bridgeReconnected$str() {
        return "AMQ341001: JMS Bridge {0} succeeded in reconnecting to servers";
    }
    @Override
    public final void bridgeConnected(final String bridgeName) {
        super.log.logv(FQCN, INFO, null, bridgeConnected$str(), bridgeName);
    }
    protected String bridgeConnected$str() {
        return "AMQ341002: JMSBridge {0} succeeded in connecting to servers";
    }
    @Override
    public final void errorBridgeAlreadyStarted(final String bridgeName) {
        super.log.logv(FQCN, WARN, null, errorBridgeAlreadyStarted$str(), bridgeName);
    }
    protected String errorBridgeAlreadyStarted$str() {
        return "AMQ342000: Attempt to start JMS Bridge {0}, but is already started";
    }
    @Override
    public final void errorStartingBridge(final String bridgeName) {
        super.log.logv(FQCN, WARN, null, errorStartingBridge$str(), bridgeName);
    }
    protected String errorStartingBridge$str() {
        return "AMQ342001: Failed to start JMS Bridge {0}";
    }
    @Override
    public final void errorUnregisteringBridge(final ObjectName objectName, final String bridgeName) {
        super.log.logv(FQCN, WARN, null, errorUnregisteringBridge$str(), objectName, bridgeName);
    }
    protected String errorUnregisteringBridge$str() {
        return "AMQ342002: Failed to unregisted JMS Bridge {0} - {1}";
    }
    @Override
    public final void errorConnectingBridge(final String bridgeName) {
        super.log.logv(FQCN, WARN, null, errorConnectingBridge$str(), bridgeName);
    }
    protected String errorConnectingBridge$str() {
        return "AMQ342003: JMS Bridge {0} unable to set up connections, bridge will be stopped";
    }
    @Override
    public final void bridgeRetry(final long failureRetryInterval, final String bridgeName) {
        super.log.logv(FQCN, WARN, null, bridgeRetry$str(), failureRetryInterval, bridgeName);
    }
    protected String bridgeRetry$str() {
        return "AMQ342004: JMS Bridge {1}, will retry after a pause of {0} ms";
    }
    @Override
    public final void bridgeNotStarted(final String bridgeName) {
        super.log.logv(FQCN, WARN, null, bridgeNotStarted$str(), bridgeName);
    }
    protected String bridgeNotStarted$str() {
        return "AMQ342005: JMS Bridge {0} unable to set up connections, bridge will not be started";
    }
    @Override
    public final void bridgeFailure(final Exception e, final String bridgeName) {
        super.log.logv(FQCN, WARN, e, bridgeFailure$str(), bridgeName);
    }
    protected String bridgeFailure$str() {
        return "AMQ342006: JMS Bridge {0}, detected failure on bridge connection";
    }
    @Override
    public final void bridgeAckError(final Exception e, final String bridgeName) {
        super.log.logv(FQCN, WARN, e, bridgeAckError$str(), bridgeName);
    }
    protected String bridgeAckError$str() {
        return "AMQ342009: JMS Bridge {0} failed to send + acknowledge batch, closing JMS objects";
    }
    @Override
    public final void bridgeConnectError(final Exception e, final String bridgeName) {
        super.log.logv(FQCN, WARN, e, bridgeConnectError$str(), bridgeName);
    }
    protected String bridgeConnectError$str() {
        return "AMQ342010: Failed to connect JMS Bridge {0}";
    }
    @Override
    public final void transactionRolledBack(final Exception e) {
        super.log.logv(FQCN, WARN, e, transactionRolledBack$str());
    }
    protected String transactionRolledBack$str() {
        return "AMQ342011: Transaction rolled back, retrying TX";
    }
    @Override
    public final void jmsBridgeSrcConnectError(final Exception e, final String bridgeName) {
        super.log.logv(FQCN, ERROR, e, jmsBridgeSrcConnectError$str(), bridgeName);
    }
    protected String jmsBridgeSrcConnectError$str() {
        return "AMQ344001: JMS Bridge {0}, failed to start source connection";
    }
    @Override
    public final void jmsBridgeTransactionManagerMissing(final org.apache.activemq.artemis.jms.bridge.QualityOfServiceMode qosMode, final String bridgeName) {
        super.log.logv(FQCN, ERROR, null, jmsBridgeTransactionManagerMissing$str(), qosMode, bridgeName);
    }
    protected String jmsBridgeTransactionManagerMissing$str() {
        return "AMQ344002: Failed to start JMS Bridge {1}.  QoS Mode: {0} requires a Transaction Manager, none found";
    }
}
