/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientResource;
import org.apache.activemq.artemis.junit.EmbeddedActiveMQResource;

public class ActiveMQConsumerResource
extends AbstractActiveMQClientResource {
    long defaultReceiveTimeout = 50L;
    SimpleString queueName;
    ClientConsumer consumer;

    public ActiveMQConsumerResource(String url, String queueName) {
        this(url, SimpleString.toSimpleString((String)queueName), null, null);
    }

    public ActiveMQConsumerResource(String url, String queueName, String username, String password) {
        this(url, SimpleString.toSimpleString((String)queueName), username, password);
    }

    public ActiveMQConsumerResource(String url, SimpleString queueName, String username, String password) {
        super(url, username, password);
        this.queueName = queueName;
    }

    public ActiveMQConsumerResource(String url, SimpleString queueName) {
        this(url, queueName, null, null);
    }

    public ActiveMQConsumerResource(ServerLocator serverLocator, String queueName, String username, String password) {
        this(serverLocator, SimpleString.toSimpleString((String)queueName), username, password);
    }

    public ActiveMQConsumerResource(ServerLocator serverLocator, String queueName) {
        this(serverLocator, SimpleString.toSimpleString((String)queueName), null, null);
    }

    public ActiveMQConsumerResource(ServerLocator serverLocator, SimpleString queueName, String username, String password) {
        super(serverLocator, username, password);
        this.queueName = queueName;
    }

    public ActiveMQConsumerResource(ServerLocator serverLocator, SimpleString queueName) {
        this(serverLocator, queueName, null, null);
    }

    public long getDefaultReceiveTimeout() {
        return this.defaultReceiveTimeout;
    }

    public void setDefaultReceiveTimeout(long defaultReceiveTimeout) {
        this.defaultReceiveTimeout = defaultReceiveTimeout;
    }

    @Override
    protected void createClient() {
        boolean browseOnly = false;
        try {
            if (!this.session.queueQuery(this.queueName).isExists() && this.autoCreateQueue) {
                this.log.warn("{}: queue does not exist - creating queue: address = {}, name = {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.queueName.toString(), this.queueName.toString()});
                this.session.createAddress(this.queueName, RoutingType.MULTICAST, true);
                this.session.createQueue(new QueueConfiguration(this.queueName));
            }
            this.consumer = this.session.createConsumer(this.queueName, browseOnly);
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientResource.ActiveMQClientResourceException(String.format("Error creating consumer for queueName %s", this.queueName.toString()), (Exception)((Object)amqEx));
        }
    }

    @Override
    protected void stopClient() {
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (ActiveMQException amqEx) {
                this.log.warn("Exception encountered closing consumer - ignoring", (Throwable)amqEx);
            }
            finally {
                this.consumer = null;
            }
        }
    }

    @Override
    public boolean isAutoCreateQueue() {
        return this.autoCreateQueue;
    }

    @Override
    public void setAutoCreateQueue(boolean autoCreateQueue) {
        this.autoCreateQueue = autoCreateQueue;
    }

    public ClientMessage receiveMessage() {
        return this.receiveMessage(this.defaultReceiveTimeout);
    }

    public ClientMessage receiveMessage(long timeout) {
        ClientMessage message = null;
        if (timeout > 0L) {
            try {
                message = this.consumer.receive(timeout);
            }
            catch (ActiveMQException amqEx) {
                throw new EmbeddedActiveMQResource.EmbeddedActiveMQResourceException(String.format("ClientConsumer.receive( timeout = %d ) for %s failed", timeout, this.queueName.toString()), (Exception)((Object)amqEx));
            }
        }
        if (timeout == 0L) {
            try {
                message = this.consumer.receiveImmediate();
            }
            catch (ActiveMQException amqEx) {
                throw new EmbeddedActiveMQResource.EmbeddedActiveMQResourceException(String.format("ClientConsumer.receiveImmediate() for %s failed", this.queueName.toString()), (Exception)((Object)amqEx));
            }
        }
        try {
            message = this.consumer.receive();
        }
        catch (ActiveMQException amqEx) {
            throw new EmbeddedActiveMQResource.EmbeddedActiveMQResourceException(String.format("ClientConsumer.receive() for %s failed", this.queueName.toString()), (Exception)((Object)amqEx));
        }
        return message;
    }
}

