/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import org.apache.activemq.artemis.api.core.ActiveMQDeleteAddressException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQDivertDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateMetaDataException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQIncompatibleClientServerException;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidQueueConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidTransientQueueUseException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueMaxConsumerLimitReached;
import org.apache.activemq.artemis.api.core.ActiveMQRemoteDisconnectException;
import org.apache.activemq.artemis.api.core.ActiveMQReplicationTimeooutException;
import org.apache.activemq.artemis.api.core.ActiveMQRoutingException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQSessionCreationException;
import org.apache.activemq.artemis.api.core.ActiveMQTimeoutException;
import org.apache.activemq.artemis.api.core.ActiveMQUnexpectedRoutingTypeForAddress;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReplicationSyncFileMessage;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.JournalType;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQMessageBundle_impl
implements ActiveMQMessageBundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQMessageBundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String activationForServer(ActiveMQServer server) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229000: Activation for server {}", (Object[])new Object[]{server}).getMessage();
        return returnString;
    }

    @Override
    public String generatingThreadDump() {
        String returnString = "AMQ229001: Generating thread dump";
        return returnString;
    }

    @Override
    public String threadDump(Thread key, String name, Long id, ThreadGroup threadGroup) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229002: Thread {} name = {} id = {} group = {}", (Object[])new Object[]{key, name, id, threadGroup}).getMessage();
        return returnString;
    }

    @Override
    public String endThreadDump() {
        String returnString = "AMQ229003: End Thread dump";
        return returnString;
    }

    @Override
    public String serverDescribe(String identity, String describe) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229004: Information about server {}\nCluster Connection:{}", (Object[])new Object[]{identity, describe}).getMessage();
        return returnString;
    }

    @Override
    public ActiveMQInternalErrorException connectionsClosedByManagement(String ipAddress) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229005: connections for {} closed by management", (Object[])new Object[]{ipAddress}).getMessage();
        ActiveMQInternalErrorException objReturn_connectionsClosedByManagement = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionsClosedByManagement);
        return objReturn_connectionsClosedByManagement;
    }

    @Override
    public ActiveMQInternalErrorException notJournalImpl() {
        String returnString = "AMQ229006: journals are not JournalImpl. You can't set a replicator!";
        ActiveMQInternalErrorException objReturn_notJournalImpl = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_notJournalImpl);
        return objReturn_notJournalImpl;
    }

    @Override
    public ActiveMQInternalErrorException replicationUnhandledError(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229007: unhandled error during replication", (Object[])new Object[]{e}).getMessage();
        ActiveMQInternalErrorException objReturn_replicationUnhandledError = new ActiveMQInternalErrorException(returnString);
        objReturn_replicationUnhandledError.initCause((Throwable)e);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_replicationUnhandledError);
        return objReturn_replicationUnhandledError;
    }

    @Override
    public ActiveMQInternalErrorException replicationTooManyJournals() {
        String returnString = "AMQ229008: Live Node contains more journals than the backup node. Probably a version match error";
        ActiveMQInternalErrorException objReturn_replicationTooManyJournals = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_replicationTooManyJournals);
        return objReturn_replicationTooManyJournals;
    }

    @Override
    public ActiveMQInternalErrorException replicationUnhandledFileType(ReplicationSyncFileMessage.FileType fileType) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229009: Unhandled file type {}", (Object[])new Object[]{fileType}).getMessage();
        ActiveMQInternalErrorException objReturn_replicationUnhandledFileType = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_replicationUnhandledFileType);
        return objReturn_replicationUnhandledFileType;
    }

    @Override
    public ActiveMQInternalErrorException replicationBackupUpToDate() {
        String returnString = "AMQ229010: Remote Backup can not be up-to-date!";
        ActiveMQInternalErrorException objReturn_replicationBackupUpToDate = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_replicationBackupUpToDate);
        return objReturn_replicationBackupUpToDate;
    }

    @Override
    public ActiveMQInternalErrorException replicationUnhandledDataType() {
        String returnString = "AMQ229011: unhandled data type!";
        ActiveMQInternalErrorException objReturn_replicationUnhandledDataType = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_replicationUnhandledDataType);
        return objReturn_replicationUnhandledDataType;
    }

    @Override
    public ActiveMQInternalErrorException noBindingForDivert(SimpleString name) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229012: No binding for divert {}", (Object[])new Object[]{name}).getMessage();
        ActiveMQInternalErrorException objReturn_noBindingForDivert = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_noBindingForDivert);
        return objReturn_noBindingForDivert;
    }

    @Override
    public ActiveMQInternalErrorException bindingNotDivert(SimpleString name) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229013: Binding {} is not a divert", (Object[])new Object[]{name}).getMessage();
        ActiveMQInternalErrorException objReturn_bindingNotDivert = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_bindingNotDivert);
        return objReturn_bindingNotDivert;
    }

    @Override
    public ActiveMQConnectionTimedOutException clientExited(String remoteAddress, long ttl) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229014: Did not receive data from {} within the {}ms connection TTL. The connection will now be closed.", (Object[])new Object[]{remoteAddress, ttl}).getMessage();
        ActiveMQConnectionTimedOutException objReturn_clientExited = new ActiveMQConnectionTimedOutException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_clientExited);
        return objReturn_clientExited;
    }

    @Override
    public ActiveMQInternalErrorException divertWithNoName() {
        String returnString = "AMQ229015: Must specify a name for each divert. This one will not be deployed.";
        ActiveMQInternalErrorException objReturn_divertWithNoName = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_divertWithNoName);
        return objReturn_divertWithNoName;
    }

    @Override
    public ActiveMQNonExistentQueueException noSuchQueue(SimpleString queueName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229017: Queue {} does not exist", (Object[])new Object[]{queueName}).getMessage();
        ActiveMQNonExistentQueueException objReturn_noSuchQueue = new ActiveMQNonExistentQueueException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_noSuchQueue);
        return objReturn_noSuchQueue;
    }

    @Override
    public ActiveMQQueueExistsException bindingAlreadyExists(Binding binding) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229018: Binding already exists {}", (Object[])new Object[]{binding}).getMessage();
        ActiveMQQueueExistsException objReturn_bindingAlreadyExists = new ActiveMQQueueExistsException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_bindingAlreadyExists);
        return objReturn_bindingAlreadyExists;
    }

    @Override
    public ActiveMQQueueExistsException queueAlreadyExists(SimpleString queueName, SimpleString addressName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229019: Queue {} already exists on address {}", (Object[])new Object[]{queueName, addressName}).getMessage();
        ActiveMQQueueExistsException objReturn_queueAlreadyExists = new ActiveMQQueueExistsException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_queueAlreadyExists);
        return objReturn_queueAlreadyExists;
    }

    @Override
    public ActiveMQInvalidFilterExpressionException invalidFilter(SimpleString filter, Throwable e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229020: Invalid filter: {}", (Object[])new Object[]{filter, e}).getMessage();
        ActiveMQInvalidFilterExpressionException objReturn_invalidFilter = new ActiveMQInvalidFilterExpressionException(returnString);
        objReturn_invalidFilter.initCause(e);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidFilter);
        return objReturn_invalidFilter;
    }

    @Override
    public ActiveMQIllegalStateException messageIdNotAssigned() {
        String returnString = "AMQ229021: MessageId was not assigned to Message";
        ActiveMQIllegalStateException objReturn_messageIdNotAssigned = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_messageIdNotAssigned);
        return objReturn_messageIdNotAssigned;
    }

    @Override
    public ActiveMQIllegalStateException journalsNotInSync() {
        String returnString = "AMQ229022: Cannot compare journals if not in sync!";
        ActiveMQIllegalStateException objReturn_journalsNotInSync = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_journalsNotInSync);
        return objReturn_journalsNotInSync;
    }

    @Override
    public ActiveMQIllegalStateException serverNotBackupServer() {
        String returnString = "AMQ229023: Connected server is not a backup server";
        ActiveMQIllegalStateException objReturn_serverNotBackupServer = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_serverNotBackupServer);
        return objReturn_serverNotBackupServer;
    }

    @Override
    public ActiveMQIllegalStateException alreadyHaveReplicationServer() {
        String returnString = "AMQ229024: Backup replication server is already connected to another server";
        ActiveMQIllegalStateException objReturn_alreadyHaveReplicationServer = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_alreadyHaveReplicationServer);
        return objReturn_alreadyHaveReplicationServer;
    }

    @Override
    public ActiveMQIllegalStateException cannotDeleteQueueWithConsumers(SimpleString name, SimpleString queueName, String s) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229025: Cannot delete queue {} on binding {} - it has consumers = {}", (Object[])new Object[]{name, queueName, s}).getMessage();
        ActiveMQIllegalStateException objReturn_cannotDeleteQueueWithConsumers = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_cannotDeleteQueueWithConsumers);
        return objReturn_cannotDeleteQueueWithConsumers;
    }

    @Override
    public ActiveMQIllegalStateException backupServerNotInSync() {
        String returnString = "AMQ229026: Backup Server was not yet in sync with live";
        ActiveMQIllegalStateException objReturn_backupServerNotInSync = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_backupServerNotInSync);
        return objReturn_backupServerNotInSync;
    }

    @Override
    public ActiveMQIllegalStateException consumerNoReference(Long id, Long messageID, SimpleString name) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229027: Could not find reference on consumer ID={}, messageId = {} queue = {}", (Object[])new Object[]{id, messageID, name}).getMessage();
        ActiveMQIllegalStateException objReturn_consumerNoReference = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_consumerNoReference);
        return objReturn_consumerNoReference;
    }

    @Override
    public ActiveMQIllegalStateException consumerDoesntExist(long consumerID) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229028: Consumer {} doesn't exist on the server", (Object[])new Object[]{consumerID}).getMessage();
        ActiveMQIllegalStateException objReturn_consumerDoesntExist = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_consumerDoesntExist);
        return objReturn_consumerDoesntExist;
    }

    @Override
    public ActiveMQIllegalStateException noAddress() {
        String returnString = "AMQ229029: No address configured on the Server's Session";
        ActiveMQIllegalStateException objReturn_noAddress = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_noAddress);
        return objReturn_noAddress;
    }

    @Override
    public ActiveMQIllegalStateException largeMessageNotInitialised() {
        String returnString = "AMQ229030: large-message not initialized on server";
        ActiveMQIllegalStateException objReturn_largeMessageNotInitialised = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_largeMessageNotInitialised);
        return objReturn_largeMessageNotInitialised;
    }

    @Override
    public ActiveMQSecurityException unableToValidateUser(String remoteAddress, String user, String certMessage) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229031: Unable to validate user from {}. Username: {}; SSL certificate subject DN: {}", (Object[])new Object[]{remoteAddress, user, certMessage}).getMessage();
        ActiveMQSecurityException objReturn_unableToValidateUser = new ActiveMQSecurityException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_unableToValidateUser);
        return objReturn_unableToValidateUser;
    }

    @Override
    public ActiveMQSecurityException userNoPermissions(String username, CheckType checkType, SimpleString address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229032: User: {} does not have permission='{}' on address {}", (Object[])new Object[]{username, checkType, address}).getMessage();
        ActiveMQSecurityException objReturn_userNoPermissions = new ActiveMQSecurityException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_userNoPermissions);
        return objReturn_userNoPermissions;
    }

    @Override
    public ActiveMQIncompatibleClientServerException incompatibleClientServer() {
        String returnString = "AMQ229033: Server and client versions incompatible";
        ActiveMQIncompatibleClientServerException objReturn_incompatibleClientServer = new ActiveMQIncompatibleClientServerException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_incompatibleClientServer);
        return objReturn_incompatibleClientServer;
    }

    @Override
    public ActiveMQSessionCreationException serverNotStarted() {
        String returnString = "AMQ229034: Server not started";
        ActiveMQSessionCreationException objReturn_serverNotStarted = new ActiveMQSessionCreationException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_serverNotStarted);
        return objReturn_serverNotStarted;
    }

    @Override
    public ActiveMQDuplicateMetaDataException duplicateMetadata(String key, String data) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229035: Metadata {}={} had been set already", (Object[])new Object[]{key, data}).getMessage();
        ActiveMQDuplicateMetaDataException objReturn_duplicateMetadata = new ActiveMQDuplicateMetaDataException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_duplicateMetadata);
        return objReturn_duplicateMetadata;
    }

    @Override
    public IllegalArgumentException invalidType(Object type) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229036: Invalid type: {}", (Object[])new Object[]{type}).getMessage();
        IllegalArgumentException objReturn_invalidType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidType);
        return objReturn_invalidType;
    }

    @Override
    public IllegalArgumentException emptyOrNull(String name) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229038: {} must neither be null nor empty", (Object[])new Object[]{name}).getMessage();
        IllegalArgumentException objReturn_emptyOrNull = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_emptyOrNull);
        return objReturn_emptyOrNull;
    }

    @Override
    public IllegalArgumentException greaterThanZero(String name, Number val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229039: {}  must be greater than 0 (actual value: {})", (Object[])new Object[]{name, val}).getMessage();
        IllegalArgumentException objReturn_greaterThanZero = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_greaterThanZero);
        return objReturn_greaterThanZero;
    }

    @Override
    public IllegalArgumentException notPercent(String name, Number val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229040: {} must be a valid percentual value between 0 and 100 (actual value: {})", (Object[])new Object[]{name, val}).getMessage();
        IllegalArgumentException objReturn_notPercent = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_notPercent);
        return objReturn_notPercent;
    }

    @Override
    public IllegalArgumentException greaterThanMinusOne(String name, Number val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229041: {}  must be equals to -1 or greater than 0 (actual value: {})", (Object[])new Object[]{name, val}).getMessage();
        IllegalArgumentException objReturn_greaterThanMinusOne = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_greaterThanMinusOne);
        return objReturn_greaterThanMinusOne;
    }

    @Override
    public IllegalArgumentException greaterThanZeroOrMinusOne(String name, Number val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229042: {}  must be equals to -1 or greater or equals to 0 (actual value: {})", (Object[])new Object[]{name, val}).getMessage();
        IllegalArgumentException objReturn_greaterThanZeroOrMinusOne = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_greaterThanZeroOrMinusOne);
        return objReturn_greaterThanZeroOrMinusOne;
    }

    @Override
    public IllegalArgumentException mustbeBetween(String name, Integer minPriority, Integer maxPriority, Object value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229043: {} must be between {} and {} inclusive (actual value: {})", (Object[])new Object[]{name, minPriority, maxPriority, value}).getMessage();
        IllegalArgumentException objReturn_mustbeBetween = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_mustbeBetween);
        return objReturn_mustbeBetween;
    }

    @Override
    public IllegalArgumentException invalidJournalType(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229044: Invalid journal type {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidJournalType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidJournalType);
        return objReturn_invalidJournalType;
    }

    @Override
    public IllegalArgumentException invalidAddressFullPolicyType(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229045: Invalid address full message policy type {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidAddressFullPolicyType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidAddressFullPolicyType);
        return objReturn_invalidAddressFullPolicyType;
    }

    @Override
    public IllegalArgumentException greaterThanZero(Integer count) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229046: invalid value: {} count must be greater than 0", (Object[])new Object[]{count}).getMessage();
        IllegalArgumentException objReturn_greaterThanZero = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_greaterThanZero);
        return objReturn_greaterThanZero;
    }

    @Override
    public IllegalArgumentException periodMustGreaterThanZero(Long newPeriod) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229047: invalid value: {} sample period must be greater than 0", (Object[])new Object[]{newPeriod}).getMessage();
        IllegalArgumentException objReturn_periodMustGreaterThanZero = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_periodMustGreaterThanZero);
        return objReturn_periodMustGreaterThanZero;
    }

    @Override
    public IllegalArgumentException invalidNewPriority(Integer period) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229048: invalid new Priority value: {}. It must be between 0 and 9 (both included)", (Object[])new Object[]{period}).getMessage();
        IllegalArgumentException objReturn_invalidNewPriority = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidNewPriority);
        return objReturn_invalidNewPriority;
    }

    @Override
    public IllegalArgumentException noQueueFound(String otherQueueName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229049: No queue found for {}", (Object[])new Object[]{otherQueueName}).getMessage();
        IllegalArgumentException objReturn_noQueueFound = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_noQueueFound);
        return objReturn_noQueueFound;
    }

    @Override
    public IllegalArgumentException invalidJournal() {
        String returnString = "AMQ229050: Only NIO and AsyncIO are supported journals";
        IllegalArgumentException objReturn_invalidJournal = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidJournal);
        return objReturn_invalidJournal;
    }

    @Override
    public IllegalArgumentException invalidJournalType2(JournalType journalType) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229051: Invalid journal type {}", (Object[])new Object[]{journalType}).getMessage();
        IllegalArgumentException objReturn_invalidJournalType2 = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidJournalType2);
        return objReturn_invalidJournalType2;
    }

    @Override
    public IllegalArgumentException cannotCreateDir(String dir) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229052: Directory {} does not exist and cannot be created", (Object[])new Object[]{dir}).getMessage();
        IllegalArgumentException objReturn_cannotCreateDir = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_cannotCreateDir);
        return objReturn_cannotCreateDir;
    }

    @Override
    public IllegalArgumentException cannotConvertToInt() {
        String returnString = "AMQ229054: Cannot convert to int";
        IllegalArgumentException objReturn_cannotConvertToInt = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_cannotConvertToInt);
        return objReturn_cannotConvertToInt;
    }

    @Override
    public IllegalArgumentException routeNameIsNull() {
        String returnString = "AMQ229055: Routing name is null";
        IllegalArgumentException objReturn_routeNameIsNull = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_routeNameIsNull);
        return objReturn_routeNameIsNull;
    }

    @Override
    public IllegalArgumentException clusterNameIsNull() {
        String returnString = "AMQ229056: Cluster name is null";
        IllegalArgumentException objReturn_clusterNameIsNull = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_clusterNameIsNull);
        return objReturn_clusterNameIsNull;
    }

    @Override
    public IllegalArgumentException addressIsNull() {
        String returnString = "AMQ229057: Address is null";
        IllegalArgumentException objReturn_addressIsNull = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_addressIsNull);
        return objReturn_addressIsNull;
    }

    @Override
    public IllegalArgumentException bindingTypeNotSpecified() {
        String returnString = "AMQ229058: Binding type not specified";
        IllegalArgumentException objReturn_bindingTypeNotSpecified = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_bindingTypeNotSpecified);
        return objReturn_bindingTypeNotSpecified;
    }

    @Override
    public IllegalArgumentException bindingIdNotSpecified() {
        String returnString = "AMQ229059: Binding ID is null";
        IllegalArgumentException objReturn_bindingIdNotSpecified = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_bindingIdNotSpecified);
        return objReturn_bindingIdNotSpecified;
    }

    @Override
    public IllegalArgumentException distancenotSpecified() {
        String returnString = "AMQ229060: Distance is null";
        IllegalArgumentException objReturn_distancenotSpecified = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_distancenotSpecified);
        return objReturn_distancenotSpecified;
    }

    @Override
    public IllegalArgumentException connectionExists(Object id) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229061: Connection already exists with id {}", (Object[])new Object[]{id}).getMessage();
        IllegalArgumentException objReturn_connectionExists = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_connectionExists);
        return objReturn_connectionExists;
    }

    @Override
    public IllegalArgumentException acceptorExists(Integer id) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229062: Acceptor with id {} already registered", (Object[])new Object[]{id}).getMessage();
        IllegalArgumentException objReturn_acceptorExists = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_acceptorExists);
        return objReturn_acceptorExists;
    }

    @Override
    public IllegalArgumentException acceptorNotExists(Integer id) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229063: Acceptor with id {} not registered", (Object[])new Object[]{id}).getMessage();
        IllegalArgumentException objReturn_acceptorNotExists = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_acceptorNotExists);
        return objReturn_acceptorNotExists;
    }

    @Override
    public IllegalArgumentException unknownProtocol(String protocol) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229064: Unknown protocol {}", (Object[])new Object[]{protocol}).getMessage();
        IllegalArgumentException objReturn_unknownProtocol = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_unknownProtocol);
        return objReturn_unknownProtocol;
    }

    @Override
    public IllegalArgumentException nodeIdNull() {
        String returnString = "AMQ229065: node id is null";
        IllegalArgumentException objReturn_nodeIdNull = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_nodeIdNull);
        return objReturn_nodeIdNull;
    }

    @Override
    public IllegalArgumentException queueNameIsNull() {
        String returnString = "AMQ229066: Queue name is null";
        IllegalArgumentException objReturn_queueNameIsNull = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_queueNameIsNull);
        return objReturn_queueNameIsNull;
    }

    @Override
    public IllegalArgumentException cannotFindResource(String resourceName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229067: Cannot find resource with name {}", (Object[])new Object[]{resourceName}).getMessage();
        IllegalArgumentException objReturn_cannotFindResource = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_cannotFindResource);
        return objReturn_cannotFindResource;
    }

    @Override
    public IllegalArgumentException noGetterMethod(String resourceName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229068: no getter method for {}", (Object[])new Object[]{resourceName}).getMessage();
        IllegalArgumentException objReturn_noGetterMethod = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_noGetterMethod);
        return objReturn_noGetterMethod;
    }

    @Override
    public IllegalArgumentException noOperation(String operation, Integer length) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229069: no operation {}/{}", (Object[])new Object[]{operation, length}).getMessage();
        IllegalArgumentException objReturn_noOperation = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_noOperation);
        return objReturn_noOperation;
    }

    @Override
    public IllegalArgumentException nullMatch() {
        String returnString = "AMQ229070: match can not be null";
        IllegalArgumentException objReturn_nullMatch = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_nullMatch);
        return objReturn_nullMatch;
    }

    @Override
    public IllegalArgumentException invalidMatch() {
        String returnString = "AMQ229071: # can only be at end of match";
        IllegalArgumentException objReturn_invalidMatch = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidMatch);
        return objReturn_invalidMatch;
    }

    @Override
    public IllegalArgumentException nullUser() {
        String returnString = "AMQ229072: User cannot be null";
        IllegalArgumentException objReturn_nullUser = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_nullUser);
        return objReturn_nullUser;
    }

    @Override
    public IllegalArgumentException nullPassword() {
        String returnString = "AMQ229073: Password cannot be null";
        IllegalArgumentException objReturn_nullPassword = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_nullPassword);
        return objReturn_nullPassword;
    }

    @Override
    public IllegalArgumentException errorCreatingTransformerClass(String transformerClassName, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229074: Error instantiating transformer class {}", (Object[])new Object[]{transformerClassName, e}).getMessage();
        IllegalArgumentException objReturn_errorCreatingTransformerClass = new IllegalArgumentException(returnString);
        objReturn_errorCreatingTransformerClass.initCause(e);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_errorCreatingTransformerClass);
        return objReturn_errorCreatingTransformerClass;
    }

    @Override
    public IllegalArgumentException autoConvertError(Class<? extends Object> aClass) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229075: method autoEncode doesn't know how to convert {} yet", (Object[])new Object[]{aClass}).getMessage();
        IllegalArgumentException objReturn_autoConvertError = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_autoConvertError);
        return objReturn_autoConvertError;
    }

    @Override
    public String destroyConnectionWithSessionMetadataHeader(String key, String value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229076: Executing destroyConnection with {}={} through management's request", (Object[])new Object[]{key, value}).getMessage();
        return returnString;
    }

    @Override
    public String destroyConnectionWithSessionMetadataClosingConnection(String serverSessionString) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229077: Closing connection {}", (Object[])new Object[]{serverSessionString}).getMessage();
        return returnString;
    }

    @Override
    public ActiveMQDisconnectedException destroyConnectionWithSessionMetadataSendException(String key, String value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229078: Disconnected per admin's request on {}={}", (Object[])new Object[]{key, value}).getMessage();
        ActiveMQDisconnectedException objReturn_destroyConnectionWithSessionMetadataSendException = new ActiveMQDisconnectedException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_destroyConnectionWithSessionMetadataSendException);
        return objReturn_destroyConnectionWithSessionMetadataSendException;
    }

    @Override
    public String destroyConnectionWithSessionMetadataNoSessionFound(String key, String value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229079: No session found with {}={}", (Object[])new Object[]{key, value}).getMessage();
        return returnString;
    }

    @Override
    public ActiveMQIllegalStateException invalidPageIO() {
        String returnString = "AMQ229080: Invalid Page IO, PagingManager was stopped or closed";
        ActiveMQIllegalStateException objReturn_invalidPageIO = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidPageIO);
        return objReturn_invalidPageIO;
    }

    @Override
    public ActiveMQException noDiscoveryGroupFound(DiscoveryGroupConfiguration dg) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229081: No Discovery Group configuration named {} found", (Object[])new Object[]{dg}).getMessage();
        ActiveMQException objReturn_noDiscoveryGroupFound = new ActiveMQException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_noDiscoveryGroupFound);
        return objReturn_noDiscoveryGroupFound;
    }

    @Override
    public ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentAddress(SimpleString queueName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229082: Queue {} already exists on another subscription", (Object[])new Object[]{queueName}).getMessage();
        ActiveMQInvalidTransientQueueUseException objReturn_queueSubscriptionBelongsToDifferentAddress = new ActiveMQInvalidTransientQueueUseException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_queueSubscriptionBelongsToDifferentAddress);
        return objReturn_queueSubscriptionBelongsToDifferentAddress;
    }

    @Override
    public ActiveMQInvalidTransientQueueUseException queueSubscriptionBelongsToDifferentFilter(SimpleString queueName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229083: Queue {} has a different filter than requested", (Object[])new Object[]{queueName}).getMessage();
        ActiveMQInvalidTransientQueueUseException objReturn_queueSubscriptionBelongsToDifferentFilter = new ActiveMQInvalidTransientQueueUseException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_queueSubscriptionBelongsToDifferentFilter);
        return objReturn_queueSubscriptionBelongsToDifferentFilter;
    }

    @Override
    public ActiveMQClusterSecurityException unableToValidateClusterUser(String user) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229099: Unable to authenticate cluster user: {}", (Object[])new Object[]{user}).getMessage();
        ActiveMQClusterSecurityException objReturn_unableToValidateClusterUser = new ActiveMQClusterSecurityException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_unableToValidateClusterUser);
        return objReturn_unableToValidateClusterUser;
    }

    @Override
    public IllegalStateException journalDirIsFile(File fDir) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229100: Trying to move a journal file that refers to a file instead of a directory: {}", (Object[])new Object[]{fDir}).getMessage();
        IllegalStateException objReturn_journalDirIsFile = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_journalDirIsFile);
        return objReturn_journalDirIsFile;
    }

    @Override
    public IllegalStateException couldNotMoveJournal(File dir) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229101: error trying to backup journal files at directory: {}", (Object[])new Object[]{dir}).getMessage();
        IllegalStateException objReturn_couldNotMoveJournal = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_couldNotMoveJournal);
        return objReturn_couldNotMoveJournal;
    }

    @Override
    public ActiveMQAddressFullException addressIsFull(String addressName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229102: Address \"{}\" is full.", (Object[])new Object[]{addressName}).getMessage();
        ActiveMQAddressFullException objReturn_addressIsFull = new ActiveMQAddressFullException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_addressIsFull);
        return objReturn_addressIsFull;
    }

    @Override
    public ActiveMQException noConfigurationFoundForScaleDown() {
        String returnString = "AMQ229103: No Connectors or Discovery Groups configured for Scale Down";
        ActiveMQException objReturn_noConfigurationFoundForScaleDown = new ActiveMQException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_noConfigurationFoundForScaleDown);
        return objReturn_noConfigurationFoundForScaleDown;
    }

    @Override
    public ActiveMQException groupWhileStopping() {
        String returnString = "AMQ229104: Server is stopping. Message grouping not allowed";
        ActiveMQException objReturn_groupWhileStopping = new ActiveMQException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_groupWhileStopping);
        return objReturn_groupWhileStopping;
    }

    @Override
    public IllegalArgumentException invalidSlowConsumerPolicyType(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229106: Invalid slow consumer policy type {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidSlowConsumerPolicyType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidSlowConsumerPolicyType);
        return objReturn_invalidSlowConsumerPolicyType;
    }

    @Override
    public ActiveMQInternalErrorException consumerConnectionsClosedByManagement(String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229107: consumer connections for address {} closed by management", (Object[])new Object[]{address}).getMessage();
        ActiveMQInternalErrorException objReturn_consumerConnectionsClosedByManagement = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_consumerConnectionsClosedByManagement);
        return objReturn_consumerConnectionsClosedByManagement;
    }

    @Override
    public ActiveMQInternalErrorException connectionsForUserClosedByManagement(String userName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229108: connections for user {} closed by management", (Object[])new Object[]{userName}).getMessage();
        ActiveMQInternalErrorException objReturn_connectionsForUserClosedByManagement = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionsForUserClosedByManagement);
        return objReturn_connectionsForUserClosedByManagement;
    }

    @Override
    public ActiveMQIllegalStateException unsupportedHAPolicyConfiguration(Object o) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229109: unsupported HA Policy Configuration {}", (Object[])new Object[]{o}).getMessage();
        ActiveMQIllegalStateException objReturn_unsupportedHAPolicyConfiguration = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_unsupportedHAPolicyConfiguration);
        return objReturn_unsupportedHAPolicyConfiguration;
    }

    @Override
    public ActiveMQSessionCreationException sessionLimitReached(String username, int limit) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229110: Too many sessions for user '{}'. Sessions allowed: {}.", (Object[])new Object[]{username, limit}).getMessage();
        ActiveMQSessionCreationException objReturn_sessionLimitReached = new ActiveMQSessionCreationException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_sessionLimitReached);
        return objReturn_sessionLimitReached;
    }

    @Override
    public ActiveMQSecurityException queueLimitReached(String username, int limit) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229111: Too many queues created by user '{}'. Queues allowed: {}.", (Object[])new Object[]{username, limit}).getMessage();
        ActiveMQSecurityException objReturn_queueLimitReached = new ActiveMQSecurityException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_queueLimitReached);
        return objReturn_queueLimitReached;
    }

    @Override
    public IllegalStateException cannotSetMBeanserver() {
        String returnString = "AMQ229112: Cannot set MBeanServer during startup or while started";
        IllegalStateException objReturn_cannotSetMBeanserver = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_cannotSetMBeanserver);
        return objReturn_cannotSetMBeanserver;
    }

    @Override
    public IllegalArgumentException invalidMessageLoadBalancingType(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229113: Invalid message load balancing type {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidMessageLoadBalancingType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidMessageLoadBalancingType);
        return objReturn_invalidMessageLoadBalancingType;
    }

    @Override
    public ActiveMQReplicationTimeooutException replicationSynchronizationTimeout(long timeout) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229114: Replication synchronization process timed out after waiting {} milliseconds", (Object[])new Object[]{timeout}).getMessage();
        ActiveMQReplicationTimeooutException objReturn_replicationSynchronizationTimeout = new ActiveMQReplicationTimeooutException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_replicationSynchronizationTimeout);
        return objReturn_replicationSynchronizationTimeout;
    }

    @Override
    public ActiveMQIllegalStateException liveBackupMismatch() {
        String returnString = "AMQ229115: Colocated Policy hasn't different type live and backup";
        ActiveMQIllegalStateException objReturn_liveBackupMismatch = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_liveBackupMismatch);
        return objReturn_liveBackupMismatch;
    }

    @Override
    public IllegalStateException acceptorUnavailable() {
        String returnString = "AMQ229116: Netty Acceptor unavailable";
        IllegalStateException objReturn_acceptorUnavailable = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_acceptorUnavailable);
        return objReturn_acceptorUnavailable;
    }

    @Override
    public ActiveMQIllegalStateException replicatorIsNull() {
        String returnString = "AMQ229117: Replicator is null. Replication was likely terminated.";
        ActiveMQIllegalStateException objReturn_replicatorIsNull = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_replicatorIsNull);
        return objReturn_replicatorIsNull;
    }

    @Override
    public IllegalStateException methodNotApplicable() {
        String returnString = "AMQ229118: Management method not applicable for current server configuration";
        IllegalStateException objReturn_methodNotApplicable = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_methodNotApplicable);
        return objReturn_methodNotApplicable;
    }

    @Override
    public ActiveMQIOErrorException diskBeyondLimit(String usableSpace, String totalSpace, String usage) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229119: Free storage space is at {} of {} total. Usage rate is {} which is beyond the configured <max-disk-usage>. System will start blocking producers.", (Object[])new Object[]{usableSpace, totalSpace, usage}).getMessage();
        ActiveMQIOErrorException objReturn_diskBeyondLimit = new ActiveMQIOErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_diskBeyondLimit);
        return objReturn_diskBeyondLimit;
    }

    @Override
    public ActiveMQInternalErrorException connectionWithIDClosedByManagement(String ID) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229120: connection with ID {} closed by management", (Object[])new Object[]{ID}).getMessage();
        ActiveMQInternalErrorException objReturn_connectionWithIDClosedByManagement = new ActiveMQInternalErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionWithIDClosedByManagement);
        return objReturn_connectionWithIDClosedByManagement;
    }

    @Override
    public ActiveMQQueueMaxConsumerLimitReached maxConsumerLimitReachedForQueue(SimpleString address, SimpleString queueName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229200: Maximum Consumer Limit Reached on Queue:(address={},queue={})", (Object[])new Object[]{address, queueName}).getMessage();
        ActiveMQQueueMaxConsumerLimitReached objReturn_maxConsumerLimitReachedForQueue = new ActiveMQQueueMaxConsumerLimitReached(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_maxConsumerLimitReachedForQueue);
        return objReturn_maxConsumerLimitReachedForQueue;
    }

    @Override
    public ActiveMQUnexpectedRoutingTypeForAddress unexpectedRoutingTypeForAddress(RoutingType expectedRoutingType, Set<RoutingType> supportedRoutingTypes, SimpleString address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229201: Expected Routing Type {} but found {} for address {}", (Object[])new Object[]{expectedRoutingType, supportedRoutingTypes, address}).getMessage();
        ActiveMQUnexpectedRoutingTypeForAddress objReturn_unexpectedRoutingTypeForAddress = new ActiveMQUnexpectedRoutingTypeForAddress(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_unexpectedRoutingTypeForAddress);
        return objReturn_unexpectedRoutingTypeForAddress;
    }

    @Override
    public ActiveMQInvalidQueueConfiguration invalidQueueConfiguration(SimpleString queueName, SimpleString address, String queuePropertyName, Object expectedValue, Object actualValue) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229202: Invalid Queue Configuration for Queue {}, Address {}.  Expected {} to be {} but was {}", (Object[])new Object[]{queueName, address, queuePropertyName, expectedValue, actualValue}).getMessage();
        ActiveMQInvalidQueueConfiguration objReturn_invalidQueueConfiguration = new ActiveMQInvalidQueueConfiguration(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidQueueConfiguration);
        return objReturn_invalidQueueConfiguration;
    }

    @Override
    public ActiveMQAddressDoesNotExistException addressDoesNotExist(SimpleString address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229203: Address Does Not Exist: {}", (Object[])new Object[]{address}).getMessage();
        ActiveMQAddressDoesNotExistException objReturn_addressDoesNotExist = new ActiveMQAddressDoesNotExistException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_addressDoesNotExist);
        return objReturn_addressDoesNotExist;
    }

    @Override
    public ActiveMQAddressExistsException addressAlreadyExists(SimpleString address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229204: Address already exists: {}", (Object[])new Object[]{address}).getMessage();
        ActiveMQAddressExistsException objReturn_addressAlreadyExists = new ActiveMQAddressExistsException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_addressAlreadyExists);
        return objReturn_addressAlreadyExists;
    }

    @Override
    public ActiveMQDeleteAddressException addressHasBindings(SimpleString address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229205: Address {} has bindings", (Object[])new Object[]{address}).getMessage();
        ActiveMQDeleteAddressException objReturn_addressHasBindings = new ActiveMQDeleteAddressException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_addressHasBindings);
        return objReturn_addressHasBindings;
    }

    @Override
    public IllegalArgumentException invalidMaxConsumers(String queueName, int value) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229206: Queue {} has invalid max consumer setting: {}", (Object[])new Object[]{queueName, value}).getMessage();
        IllegalArgumentException objReturn_invalidMaxConsumers = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidMaxConsumers);
        return objReturn_invalidMaxConsumers;
    }

    @Override
    public IllegalArgumentException invalidRoutingTypeForAddress(RoutingType routingType, String address, Set<RoutingType> supportedRoutingTypes) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229207: Can not create queue with routing type: {}, Supported routing types for address: {} are {}", (Object[])new Object[]{routingType, address, supportedRoutingTypes}).getMessage();
        IllegalArgumentException objReturn_invalidRoutingTypeForAddress = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidRoutingTypeForAddress);
        return objReturn_invalidRoutingTypeForAddress;
    }

    @Override
    public IllegalArgumentException invalidRoutingType(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229208: Invalid routing type {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidRoutingType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidRoutingType);
        return objReturn_invalidRoutingType;
    }

    @Override
    public IllegalStateException invalidRoutingTypeDelete(RoutingType routingType, String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229209: Can't remove routing type {}, queues exists for address: {}. Please delete queues before removing this routing type.", (Object[])new Object[]{routingType, address}).getMessage();
        IllegalStateException objReturn_invalidRoutingTypeDelete = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidRoutingTypeDelete);
        return objReturn_invalidRoutingTypeDelete;
    }

    @Override
    public IllegalStateException invalidMaxConsumersUpdate(String queueName, int maxConsumers, int consumers) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229210: Can't update queue {} with maxConsumers: {}. Current consumers are {}.", (Object[])new Object[]{queueName, maxConsumers, consumers}).getMessage();
        IllegalStateException objReturn_invalidMaxConsumersUpdate = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidMaxConsumersUpdate);
        return objReturn_invalidMaxConsumersUpdate;
    }

    @Override
    public IllegalStateException invalidRoutingTypeUpdate(String queueName, RoutingType routingType, String address, Set<RoutingType> supportedRoutingTypes) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229211: Can't update queue {} with routing type: {}, Supported routing types for address: {} are {}", (Object[])new Object[]{queueName, routingType, address, supportedRoutingTypes}).getMessage();
        IllegalStateException objReturn_invalidRoutingTypeUpdate = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidRoutingTypeUpdate);
        return objReturn_invalidRoutingTypeUpdate;
    }

    @Override
    public IllegalArgumentException invalidDeletionPolicyType(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229212: Invalid deletion policy type {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidDeletionPolicyType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidDeletionPolicyType);
        return objReturn_invalidDeletionPolicyType;
    }

    @Override
    public ActiveMQSecurityException userNoPermissionsQueue(String username, CheckType checkType, SimpleString queue, SimpleString address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229213: User: {} does not have permission='{}' for queue {} on address {}", (Object[])new Object[]{username, checkType, queue, address}).getMessage();
        ActiveMQSecurityException objReturn_userNoPermissionsQueue = new ActiveMQSecurityException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_userNoPermissionsQueue);
        return objReturn_userNoPermissionsQueue;
    }

    @Override
    public IllegalArgumentException notPercentOrMinusOne(String name, Number val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229214: {} must be a valid percentage value between 0 and 100 or -1 (actual value: {})", (Object[])new Object[]{name, val}).getMessage();
        IllegalArgumentException objReturn_notPercentOrMinusOne = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_notPercentOrMinusOne);
        return objReturn_notPercentOrMinusOne;
    }

    @Override
    public ActiveMQIllegalStateException cannotDeleteQueueWithMessages(SimpleString name, SimpleString queueName, long messageCount) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229215: Cannot delete queue {} on binding {} - it has {} messages", (Object[])new Object[]{name, queueName, messageCount}).getMessage();
        ActiveMQIllegalStateException objReturn_cannotDeleteQueueWithMessages = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_cannotDeleteQueueWithMessages);
        return objReturn_cannotDeleteQueueWithMessages;
    }

    @Override
    public ActiveMQIllegalStateException invalidQueueName(SimpleString queueName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229216: Invalid queue name: {}", (Object[])new Object[]{queueName}).getMessage();
        ActiveMQIllegalStateException objReturn_invalidQueueName = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidQueueName);
        return objReturn_invalidQueueName;
    }

    @Override
    public ActiveMQIOErrorException cannotWriteToClosedFile(SequentialFile file) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229217: Cannot write to closed file: {}", (Object[])new Object[]{file}).getMessage();
        ActiveMQIOErrorException objReturn_cannotWriteToClosedFile = new ActiveMQIOErrorException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_cannotWriteToClosedFile);
        return objReturn_cannotWriteToClosedFile;
    }

    @Override
    public ActiveMQIllegalStateException failedToLocateConfigURL() {
        String returnString = "AMQ229218: Failed to locate broker configuration URL";
        ActiveMQIllegalStateException objReturn_failedToLocateConfigURL = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_failedToLocateConfigURL);
        return objReturn_failedToLocateConfigURL;
    }

    @Override
    public ActiveMQIllegalStateException failedToLoadSecurityConfig() {
        String returnString = "AMQ229219: Failed to load security configuration";
        ActiveMQIllegalStateException objReturn_failedToLoadSecurityConfig = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_failedToLoadSecurityConfig);
        return objReturn_failedToLoadSecurityConfig;
    }

    @Override
    public ActiveMQIllegalStateException failedToLoadUserFile(String path) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229220: Failed to load user file: {}", (Object[])new Object[]{path}).getMessage();
        ActiveMQIllegalStateException objReturn_failedToLoadUserFile = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_failedToLoadUserFile);
        return objReturn_failedToLoadUserFile;
    }

    @Override
    public ActiveMQIllegalStateException failedToLoadRoleFile(String path) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229221: Failed to load role file: {}", (Object[])new Object[]{path}).getMessage();
        ActiveMQIllegalStateException objReturn_failedToLoadRoleFile = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_failedToLoadRoleFile);
        return objReturn_failedToLoadRoleFile;
    }

    @Override
    public ActiveMQIllegalStateException failedToFindLoginModuleEntry(String entry) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229222: Failed to find login module entry {} from JAAS configuration", (Object[])new Object[]{entry}).getMessage();
        ActiveMQIllegalStateException objReturn_failedToFindLoginModuleEntry = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_failedToFindLoginModuleEntry);
        return objReturn_failedToFindLoginModuleEntry;
    }

    @Override
    public IllegalArgumentException userAlreadyExists(String user) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229223: User {} already exists", (Object[])new Object[]{user}).getMessage();
        IllegalArgumentException objReturn_userAlreadyExists = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_userAlreadyExists);
        return objReturn_userAlreadyExists;
    }

    @Override
    public IllegalArgumentException userDoesNotExist(String user) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229224: User {} does not exist", (Object[])new Object[]{user}).getMessage();
        IllegalArgumentException objReturn_userDoesNotExist = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_userDoesNotExist);
        return objReturn_userDoesNotExist;
    }

    @Override
    public ActiveMQIllegalStateException rejectEmptyValidatedUser() {
        String returnString = "AMQ229225: Validated User is not set";
        ActiveMQIllegalStateException objReturn_rejectEmptyValidatedUser = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_rejectEmptyValidatedUser);
        return objReturn_rejectEmptyValidatedUser;
    }

    @Override
    public IllegalArgumentException inRangeOfPositiveInt(String name, Number val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229226: {}  must be greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {})", (Object[])new Object[]{name, val}).getMessage();
        IllegalArgumentException objReturn_inRangeOfPositiveInt = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_inRangeOfPositiveInt);
        return objReturn_inRangeOfPositiveInt;
    }

    @Override
    public IllegalArgumentException inRangeOfPositiveIntThanMinusOne(String name, Number val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229227: {}  must be equals to -1 or greater than 0 and less than or equal to Integer.MAX_VALUE (actual value: {})", (Object[])new Object[]{name, val}).getMessage();
        IllegalArgumentException objReturn_inRangeOfPositiveIntThanMinusOne = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_inRangeOfPositiveIntThanMinusOne);
        return objReturn_inRangeOfPositiveIntThanMinusOne;
    }

    @Override
    public IllegalArgumentException lessThanOrEqualToOne(String name, Number val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229228: {} must be less than or equal to 1 (actual value: {})", (Object[])new Object[]{name, val}).getMessage();
        IllegalArgumentException objReturn_lessThanOrEqualToOne = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_lessThanOrEqualToOne);
        return objReturn_lessThanOrEqualToOne;
    }

    @Override
    public IllegalArgumentException failedToParseJson(String json) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229229: Failed to parse JSON queue configuration: {}", (Object[])new Object[]{json}).getMessage();
        IllegalArgumentException objReturn_failedToParseJson = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_failedToParseJson);
        return objReturn_failedToParseJson;
    }

    @Override
    public IllegalStateException failedToBind(String acceptor, String hostPort, Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229230: Failed to bind acceptor {} to {}", (Object[])new Object[]{acceptor, hostPort, e}).getMessage();
        IllegalStateException objReturn_failedToBind = new IllegalStateException(returnString);
        objReturn_failedToBind.initCause(e);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_failedToBind);
        return objReturn_failedToBind;
    }

    @Override
    public ActiveMQDivertDoesNotExistException divertDoesNotExist(String divert) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229231: Divert Does Not Exist: {}", (Object[])new Object[]{divert}).getMessage();
        ActiveMQDivertDoesNotExistException objReturn_divertDoesNotExist = new ActiveMQDivertDoesNotExistException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_divertDoesNotExist);
        return objReturn_divertDoesNotExist;
    }

    @Override
    public ActiveMQIllegalStateException cannotCreateConsumerOnClosedSession(SimpleString queueName) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229232: Cannot create consumer on {}. Session is closed.", (Object[])new Object[]{queueName}).getMessage();
        ActiveMQIllegalStateException objReturn_cannotCreateConsumerOnClosedSession = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_cannotCreateConsumerOnClosedSession);
        return objReturn_cannotCreateConsumerOnClosedSession;
    }

    @Override
    public IllegalStateException cannotSetSecurityManager() {
        String returnString = "AMQ229233: Cannot set ActiveMQSecurityManager during startup or while started";
        IllegalStateException objReturn_cannotSetSecurityManager = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_cannotSetSecurityManager);
        return objReturn_cannotSetSecurityManager;
    }

    @Override
    public IllegalArgumentException invalidSlowConsumerThresholdMeasurementUnit(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229234: Invalid slow consumer threshold measurement unit {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidSlowConsumerThresholdMeasurementUnit = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidSlowConsumerThresholdMeasurementUnit);
        return objReturn_invalidSlowConsumerThresholdMeasurementUnit;
    }

    @Override
    public ActiveMQIllegalStateException bindingAlreadyExists(String name, String binding) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229235: Incompatible binding with name {} already exists: {}", (Object[])new Object[]{name, binding}).getMessage();
        ActiveMQIllegalStateException objReturn_bindingAlreadyExists = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_bindingAlreadyExists);
        return objReturn_bindingAlreadyExists;
    }

    @Override
    public IllegalArgumentException invalidConnectionRouterKey(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229236: Invalid connection router key {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidConnectionRouterKey = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidConnectionRouterKey);
        return objReturn_invalidConnectionRouterKey;
    }

    @Override
    public ActiveMQRoutingException connectionRedirected(String connectionRouter, TransportConfiguration connector) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229237: Connection router {} redirected the connection to {}", (Object[])new Object[]{connectionRouter, connector}).getMessage();
        ActiveMQRoutingException objReturn_connectionRedirected = new ActiveMQRoutingException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionRedirected);
        return objReturn_connectionRedirected;
    }

    @Override
    public ActiveMQRoutingException connectionRouterNotReady(String connectionRouter) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229238: Connection router {} not ready", (Object[])new Object[]{connectionRouter}).getMessage();
        ActiveMQRoutingException objReturn_connectionRouterNotReady = new ActiveMQRoutingException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionRouterNotReady);
        return objReturn_connectionRouterNotReady;
    }

    @Override
    public IllegalArgumentException noRetention() {
        String returnString = "AMQ229239: There is no retention configured. In order to use the replay method you must specify journal-retention-directory element on the broker.xml";
        IllegalArgumentException objReturn_noRetention = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_noRetention);
        return objReturn_noRetention;
    }

    @Override
    public ActiveMQRemoteDisconnectException connectionRejected(String connectionRouter) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229240: Connection router {} rejected the connection", (Object[])new Object[]{connectionRouter}).getMessage();
        ActiveMQRemoteDisconnectException objReturn_connectionRejected = new ActiveMQRemoteDisconnectException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_connectionRejected);
        return objReturn_connectionRejected;
    }

    @Override
    public ActiveMQIllegalStateException embeddedWebServerNotFound() {
        String returnString = "AMQ229241: Embedded web server not found";
        ActiveMQIllegalStateException objReturn_embeddedWebServerNotFound = new ActiveMQIllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_embeddedWebServerNotFound);
        return objReturn_embeddedWebServerNotFound;
    }

    @Override
    public ActiveMQTimeoutException embeddedWebServerRestartTimeout(long timeout) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229242: Embedded web server not restarted in {} milliseconds", (Object[])new Object[]{timeout}).getMessage();
        ActiveMQTimeoutException objReturn_embeddedWebServerRestartTimeout = new ActiveMQTimeoutException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_embeddedWebServerRestartTimeout);
        return objReturn_embeddedWebServerRestartTimeout;
    }

    @Override
    public ActiveMQException embeddedWebServerRestartFailed(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229243: Embedded web server restart failed", (Object[])new Object[]{e}).getMessage();
        ActiveMQException objReturn_embeddedWebServerRestartFailed = new ActiveMQException(returnString);
        objReturn_embeddedWebServerRestartFailed.initCause((Throwable)e);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_embeddedWebServerRestartFailed);
        return objReturn_embeddedWebServerRestartFailed;
    }

    @Override
    public IllegalStateException metersAlreadyRegistered(String resource) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229244: Meters already registered for {}", (Object[])new Object[]{resource}).getMessage();
        IllegalStateException objReturn_metersAlreadyRegistered = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_metersAlreadyRegistered);
        return objReturn_metersAlreadyRegistered;
    }

    @Override
    public ActiveMQTimeoutException managementBusy() {
        String returnString = "AMQ229245: Management controller is busy with another task. Please try again";
        ActiveMQTimeoutException objReturn_managementBusy = new ActiveMQTimeoutException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne((Throwable)objReturn_managementBusy);
        return objReturn_managementBusy;
    }

    @Override
    public IllegalArgumentException invalidPageFullPolicyType(String val) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229246: Invalid page full message policy type {}", (Object[])new Object[]{val}).getMessage();
        IllegalArgumentException objReturn_invalidPageFullPolicyType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidPageFullPolicyType);
        return objReturn_invalidPageFullPolicyType;
    }

    @Override
    public IllegalArgumentException addressWithNoRoutingType(String address) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229247: Invalid address configuration for '{}'. Address must support multicast and/or anycast.", (Object[])new Object[]{address}).getMessage();
        IllegalArgumentException objReturn_addressWithNoRoutingType = new IllegalArgumentException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_addressWithNoRoutingType);
        return objReturn_addressWithNoRoutingType;
    }

    @Override
    public IllegalStateException invalidWebSocketEncoderType(String webSocketEncoderType) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ229248: Invalid value for webSocketEncoderType: '{}'. Supported values: 'binary', 'text'.", (Object[])new Object[]{webSocketEncoderType}).getMessage();
        IllegalStateException objReturn_invalidWebSocketEncoderType = new IllegalStateException(returnString);
        ActiveMQMessageBundle_impl._copyStackTraceMinusOne(objReturn_invalidWebSocketEncoderType);
        return objReturn_invalidWebSocketEncoderType;
    }
}

