/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.authorize;

import java.util.Set;
import org.apache.atlas.authorize.AtlasAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.type.AtlasTypeRegistry;

public class AtlasEntityAccessRequest
extends AtlasAccessRequest {
    private final AtlasEntityHeader entity;
    private final String entityId;
    private final AtlasClassification classification;
    private final String label;
    private final String businessMetadata;
    private final String attributeName;
    private final AtlasTypeRegistry typeRegistry;
    private final Set<String> entityClassifications;

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action) {
        this(typeRegistry, action, null, null, null, null, null, null, null);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity) {
        this(typeRegistry, action, entity, null, null, null, null, null, null);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, AtlasClassification classification) {
        this(typeRegistry, action, entity, classification, null, null, null, null, null);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, String attributeName) {
        this(typeRegistry, action, entity, null, attributeName, null, null, null, null);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, String userName, Set<String> userGroups) {
        this(typeRegistry, action, entity, null, null, null, null, userName, userGroups);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, AtlasClassification classification, String userName, Set<String> userGroups) {
        this(typeRegistry, action, entity, classification, null, null, null, userName, userGroups);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, String attributeName, String userName, Set<String> userGroups) {
        this(typeRegistry, action, entity, null, attributeName, null, null, userName, userGroups);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, AtlasClassification classification, String attributeName, String userName, Set<String> userGroups) {
        this(typeRegistry, action, entity, classification, attributeName, null, null, userName, userGroups);
    }

    public AtlasEntityAccessRequest(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity, AtlasClassification classification, String attributeName, String label, String businessMetadata, String userName, Set<String> userGroups) {
        super(action, userName, userGroups);
        this.entity = entity;
        this.entityId = super.getEntityId(entity, typeRegistry);
        this.classification = classification;
        this.label = label;
        this.businessMetadata = businessMetadata;
        this.attributeName = attributeName;
        this.typeRegistry = typeRegistry;
        this.entityClassifications = super.getClassificationNames(entity);
    }

    public AtlasEntityHeader getEntity() {
        return this.entity;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public AtlasClassification getClassification() {
        return this.classification;
    }

    public String getLabel() {
        return this.label;
    }

    public String getBusinessMetadata() {
        return this.businessMetadata;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getEntityType() {
        return this.entity == null ? "" : this.entity.getTypeName();
    }

    public Set<String> getEntityClassifications() {
        return this.entityClassifications;
    }

    public Set<String> getEntityTypeAndAllSuperTypes() {
        return super.getEntityTypeAndAllSuperTypes(this.entity == null ? null : this.entity.getTypeName(), this.typeRegistry);
    }

    public Set<String> getClassificationTypeAndAllSuperTypes(String classificationName) {
        return super.getClassificationTypeAndAllSuperTypes(classificationName, this.typeRegistry);
    }

    @Override
    public String toString() {
        return "AtlasEntityAccessRequest[entity=" + this.entity + ", classification=" + this.classification + ", label=" + this.label + ", businessMetadata=" + this.businessMetadata + ", attributeName=" + this.attributeName + ", action=" + (Object)((Object)this.getAction()) + ", accessTime=" + this.getAccessTime() + ", user=" + this.getUser() + ", userGroups=" + this.getUserGroups() + ", clientIPAddress=" + this.getClientIPAddress() + ", forwardedAddresses=" + this.getForwardedAddresses() + ", remoteIPAddress=" + this.getRemoteIPAddress() + "]";
    }

    public static class AtlasEntityAccessRequestBuilder {
        private final AtlasTypeRegistry typeRegistry;
        private final AtlasPrivilege action;
        private String userName;
        private Set<String> userGroups;
        private AtlasEntityHeader entity;
        private AtlasClassification classification;
        private String label;
        private String businessMetadata;
        private String attributeName;

        public AtlasEntityAccessRequestBuilder(AtlasTypeRegistry typeRegistry, AtlasPrivilege action) {
            this.typeRegistry = typeRegistry;
            this.action = action;
        }

        public AtlasEntityAccessRequestBuilder(AtlasTypeRegistry typeRegistry, AtlasPrivilege action, AtlasEntityHeader entity) {
            this.typeRegistry = typeRegistry;
            this.action = action;
            this.entity = entity;
        }

        public AtlasEntityAccessRequestBuilder setUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public AtlasEntityAccessRequestBuilder setUserGroups(Set<String> userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        public AtlasEntityAccessRequestBuilder setEntity(AtlasEntityHeader entity) {
            this.entity = entity;
            return this;
        }

        public AtlasEntityAccessRequestBuilder setClassification(AtlasClassification classification) {
            this.classification = classification;
            return this;
        }

        public AtlasEntityAccessRequestBuilder setLabel(String label) {
            this.label = label;
            return this;
        }

        public AtlasEntityAccessRequestBuilder setBusinessMetadata(String businessMetadata) {
            this.businessMetadata = businessMetadata;
            return this;
        }

        public AtlasEntityAccessRequestBuilder setAttributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public AtlasEntityAccessRequest build() {
            return new AtlasEntityAccessRequest(this.typeRegistry, this.action, this.entity, this.classification, this.attributeName, this.label, this.businessMetadata, this.userName, this.userGroups);
        }
    }
}

