/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.kafka;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasConfiguration;
import org.apache.atlas.AtlasException;
import org.apache.atlas.kafka.AtlasKafkaConsumer;
import org.apache.atlas.notification.AbstractNotification;
import org.apache.atlas.notification.NotificationConsumer;
import org.apache.atlas.notification.NotificationException;
import org.apache.atlas.notification.NotificationInterface;
import org.apache.atlas.security.SecurityUtil;
import org.apache.atlas.service.Service;
import org.apache.atlas.utils.KafkaUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=4)
public class KafkaNotification
extends AbstractNotification
implements Service {
    public static final Logger LOG = LoggerFactory.getLogger(KafkaNotification.class);
    public static final String PROPERTY_PREFIX = "atlas.kafka";
    public static final String ATLAS_HOOK_TOPIC = AtlasConfiguration.NOTIFICATION_HOOK_TOPIC_NAME.getString();
    public static final String ATLAS_ENTITIES_TOPIC = AtlasConfiguration.NOTIFICATION_ENTITIES_TOPIC_NAME.getString();
    protected static final String CONSUMER_GROUP_ID_PROPERTY = "group.id";
    private static final String[] ATLAS_HOOK_CONSUMER_TOPICS = AtlasConfiguration.NOTIFICATION_HOOK_CONSUMER_TOPIC_NAMES.getStringArray(new String[]{ATLAS_HOOK_TOPIC});
    private static final String[] ATLAS_ENTITIES_CONSUMER_TOPICS = AtlasConfiguration.NOTIFICATION_ENTITIES_CONSUMER_TOPIC_NAMES.getStringArray(new String[]{ATLAS_ENTITIES_TOPIC});
    private static final String DEFAULT_CONSUMER_CLOSED_ERROR_MESSAGE = "This consumer has already been closed.";
    private static final Map<NotificationInterface.NotificationType, String> PRODUCER_TOPIC_MAP = new HashMap<NotificationInterface.NotificationType, String>(){
        {
            this.put(NotificationInterface.NotificationType.HOOK, ATLAS_HOOK_TOPIC);
            this.put(NotificationInterface.NotificationType.ENTITIES, ATLAS_ENTITIES_TOPIC);
        }
    };
    private static final Map<NotificationInterface.NotificationType, String[]> CONSUMER_TOPICS_MAP = new HashMap<NotificationInterface.NotificationType, String[]>(){
        {
            this.put(NotificationInterface.NotificationType.HOOK, KafkaNotification.trimAndPurge(ATLAS_HOOK_CONSUMER_TOPICS));
            this.put(NotificationInterface.NotificationType.ENTITIES, KafkaNotification.trimAndPurge(ATLAS_ENTITIES_CONSUMER_TOPICS));
        }
    };
    private final Properties properties;
    private final Long pollTimeOutMs;
    private final Map<NotificationInterface.NotificationType, List<KafkaConsumer>> consumers = new HashMap<NotificationInterface.NotificationType, List<KafkaConsumer>>();
    private final Map<NotificationInterface.NotificationType, KafkaProducer> producers = new HashMap<NotificationInterface.NotificationType, KafkaProducer>();
    private String consumerClosedErrorMsg;

    @Inject
    public KafkaNotification(Configuration applicationProperties) throws AtlasException {
        super(applicationProperties);
        LOG.info("==> KafkaNotification()");
        Configuration kafkaConf = ApplicationProperties.getSubsetConfiguration((Configuration)applicationProperties, (String)PROPERTY_PREFIX);
        this.properties = ConfigurationConverter.getProperties((Configuration)kafkaConf);
        this.pollTimeOutMs = kafkaConf.getLong("poll.timeout.ms", 1000L);
        this.consumerClosedErrorMsg = kafkaConf.getString("error.message.consumer_closed", DEFAULT_CONSUMER_CLOSED_ERROR_MESSAGE);
        this.properties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.properties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        this.properties.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.properties.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        this.properties.put("auto.offset.reset", "earliest");
        boolean oldApiCommitEnableFlag = kafkaConf.getBoolean("auto.commit.enable", false);
        this.properties.put("enable.auto.commit", (Object)kafkaConf.getBoolean("enable.auto.commit", oldApiCommitEnableFlag));
        this.properties.put("session.timeout.ms", kafkaConf.getString("session.timeout.ms", "30000"));
        if (applicationProperties.getBoolean("atlas.enableTLS", false)) {
            try {
                this.properties.put("ssl.truststore.password", SecurityUtil.getPassword((Configuration)applicationProperties, (String)"truststore.password"));
            }
            catch (Exception e) {
                LOG.error("Exception while getpassword truststore.password ", (Throwable)e);
            }
        }
        this.properties.put("max.poll.records", (Object)kafkaConf.getInt("max.poll.records", 1));
        KafkaUtils.setKafkaJAASProperties((Configuration)applicationProperties, (Properties)this.properties);
        LOG.info("<== KafkaNotification()");
    }

    @VisibleForTesting
    protected KafkaNotification(Properties properties) {
        LOG.info("==> KafkaNotification()");
        this.properties = properties;
        this.pollTimeOutMs = 1000L;
        LOG.info("<== KafkaNotification()");
    }

    @VisibleForTesting
    String getProducerTopicName(NotificationInterface.NotificationType notificationType) {
        return PRODUCER_TOPIC_MAP.get((Object)notificationType);
    }

    public void start() throws AtlasException {
        LOG.info("==> KafkaNotification.start()");
        LOG.info("<== KafkaNotification.start()");
    }

    public void stop() {
        LOG.info("==> KafkaNotification.stop()");
        LOG.info("<== KafkaNotification.stop()");
    }

    @Override
    public boolean isReady(NotificationInterface.NotificationType notificationType) {
        try {
            KafkaProducer producer = this.getOrCreateProducer(notificationType);
            producer.metrics();
            return true;
        }
        catch (Exception exception) {
            LOG.error("Error: Connecting... {}", (Object)exception.getMessage());
            return false;
        }
    }

    @Override
    public <T> List<NotificationConsumer<T>> createConsumers(NotificationInterface.NotificationType notificationType, int numConsumers) {
        return this.createConsumers(notificationType, numConsumers, Boolean.valueOf(this.properties.getProperty("enable.auto.commit", this.properties.getProperty("auto.commit.enable", "false"))));
    }

    @VisibleForTesting
    public <T> List<NotificationConsumer<T>> createConsumers(NotificationInterface.NotificationType notificationType, int numConsumers, boolean autoCommitEnabled) {
        LOG.info("==> KafkaNotification.createConsumers(notificationType={}, numConsumers={}, autoCommitEnabled={})", new Object[]{notificationType, numConsumers, autoCommitEnabled});
        String[] topics = CONSUMER_TOPICS_MAP.get((Object)notificationType);
        if (numConsumers < topics.length) {
            LOG.warn("consumers count {} is fewer than number of topics {}. Creating {} consumers, so that consumer count is equal to number of topics.", new Object[]{numConsumers, topics.length, topics.length});
            numConsumers = topics.length;
        } else if (numConsumers > topics.length) {
            LOG.warn("consumers count {} is higher than number of topics {}. Creating {} consumers, so that consumer count is equal to number of topics", new Object[]{numConsumers, topics.length, topics.length});
            numConsumers = topics.length;
        }
        List<KafkaConsumer> notificationConsumers = this.consumers.get((Object)notificationType);
        if (notificationConsumers == null) {
            notificationConsumers = new ArrayList<KafkaConsumer>(numConsumers);
            this.consumers.put(notificationType, notificationConsumers);
        }
        ArrayList<NotificationConsumer<T>> consumers = new ArrayList<NotificationConsumer<T>>();
        Properties consumerProperties = this.getConsumerProperties(notificationType);
        consumerProperties.put("enable.auto.commit", (Object)autoCommitEnabled);
        for (int i = 0; i < numConsumers; ++i) {
            KafkaConsumer existingConsumer = notificationConsumers.size() > i ? notificationConsumers.get(i) : null;
            KafkaConsumer kafkaConsumer = this.getOrCreateKafkaConsumer(existingConsumer, consumerProperties, notificationType, i);
            if (notificationConsumers.size() > i) {
                notificationConsumers.set(i, kafkaConsumer);
            } else {
                notificationConsumers.add(kafkaConsumer);
            }
            consumers.add(new AtlasKafkaConsumer(notificationType, kafkaConsumer, autoCommitEnabled, (long)this.pollTimeOutMs));
        }
        LOG.info("<== KafkaNotification.createConsumers(notificationType={}, numConsumers={}, autoCommitEnabled={})", new Object[]{notificationType, numConsumers, autoCommitEnabled});
        return consumers;
    }

    @Override
    public void close() {
        LOG.info("==> KafkaNotification.close()");
        for (KafkaProducer producer : this.producers.values()) {
            if (producer == null) continue;
            try {
                producer.close();
            }
            catch (Throwable t) {
                LOG.error("failed to close Kafka producer. Ignoring", t);
            }
        }
        this.producers.clear();
        LOG.info("<== KafkaNotification.close()");
    }

    @Override
    public void sendInternal(NotificationInterface.NotificationType notificationType, List<String> messages) throws NotificationException {
        KafkaProducer producer = this.getOrCreateProducer(notificationType);
        this.sendInternalToProducer((Producer)producer, notificationType, messages);
    }

    @VisibleForTesting
    void sendInternalToProducer(Producer p, NotificationInterface.NotificationType notificationType, List<String> messages) throws NotificationException {
        String topic = PRODUCER_TOPIC_MAP.get((Object)notificationType);
        ArrayList<MessageContext> messageContexts = new ArrayList<MessageContext>();
        for (String message : messages) {
            ProducerRecord record = new ProducerRecord(topic, (Object)message);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending message for topic {}: {}", (Object)topic, (Object)message);
            }
            Future future = p.send(record);
            messageContexts.add(new MessageContext(future, message));
        }
        ArrayList<String> failedMessages = new ArrayList<String>();
        Exception lastFailureException = null;
        for (MessageContext context : messageContexts) {
            try {
                RecordMetadata response = context.getFuture().get();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Sent message for topic - {}, partition - {}, offset - {}", new Object[]{response.topic(), response.partition(), response.offset()});
            }
            catch (Exception e) {
                lastFailureException = e;
                failedMessages.add(context.getMessage());
            }
        }
        if (lastFailureException != null) {
            throw new NotificationException(lastFailureException, failedMessages);
        }
    }

    @VisibleForTesting
    public Properties getConsumerProperties(NotificationInterface.NotificationType notificationType) {
        String groupId = this.properties.getProperty(notificationType.toString().toLowerCase() + "." + CONSUMER_GROUP_ID_PROPERTY);
        if (StringUtils.isEmpty((String)groupId)) {
            throw new IllegalStateException("No configuration group id set for the notification type " + (Object)((Object)notificationType));
        }
        Properties consumerProperties = new Properties();
        consumerProperties.putAll((Map<?, ?>)this.properties);
        consumerProperties.put(CONSUMER_GROUP_ID_PROPERTY, groupId);
        return consumerProperties;
    }

    @VisibleForTesting
    public KafkaConsumer getOrCreateKafkaConsumer(KafkaConsumer existingConsumer, Properties consumerProperties, NotificationInterface.NotificationType notificationType, int idxConsumer) {
        KafkaConsumer ret = existingConsumer;
        try {
            if (ret == null || !this.isKafkaConsumerOpen(ret)) {
                String[] topics = CONSUMER_TOPICS_MAP.get((Object)notificationType);
                String topic = topics[idxConsumer % topics.length];
                LOG.debug("Creating new KafkaConsumer for topic : {}, index : {}", (Object)topic, (Object)idxConsumer);
                ret = new KafkaConsumer(consumerProperties);
                ret.subscribe(Arrays.asList(topic));
            }
        }
        catch (Exception ee) {
            LOG.error("Exception in getKafkaConsumer ", (Throwable)ee);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaProducer getOrCreateProducer(NotificationInterface.NotificationType notificationType) {
        LOG.debug("==> KafkaNotification.getOrCreateProducer()");
        KafkaProducer ret = this.producers.get((Object)notificationType);
        if (ret == null) {
            KafkaNotification kafkaNotification = this;
            synchronized (kafkaNotification) {
                ret = this.producers.get((Object)notificationType);
                if (ret == null) {
                    ret = new KafkaProducer(this.properties);
                    this.producers.put(notificationType, ret);
                }
            }
        }
        LOG.debug("<== KafkaNotification.getOrCreateProducer()");
        return ret;
    }

    public static String[] trimAndPurge(String[] strings) {
        ArrayList<String> ret = new ArrayList<String>();
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                String str = StringUtils.trim((String)strings[i]);
                if (!StringUtils.isNotEmpty((String)str)) continue;
                ret.add(str);
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    private boolean isKafkaConsumerOpen(KafkaConsumer consumer) {
        boolean ret;
        block2: {
            ret = true;
            try {
                consumer.listTopics();
            }
            catch (IllegalStateException ex) {
                if (!ex.getMessage().equalsIgnoreCase(this.consumerClosedErrorMsg)) break block2;
                ret = false;
            }
        }
        return ret;
    }

    private class MessageContext {
        private final Future<RecordMetadata> future;
        private final String message;

        public MessageContext(Future<RecordMetadata> future, String message) {
            this.future = future;
            this.message = message;
        }

        public Future<RecordMetadata> getFuture() {
            return this.future;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

