/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import org.apache.camel.core.osgi.OsgiDefaultCamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Registry;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.osgi.context.BundleContextAware;

public class CamelContextFactory
implements BundleContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelContextFactory.class);
    private BundleContext bundleContext;
    private Registry registry;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        LOG.debug("Using BundleContext: {}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        LOG.debug("Using Registry: {}", (Object)registry);
        this.registry = registry;
    }

    protected DefaultCamelContext newCamelContext() {
        if (this.registry != null) {
            return new OsgiDefaultCamelContext(this.bundleContext, this.registry);
        }
        return new OsgiDefaultCamelContext(this.bundleContext);
    }

    public DefaultCamelContext createContext() {
        return this.newCamelContext();
    }
}

