/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.commons.compress.compressors.pack200;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * StreamSwitcher that caches all data written to the output side in
 * memory.
 * @since Apache Commons Compress 1.3
 */
class InMemoryCachingStreamBridge extends StreamBridge {
    InMemoryCachingStreamBridge() {
        super(new ByteArrayOutputStream());
    }

    /**
     * {@inheritDoc}
     */
    @Override
    InputStream getInputView() throws IOException {
        return new ByteArrayInputStream(((ByteArrayOutputStream) out)
                                        .toByteArray());
    }
}