/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ReferralHandlingMode {
    THROW("throw"),
    FOLLOW("follow"),
    IGNORE("ignore"),
    THROW_FINDING_BASE("throw-finding-base");

    private final String jndiValue;

    private ReferralHandlingMode(String jndiValue) {
        this.jndiValue = jndiValue;
    }

    public String getJndiValue() {
        return this.jndiValue;
    }

    public static final ReferralHandlingMode getModeFromJndi(String jndiValue) {
        if ((jndiValue = jndiValue.trim().toLowerCase()).equals("throw")) {
            return THROW;
        }
        if (jndiValue.equals("follow")) {
            return FOLLOW;
        }
        if (jndiValue.equals("ignore")) {
            return IGNORE;
        }
        if (jndiValue.equals("throw-finding-base")) {
            return THROW_FINDING_BASE;
        }
        throw new IllegalArgumentException("Unknown JNDI Context.REFERRAL value of " + jndiValue);
    }
}

