/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.jndi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.AttributeType;

class JavaLdapSupport {
    public static final String JOBJECT_ATTR = "javaObject";
    public static final String JCONTAINER_ATTR = "javaContainer";
    public static final String JSERIALIZEDOBJ_ATTR = "javaSerializedObject";
    public static final String JCLASSNAME_ATTR = "javaClassName";
    public static final String JCLASSNAMES_ATTR = "javaClassNames";
    public static final String JSERIALDATA_ATTR = "javaSerializedData";

    JavaLdapSupport() {
    }

    static Object deserialize(ServerEntry serverEntry) throws NamingException {
        ObjectInputStream in = null;
        String className = serverEntry.get(JCLASSNAME_ATTR).getString();
        try {
            byte[] data = serverEntry.get(JSERIALDATA_ATTR).getBytes();
            in = new ObjectInputStream(new ByteArrayInputStream(data));
            Object object = in.readObject();
            return object;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("De-serialization of '" + className + "' instance failed:\n" + e.getMessage());
            ne.setRootCause(e);
            throw ne;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new NamingException("object deserialization stream close() failure");
            }
        }
    }

    static byte[] serialize(Object obj) throws NamingException {
        ByteArrayOutputStream bytesOut = null;
        ObjectOutputStream out = null;
        try {
            bytesOut = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bytesOut);
            out.writeObject(obj);
            byte[] byArray = bytesOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Serialization of '" + obj + "' failed:\n" + e.getMessage());
            ne.setRootCause(e);
            throw ne;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                throw new NamingException("object serialization stream close() failure");
            }
        }
    }

    static void serialize(ServerEntry entry, Object obj, Registries registries) throws NamingException {
        entry.put("objectClass", "top", JOBJECT_ATTR, JCONTAINER_ATTR, JSERIALIZEDOBJ_ATTR);
        entry.put(JCLASSNAME_ATTR, obj.getClass().getName());
        entry.put(JSERIALDATA_ATTR, (byte[][])new byte[][]{JavaLdapSupport.serialize(obj)});
        Class<?>[] classes = obj.getClass().getClasses();
        AttributeType attributeType = registries.getAttributeTypeRegistry().lookup(JCLASSNAMES_ATTR);
        DefaultServerAttribute javaClassNames = new DefaultServerAttribute(attributeType, JCLASSNAMES_ATTR);
        for (int ii = 0; ii < classes.length; ++ii) {
            javaClassNames.add(classes[ii].getName());
        }
        entry.put(javaClassNames);
    }
}

