/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.operational;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AttributeTypeAndValue;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationalAttributeInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(OperationalAttributeInterceptor.class);
    private final EntryFilter DENORMALIZING_SEARCH_FILTER = new EntryFilter(){

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry serverEntry) throws Exception {
            if (operation.getSearchControls().getReturningAttributes() == null) {
                return true;
            }
            return OperationalAttributeInterceptor.this.filterDenormalized(serverEntry);
        }
    };
    private final EntryFilter SEARCH_FILTER = new EntryFilter(){

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
            return operation.getSearchControls().getReturningAttributes() != null || OperationalAttributeInterceptor.this.filterOperationalAttributes(entry);
        }
    };
    private AttributeTypeRegistry atRegistry;
    private DirectoryService service;
    private LdapDN subschemaSubentryDn;
    private Registries registries;
    private static AttributeType CREATE_TIMESTAMP_ATTRIBUTE_TYPE;

    public void init(DirectoryService directoryService) throws Exception {
        this.service = directoryService;
        this.registries = directoryService.getRegistries();
        this.atRegistry = this.registries.getAttributeTypeRegistry();
        Value<?> subschemaSubentry = this.service.getPartitionNexus().getRootDSE(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = new LdapDN(subschemaSubentry.getString());
        this.subschemaSubentryDn.normalize(this.atRegistry.getNormalizerMapping());
        CREATE_TIMESTAMP_ATTRIBUTE_TYPE = this.atRegistry.lookup("createTimestamp");
    }

    public void destroy() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws Exception {
        String principal = OperationalAttributeInterceptor.getPrincipal().getName();
        ClonedServerEntry entry = opContext.getEntry();
        entry.put("creatorsName", principal);
        if (opContext.getEntry().containsAttribute(CREATE_TIMESTAMP_ATTRIBUTE_TYPE)) {
            if (!opContext.getSession().getAuthenticatedPrincipal().getName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
                String message = "The CreateTimeStamp attribute cannot be created by a user";
                LOG.error(message);
                throw new LdapSchemaViolationException(message, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS);
            }
            entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        } else {
            entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        }
        entry.put("entryUUID", (byte[][])new byte[][]{SchemaUtils.uuidToBytes(UUID.randomUUID())});
        entry.put("entryCSN", this.service.getCSN().toString());
        nextInterceptor.add(opContext);
    }

    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        nextInterceptor.modify(opContext);
        if (opContext.getDn().getNormName().equals(this.subschemaSubentryDn.getNormName())) {
            return;
        }
        ArrayList<Modification> modItemList = new ArrayList<Modification>(2);
        AttributeType modifiersNameAt = this.atRegistry.lookup("modifiersName");
        DefaultServerAttribute attribute = new DefaultServerAttribute("modifiersName", modifiersNameAt, OperationalAttributeInterceptor.getPrincipal().getName());
        ServerModification modifiers = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
        modItemList.add(modifiers);
        AttributeType modifyTimeStampAt = this.atRegistry.lookup("modifyTimestamp");
        attribute = new DefaultServerAttribute("modifyTimestamp", modifyTimeStampAt, DateUtils.getGeneralizedTime());
        ServerModification timestamp = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
        modItemList.add(timestamp);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getSession(), opContext.getDn(), modItemList);
        this.service.getPartitionNexus().modify(newModify);
    }

    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        nextInterceptor.rename(opContext);
        DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, opContext.getDn());
        serverEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        serverEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        LdapDN newDn = (LdapDN)opContext.getDn().clone();
        newDn.remove(opContext.getDn().size() - 1);
        newDn.add(opContext.getNewRdn());
        newDn.normalize(this.atRegistry.getNormalizerMapping());
        List<Modification> items = ModifyOperationContext.createModItems(serverEntry, ModificationOperation.REPLACE_ATTRIBUTE);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getSession(), newDn, items);
        this.service.getPartitionNexus().modify(newModify);
    }

    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        nextInterceptor.move(opContext);
        DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, opContext.getDn());
        serverEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        serverEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        List<Modification> items = ModifyOperationContext.createModItems(serverEntry, ModificationOperation.REPLACE_ATTRIBUTE);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getSession(), opContext.getParent(), items);
        this.service.getPartitionNexus().modify(newModify);
    }

    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        nextInterceptor.moveAndRename(opContext);
        DefaultServerEntry serverEntry = new DefaultServerEntry(this.registries, opContext.getDn());
        serverEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        serverEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        List<Modification> items = ModifyOperationContext.createModItems(serverEntry, ModificationOperation.REPLACE_ATTRIBUTE);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getSession(), opContext.getParent(), items);
        this.service.getPartitionNexus().modify(newModify);
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        ClonedServerEntry result = nextInterceptor.lookup(opContext);
        if (result == null) {
            return null;
        }
        if (opContext.getAttrsId() == null) {
            this.filterOperationalAttributes(result);
        } else if (opContext.getAllOperational() == null || !opContext.getAllOperational().booleanValue()) {
            this.filter(opContext, result);
        }
        this.denormalizeEntryOpAttrs(result);
        return result;
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.search(opContext);
        if (opContext.isAllOperationalAttributes() || opContext.getReturningAttributes() != null && !opContext.getReturningAttributes().isEmpty()) {
            if (this.service.isDenormalizeOpAttrsEnabled()) {
                cursor.addEntryFilter(this.DENORMALIZING_SEARCH_FILTER);
            }
            return cursor;
        }
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    private boolean filterOperationalAttributes(ServerEntry attributes) throws Exception {
        HashSet<AttributeType> removedAttributes = new HashSet<AttributeType>();
        for (AttributeType attributeType : attributes.getAttributeTypes()) {
            if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
            removedAttributes.add(attributeType);
        }
        for (AttributeType attributeType : removedAttributes) {
            attributes.removeAttributes(attributeType);
        }
        return true;
    }

    private void filter(LookupOperationContext lookupContext, ServerEntry entry) throws Exception {
        LdapDN dn = lookupContext.getDn();
        List<String> ids = lookupContext.getAttrsId();
        if (ids == null || ids.isEmpty()) {
            this.filterOperationalAttributes(entry);
            return;
        }
        Set<AttributeType> attributeTypes = entry.getAttributeTypes();
        if (dn.size() == 0) {
            for (AttributeType attributeType : attributeTypes) {
                if (ids.contains(attributeType.getOid())) continue;
                entry.removeAttributes(attributeType);
            }
        }
        this.denormalizeEntryOpAttrs(entry);
    }

    public void denormalizeEntryOpAttrs(ServerEntry entry) throws Exception {
        if (this.service.isDenormalizeOpAttrsEnabled()) {
            LdapDN modifiersName;
            EntryAttribute attr = entry.get("creatorsName");
            if (attr != null) {
                LdapDN creatorsName = new LdapDN(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(creatorsName).getUpName());
            }
            if ((attr = entry.get("modifiersName")) != null) {
                modifiersName = new LdapDN(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getUpName());
            }
            if ((attr = entry.get("schemaModifiersName")) != null) {
                modifiersName = new LdapDN(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getUpName());
            }
        }
    }

    public LdapDN denormalizeTypes(LdapDN dn) throws Exception {
        LdapDN newDn = new LdapDN();
        for (int ii = 0; ii < dn.size(); ++ii) {
            Rdn rdn = dn.getRdn(ii);
            if (rdn.size() == 0) {
                newDn.add(new Rdn());
                continue;
            }
            if (rdn.size() == 1) {
                String name = this.atRegistry.lookup(rdn.getNormType()).getName();
                String value = rdn.getAtav().getNormValue().getString();
                newDn.add(new Rdn(name, name, value, value));
                continue;
            }
            StringBuffer buf = new StringBuffer();
            Iterator<AttributeTypeAndValue> atavs = rdn.iterator();
            while (atavs.hasNext()) {
                AttributeTypeAndValue atav = atavs.next();
                String type = this.atRegistry.lookup(rdn.getNormType()).getName();
                buf.append(type).append('=').append(atav.getNormValue());
                if (!atavs.hasNext()) continue;
                buf.append('+');
            }
            newDn.add(new Rdn(buf.toString()));
        }
        return newDn;
    }

    private boolean filterDenormalized(ServerEntry entry) throws Exception {
        this.denormalizeEntryOpAttrs(entry);
        return true;
    }
}

