/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.MutableSchemaObject;
import org.apache.directory.shared.ldap.schema.ObjectClass;

public class DitContentRuleImpl
extends AbstractSchemaObject
implements MutableSchemaObject,
DITContentRule {
    private static final long serialVersionUID = 1L;
    private static final String[] EMPTY_STR_ARRAY = new String[0];
    private static final ObjectClass[] EMPTY_OC_ARRAY = new ObjectClass[0];
    private static final AttributeType[] EMPTY_ATTR_ARRAY = new AttributeType[0];
    private final Registries registries;
    private String[] auxObjectClassOids = EMPTY_STR_ARRAY;
    private ObjectClass[] auxObjectClasses = EMPTY_OC_ARRAY;
    private String[] mustNameOids = EMPTY_STR_ARRAY;
    private AttributeType[] mustNames = EMPTY_ATTR_ARRAY;
    private String[] mayNameOids = EMPTY_STR_ARRAY;
    private AttributeType[] mayNames = EMPTY_ATTR_ARRAY;
    private String[] notNameOids = EMPTY_STR_ARRAY;
    private AttributeType[] notNames = EMPTY_ATTR_ARRAY;

    protected DitContentRuleImpl(String oid, Registries registries) {
        super(oid);
        this.registries = registries;
    }

    public void setAuxObjectClassOids(String[] auxObjectClassOids) {
        if (auxObjectClassOids == null) {
            this.auxObjectClassOids = EMPTY_STR_ARRAY;
            this.auxObjectClasses = EMPTY_OC_ARRAY;
        } else {
            this.auxObjectClassOids = auxObjectClassOids;
            this.auxObjectClasses = new ObjectClass[auxObjectClassOids.length];
        }
    }

    public ObjectClass[] getAuxObjectClasses() throws NamingException {
        if (this.auxObjectClassOids == null || this.auxObjectClassOids.length == 0) {
            return EMPTY_OC_ARRAY;
        }
        for (int ii = 0; ii < this.auxObjectClassOids.length; ++ii) {
            this.auxObjectClasses[ii] = this.registries.getObjectClassRegistry().lookup(this.auxObjectClassOids[ii]);
        }
        return this.auxObjectClasses;
    }

    public void setMayNameOids(String[] mayNameOids) {
        if (mayNameOids == null) {
            this.mayNameOids = EMPTY_STR_ARRAY;
            this.mayNames = EMPTY_ATTR_ARRAY;
        } else {
            this.mayNameOids = mayNameOids;
            this.mayNames = new AttributeType[mayNameOids.length];
        }
    }

    public AttributeType[] getMayNames() throws NamingException {
        if (this.mayNameOids == null || this.mayNameOids.length == 0) {
            return EMPTY_ATTR_ARRAY;
        }
        for (int ii = 0; ii < this.mayNameOids.length; ++ii) {
            this.mayNames[ii] = this.registries.getAttributeTypeRegistry().lookup(this.mayNameOids[ii]);
        }
        return this.mayNames;
    }

    public void setMustNameOids(String[] mustNameOids) {
        if (mustNameOids == null) {
            this.mustNameOids = EMPTY_STR_ARRAY;
            this.mustNames = EMPTY_ATTR_ARRAY;
        } else {
            this.mustNameOids = mustNameOids;
            this.mustNames = new AttributeType[mustNameOids.length];
        }
    }

    public AttributeType[] getMustNames() throws NamingException {
        if (this.mustNameOids == null || this.mustNameOids.length == 0) {
            return EMPTY_ATTR_ARRAY;
        }
        for (int ii = 0; ii < this.mustNameOids.length; ++ii) {
            this.mustNames[ii] = this.registries.getAttributeTypeRegistry().lookup(this.mustNameOids[ii]);
        }
        return this.mustNames;
    }

    public void setNotNameOids(String[] notNameOids) {
        if (notNameOids == null) {
            this.notNameOids = EMPTY_STR_ARRAY;
            this.notNames = EMPTY_ATTR_ARRAY;
        } else {
            this.notNameOids = notNameOids;
            this.notNames = new AttributeType[notNameOids.length];
        }
    }

    public AttributeType[] getNotNames() throws NamingException {
        if (this.notNameOids == null || this.notNameOids.length == 0) {
            return EMPTY_ATTR_ARRAY;
        }
        for (int ii = 0; ii < this.notNameOids.length; ++ii) {
            this.notNames[ii] = this.registries.getAttributeTypeRegistry().lookup(this.notNameOids[ii]);
        }
        return this.notNames;
    }

    public ObjectClass getObjectClass() throws NamingException {
        return this.registries.getObjectClassRegistry().lookup(this.getOid());
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public void setObsolete(boolean obsolete) {
        super.setObsolete(obsolete);
    }

    public void setNames(String[] names) {
        super.setNames(names);
    }

    public void setSchema(String schema) {
        super.setSchema(schema);
    }
}

