/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.ArrayList;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.schema.AbstractSchemaChangeHandler;
import org.apache.directory.server.core.schema.PartitionSchemaLoader;
import org.apache.directory.server.core.schema.SchemaEntityFactory;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.server.schema.registries.SyntaxRegistry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;
import org.apache.directory.shared.ldap.util.Base64;

public class MetaSyntaxCheckerHandler
extends AbstractSchemaChangeHandler {
    private final SchemaEntityFactory factory;
    private final SyntaxCheckerRegistry syntaxCheckerRegistry;
    private final SyntaxRegistry syntaxRegistry;
    private final AttributeType byteCodeAT;
    private final AttributeType descAT;
    private final AttributeType fqcnAT;

    public MetaSyntaxCheckerHandler(Registries targetRegistries, PartitionSchemaLoader loader) throws Exception {
        super(targetRegistries, loader);
        this.syntaxCheckerRegistry = targetRegistries.getSyntaxCheckerRegistry();
        this.syntaxRegistry = targetRegistries.getSyntaxRegistry();
        this.factory = new SchemaEntityFactory(targetRegistries);
        this.byteCodeAT = targetRegistries.getAttributeTypeRegistry().lookup("m-bytecode");
        this.descAT = targetRegistries.getAttributeTypeRegistry().lookup("m-description");
        this.fqcnAT = targetRegistries.getAttributeTypeRegistry().lookup("m-fqcn");
    }

    private SyntaxCheckerDescription getSyntaxCheckerDescription(String schemaName, ServerEntry entry) throws Exception {
        EntryAttribute bytecode;
        SyntaxCheckerDescription description = new SyntaxCheckerDescription();
        description.setNumericOid(this.getOid(entry));
        ArrayList<String> values = new ArrayList<String>();
        values.add(schemaName);
        description.addExtension("X-SCHEMA", values);
        description.setFqcn(entry.get(this.fqcnAT).getString());
        EntryAttribute desc = entry.get(this.descAT);
        if (desc != null && desc.size() > 0) {
            description.setDescription(desc.getString());
        }
        if ((bytecode = entry.get(this.byteCodeAT)) != null && bytecode.size() > 0) {
            byte[] bytes = bytecode.getBytes();
            description.setBytecode(new String(Base64.encode(bytes)));
        }
        return description;
    }

    protected boolean modify(LdapDN name, ServerEntry entry, ServerEntry targetEntry, boolean cascade) throws Exception {
        String oid = this.getOid(entry);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(targetEntry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            this.syntaxCheckerRegistry.unregister(oid);
            SyntaxCheckerDescription syntaxCheckerDescription = this.getSyntaxCheckerDescription(schema.getSchemaName(), targetEntry);
            this.syntaxCheckerRegistry.register(syntaxCheckerDescription, syntaxChecker);
            return true;
        }
        return false;
    }

    public void add(LdapDN name, ServerEntry entry) throws Exception {
        LdapDN parentDn = (LdapDN)name.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkNewParent(parentDn);
        String oid = this.getOid(entry);
        if (this.targetRegistries.getSyntaxCheckerRegistry().hasSyntaxChecker(oid)) {
            throw new LdapNamingException("Oid " + oid + " for new schema syntaxChecker is not unique.", ResultCodeEnum.OTHER);
        }
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(entry, this.targetRegistries);
        Schema schema = this.getSchema(name);
        if (!schema.isDisabled()) {
            SyntaxCheckerDescription syntaxCheckerDescription = this.getSyntaxCheckerDescription(schema.getSchemaName(), entry);
            this.syntaxCheckerRegistry.register(syntaxCheckerDescription, syntaxChecker);
        }
    }

    public void add(SyntaxCheckerDescription syntaxCheckerDescription) throws Exception {
        Schema schema;
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(syntaxCheckerDescription, this.targetRegistries);
        String schemaName = "other";
        if (syntaxCheckerDescription.getExtensions().get("X-SCHEMA") != null) {
            schemaName = syntaxCheckerDescription.getExtensions().get("X-SCHEMA").get(0);
        }
        if (!(schema = this.loader.getSchema(schemaName)).isDisabled()) {
            this.syntaxCheckerRegistry.register(syntaxCheckerDescription, syntaxChecker);
        }
    }

    public void delete(LdapDN name, ServerEntry entry, boolean cascade) throws Exception {
        this.delete(this.getOid(entry), cascade);
    }

    public void delete(String oid, boolean cascade) throws NamingException {
        if (this.syntaxRegistry.hasSyntax(oid)) {
            throw new LdapOperationNotSupportedException("The syntaxChecker with OID " + oid + " cannot be deleted until all " + "syntaxes using this syntaxChecker have also been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        if (this.syntaxCheckerRegistry.hasSyntaxChecker(oid)) {
            this.syntaxCheckerRegistry.unregister(oid);
        }
    }

    public void rename(LdapDN name, ServerEntry entry, Rdn newRdn, boolean cascade) throws Exception {
        String oldOid = this.getOid(entry);
        if (this.syntaxRegistry.hasSyntax(oldOid)) {
            throw new LdapOperationNotSupportedException("The syntaxChecker with OID " + oldOid + " cannot have it's OID changed until all " + "syntaxes using that syntaxChecker have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema schema = this.getSchema(name);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRdn.getValue();
        if (this.targetRegistries.getSyntaxCheckerRegistry().hasSyntaxChecker(newOid)) {
            throw new LdapNamingException("Oid " + newOid + " for new schema syntaxChecker is not unique.", ResultCodeEnum.OTHER);
        }
        targetEntry.put("m-oid", newOid);
        if (!schema.isDisabled()) {
            SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(targetEntry, this.targetRegistries);
            this.syntaxCheckerRegistry.unregister(oldOid);
            SyntaxCheckerDescription syntaxCheckerDescription = this.getSyntaxCheckerDescription(schema.getSchemaName(), entry);
            syntaxCheckerDescription.setNumericOid(newOid);
            this.syntaxCheckerRegistry.register(syntaxCheckerDescription, syntaxChecker);
        }
    }

    public void move(LdapDN oriChildName, LdapDN newParentName, Rdn newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        if (this.syntaxRegistry.hasSyntax(oldOid)) {
            throw new LdapOperationNotSupportedException("The syntaxChecker with OID " + oldOid + " cannot have it's OID changed until all " + "syntaxes using that syntaxChecker have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = (String)newRdn.getValue();
        if (this.targetRegistries.getSyntaxCheckerRegistry().hasSyntaxChecker(newOid)) {
            throw new LdapNamingException("Oid " + newOid + " for new schema syntaxChecker is not unique.", ResultCodeEnum.OTHER);
        }
        targetEntry.put("m-oid", newOid);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(targetEntry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.syntaxCheckerRegistry.unregister(oldOid);
        }
        if (!newSchema.isDisabled()) {
            SyntaxCheckerDescription syntaxCheckerDescription = this.getSyntaxCheckerDescription(newSchema.getSchemaName(), entry);
            syntaxCheckerDescription.setNumericOid(newOid);
            this.syntaxCheckerRegistry.register(syntaxCheckerDescription, syntaxChecker);
        }
    }

    public void replace(LdapDN oriChildName, LdapDN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        if (this.syntaxRegistry.hasSyntax(oid)) {
            throw new LdapOperationNotSupportedException("The syntaxChecker with OID " + oid + " cannot be moved to another schema until all " + "syntax using that syntaxChecker have been deleted.", ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        Schema oldSchema = this.getSchema(oriChildName);
        Schema newSchema = this.getSchema(newParentName);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(entry, this.targetRegistries);
        if (!oldSchema.isDisabled()) {
            this.syntaxCheckerRegistry.unregister(oid);
        }
        if (!newSchema.isDisabled()) {
            SyntaxCheckerDescription syntaxCheckerDescription = this.getSyntaxCheckerDescription(newSchema.getSchemaName(), entry);
            this.syntaxCheckerRegistry.register(syntaxCheckerDescription, syntaxChecker);
        }
    }

    private void checkNewParent(LdapDN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException("The parent dn of a syntaxChecker should be at most 3 name components in length.", ResultCodeEnum.NAMING_VIOLATION);
        }
        Rdn rdn = newParent.getRdn();
        if (!this.targetRegistries.getOidRegistry().getOid(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException("The parent entry of a syntaxChecker should be an organizationalUnit.", ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!((String)rdn.getValue()).equalsIgnoreCase("syntaxCheckers")) {
            throw new LdapInvalidNameException("The parent entry of a normalizer should have a relative name of ou=syntaxCheckers.", ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

