/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema;

import java.util.HashSet;
import java.util.Iterator;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.schema.SchemaOperationControl;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.parsers.ComparatorDescription;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;

public class SchemaService {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private ServerEntry schemaSubentry;
    private final Object lock = new Object();
    private DirectoryService directoryService;
    private Registries registries;
    private JdbmPartition schemaPartition;
    private SchemaOperationControl schemaControl;
    private LdapDN schemaModificationAttributesDN;

    public SchemaService(DirectoryService directoryService, JdbmPartition schemaPartition, SchemaOperationControl schemaControl) throws NamingException {
        this.directoryService = directoryService;
        this.registries = directoryService.getRegistries();
        this.schemaPartition = schemaPartition;
        this.schemaControl = schemaControl;
        this.schemaModificationAttributesDN = new LdapDN("cn=schemaModifications,ou=schema");
        this.schemaModificationAttributesDN.normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
    }

    public boolean isSchemaSubentry(String dnString) throws NamingException {
        if ("cn=schema".equalsIgnoreCase(dnString) || "2.5.4.3=schema".equalsIgnoreCase(dnString)) {
            return true;
        }
        LdapDN dn = new LdapDN(dnString).normalize(this.registries.getAttributeTypeRegistry().getNormalizerMapping());
        return dn.getNormName().equals("2.5.4.3=schema");
    }

    public Registries getRegistries() {
        return this.registries;
    }

    private ServerAttribute generateComparators() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("comparators"));
        Iterator<ComparatorDescription> list = this.registries.getComparatorRegistry().comparatorDescriptionIterator();
        while (list.hasNext()) {
            ComparatorDescription description = list.next();
            attr.add(SchemaUtils.render(description));
        }
        return attr;
    }

    private ServerAttribute generateNormalizers() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("normalizers"));
        Iterator<NormalizerDescription> list = this.registries.getNormalizerRegistry().normalizerDescriptionIterator();
        while (list.hasNext()) {
            NormalizerDescription normalizer = list.next();
            attr.add(SchemaUtils.render(normalizer));
        }
        return attr;
    }

    private ServerAttribute generateSyntaxCheckers() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("syntaxCheckers"));
        Iterator<SyntaxCheckerDescription> list = this.registries.getSyntaxCheckerRegistry().syntaxCheckerDescriptionIterator();
        while (list.hasNext()) {
            SyntaxCheckerDescription syntaxCheckerDescription = list.next();
            attr.add(SchemaUtils.render(syntaxCheckerDescription));
        }
        return attr;
    }

    private ServerAttribute generateObjectClasses() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("objectClasses"));
        for (ObjectClass oc : this.registries.getObjectClassRegistry()) {
            attr.add(SchemaUtils.render(oc).toString());
        }
        return attr;
    }

    private ServerAttribute generateAttributeTypes() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("attributeTypes"));
        for (AttributeType at : this.registries.getAttributeTypeRegistry()) {
            attr.add(SchemaUtils.render(at).toString());
        }
        return attr;
    }

    private ServerAttribute generateMatchingRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("matchingRules"));
        for (MatchingRule mr : this.registries.getMatchingRuleRegistry()) {
            attr.add(SchemaUtils.render(mr).toString());
        }
        return attr;
    }

    private ServerAttribute generateMatchingRuleUses() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("matchingRuleUse"));
        Iterator<MatchingRuleUse> list = this.registries.getMatchingRuleUseRegistry().iterator();
        while (list.hasNext()) {
            MatchingRuleUse mru = list.next();
            attr.add(SchemaUtils.render(mru).toString());
        }
        return attr;
    }

    private ServerAttribute generateSyntaxes() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("ldapSyntaxes"));
        for (Syntax syntax : this.registries.getSyntaxRegistry()) {
            attr.add(SchemaUtils.render(syntax).toString());
        }
        return attr;
    }

    private ServerAttribute generateDitContextRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("ditContentRules"));
        Iterator<DITContentRule> list = this.registries.getDitContentRuleRegistry().iterator();
        while (list.hasNext()) {
            DITContentRule dcr = list.next();
            attr.add(SchemaUtils.render(dcr).toString());
        }
        return attr;
    }

    private ServerAttribute generateDitStructureRules() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("ditStructureRules"));
        Iterator<DITStructureRule> list = this.registries.getDitStructureRuleRegistry().iterator();
        while (list.hasNext()) {
            DITStructureRule dsr = list.next();
            attr.add(SchemaUtils.render(dsr).toString());
        }
        return attr;
    }

    private ServerAttribute generateNameForms() throws NamingException {
        DefaultServerAttribute attr = new DefaultServerAttribute(this.registries.getAttributeTypeRegistry().lookup("nameForms"));
        Iterator<NameForm> list = this.registries.getNameFormRegistry().iterator();
        while (list.hasNext()) {
            NameForm nf = list.next();
            attr.add(SchemaUtils.render(nf).toString());
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSchemaSubentry(ServerEntry mods) throws NamingException {
        DefaultServerEntry attrs = new DefaultServerEntry(this.registries, mods.getDn());
        attrs.put("objectClass", "top", "subschema", "subentry", "apacheSubschema");
        attrs.put("cn", "schema");
        attrs.put(this.generateComparators());
        attrs.put(this.generateNormalizers());
        attrs.put(this.generateSyntaxCheckers());
        attrs.put(this.generateObjectClasses());
        attrs.put(this.generateAttributeTypes());
        attrs.put(this.generateMatchingRules());
        attrs.put(this.generateMatchingRuleUses());
        attrs.put(this.generateSyntaxes());
        attrs.put(this.generateDitContextRules());
        attrs.put(this.generateDitStructureRules());
        attrs.put(this.generateNameForms());
        attrs.put("subtreeSpecification", "{}");
        AttributeType createTimestampAT = this.registries.getAttributeTypeRegistry().lookup("createTimestamp");
        EntryAttribute createTimestamp = mods.get(createTimestampAT);
        attrs.put("createTimestamp", createTimestamp.get());
        attrs.put("creatorsName", "uid=admin,ou=system");
        AttributeType schemaModifyTimestampAT = this.registries.getAttributeTypeRegistry().lookup("schemaModifyTimestamp");
        EntryAttribute schemaModifyTimestamp = mods.get(schemaModifyTimestampAT);
        attrs.put("modifyTimestamp", schemaModifyTimestamp.get());
        AttributeType schemaModifiersNameAT = this.registries.getAttributeTypeRegistry().lookup("schemaModifiersName");
        EntryAttribute schemaModifiersName = mods.get(schemaModifiersNameAT);
        attrs.put("modifiersName", schemaModifiersName.get());
        Object object = this.lock;
        synchronized (object) {
            this.schemaSubentry = attrs;
        }
    }

    private void addAttribute(ServerEntry attrs, String id) throws NamingException {
        EntryAttribute attr = this.schemaSubentry.get(id);
        if (attr != null) {
            attrs.put(attr);
        }
    }

    public ServerEntry getSubschemaEntryImmutable() throws Exception {
        if (this.schemaSubentry == null) {
            this.generateSchemaSubentry(this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN)));
        }
        return (ServerEntry)this.schemaSubentry.clone();
    }

    public ServerEntry getSubschemaEntryCloned() throws Exception {
        if (this.schemaSubentry == null) {
            this.generateSchemaSubentry(this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN)));
        }
        return (ServerEntry)this.schemaSubentry.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerEntry getSubschemaEntry(String[] ids) throws Exception {
        if (ids == null) {
            ids = EMPTY_STRING_ARRAY;
        }
        HashSet<String> setOids = new HashSet<String>();
        DefaultServerEntry attrs = new DefaultServerEntry(this.registries, LdapDN.EMPTY_LDAPDN);
        boolean returnAllOperationalAttributes = false;
        Object object = this.lock;
        synchronized (object) {
            ClonedServerEntry mods = this.schemaPartition.lookup(new LookupOperationContext(null, this.schemaModificationAttributesDN));
            this.generateSchemaSubentry(mods);
            for (String id : ids) {
                if ("+".equals(id)) {
                    returnAllOperationalAttributes = true;
                    continue;
                }
                if ("*".equals(id)) {
                    setOids.add(id);
                    continue;
                }
                setOids.add(this.registries.getOidRegistry().getOid(id));
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.32")) {
                this.addAttribute(attrs, "comparators");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.33")) {
                this.addAttribute(attrs, "normalizers");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.18060.0.4.1.2.34")) {
                this.addAttribute(attrs, "syntaxCheckers");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.6")) {
                this.addAttribute(attrs, "objectClasses");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.5")) {
                this.addAttribute(attrs, "attributeTypes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.4")) {
                this.addAttribute(attrs, "matchingRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.8")) {
                this.addAttribute(attrs, "matchingRuleUse");
            }
            if (returnAllOperationalAttributes || setOids.contains("1.3.6.1.4.1.1466.101.120.16")) {
                this.addAttribute(attrs, "ldapSyntaxes");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.2")) {
                this.addAttribute(attrs, "ditContentRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.1")) {
                this.addAttribute(attrs, "ditStructureRules");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.21.7")) {
                this.addAttribute(attrs, "nameForms");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.6")) {
                this.addAttribute(attrs, "subtreeSpecification");
            }
            int minSetSize = 0;
            if (setOids.contains("+")) {
                ++minSetSize;
            }
            if (setOids.contains("*")) {
                ++minSetSize;
            }
            if (setOids.contains("2.16.840.1.113730.3.1.34")) {
                ++minSetSize;
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.0") || setOids.size() == minSetSize) {
                this.addAttribute(attrs, "objectClass");
            }
            if (setOids.contains("*") || setOids.contains("2.5.4.3") || setOids.size() == minSetSize) {
                this.addAttribute(attrs, "cn");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.1")) {
                this.addAttribute(attrs, "createTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.3")) {
                this.addAttribute(attrs, "creatorsName");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.2")) {
                this.addAttribute(attrs, "modifyTimestamp");
            }
            if (returnAllOperationalAttributes || setOids.contains("2.5.18.4")) {
                this.addAttribute(attrs, "modifiersName");
            }
        }
        return attrs;
    }

    SchemaOperationControl getSchemaControl() {
        return this.schemaControl;
    }
}

