/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.trigger.StoredProcedureParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStoredProcedureParameterInjector
implements StoredProcedureParameterInjector {
    private OperationContext opContext;
    private Map<Class<?>, StoredProcedureParameterInjector.MicroInjector> injectors;
    StoredProcedureParameterInjector.MicroInjector $operationPrincipalInjector = new StoredProcedureParameterInjector.MicroInjector(){

        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws Exception {
            return AbstractStoredProcedureParameterInjector.this.getOperationPrincipal();
        }
    };
    StoredProcedureParameterInjector.MicroInjector $ldapContextInjector = new StoredProcedureParameterInjector.MicroInjector(){

        public Object inject(OperationContext opContext, StoredProcedureParameter param) throws Exception {
            StoredProcedureParameter.Generic_LDAP_CONTEXT ldapCtxParam = (StoredProcedureParameter.Generic_LDAP_CONTEXT)param;
            LdapDN ldapCtxName = ldapCtxParam.getCtxName();
            return opContext.lookup(ldapCtxName, ByPassConstants.LOOKUP_BYPASS);
        }
    };

    public AbstractStoredProcedureParameterInjector(OperationContext opContext) {
        this.opContext = opContext;
        this.injectors = new HashMap();
        this.injectors.put(StoredProcedureParameter.Generic_OPERATION_PRINCIPAL.class, this.$operationPrincipalInjector);
        this.injectors.put(StoredProcedureParameter.Generic_LDAP_CONTEXT.class, this.$ldapContextInjector);
    }

    protected Name getOperationPrincipal() throws NamingException {
        LdapPrincipal principal = this.opContext.getSession().getEffectivePrincipal();
        LdapDN userName = new LdapDN(principal.getName());
        return userName;
    }

    protected Map<Class<?>, StoredProcedureParameterInjector.MicroInjector> getInjectors() {
        return this.injectors;
    }

    public OperationContext getOperationContext() {
        return this.opContext;
    }

    public void setOperationContext(OperationContext invocation) {
        this.opContext = invocation;
    }

    @Override
    public final List<Object> getArgumentsToInject(OperationContext opContext, List<StoredProcedureParameter> parameterList) throws Exception {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (StoredProcedureParameter spParameter : parameterList) {
            StoredProcedureParameterInjector.MicroInjector injector = this.injectors.get(spParameter.getClass());
            arguments.add(injector.inject(opContext, spParameter));
        }
        return arguments;
    }
}

