/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.store;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.kerberos.shared.store.PrincipalStore;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.directory.server.kerberos.shared.store.operations.ChangePassword;
import org.apache.directory.server.kerberos.shared.store.operations.GetPrincipal;
import org.apache.directory.server.protocol.shared.ServiceConfigurationException;
import org.apache.directory.shared.ldap.name.LdapDN;

class SingleBaseSearch
implements PrincipalStore {
    private final CoreSession session;
    private final LdapDN searchBaseDn;

    SingleBaseSearch(DirectoryService directoryService, LdapDN searchBaseDn) {
        try {
            this.session = directoryService.getAdminSession();
            this.searchBaseDn = searchBaseDn;
        }
        catch (Exception e) {
            throw new ServiceConfigurationException("Can't get a session", e);
        }
    }

    public PrincipalStoreEntry getPrincipal(KerberosPrincipal principal) throws Exception {
        return (PrincipalStoreEntry)new GetPrincipal(principal).execute(this.session, this.searchBaseDn);
    }

    public String changePassword(KerberosPrincipal principal, String newPassword) throws Exception {
        return (String)new ChangePassword(principal, newPassword).execute(this.session, this.searchBaseDn);
    }
}

