/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.extended;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.shared.ldap.message.InternalExtendedRequest;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.extended.GracefulDisconnect;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownRequest;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownResponse;
import org.apache.directory.shared.ldap.message.extended.NoticeOfDisconnect;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GracefulShutdownHandler
implements ExtendedOperationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownHandler.class);
    public static final Set<String> EXTENSION_OIDS;

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.18060.0.1.3";
    }

    @Override
    public void handleExtendedOperation(LdapSession requestor, InternalExtendedRequest req) throws Exception {
        if (!requestor.getCoreSession().isAnAdministrator()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Rejected with insufficientAccessRights to attempt for server shutdown by " + requestor.getCoreSession().getEffectivePrincipal().getName());
            }
            requestor.getIoSession().write(new GracefulShutdownResponse(req.getMessageId(), ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS));
            return;
        }
        IoAcceptor acceptor = (IoAcceptor)requestor.getIoSession().getService();
        ArrayList<IoSession> sessions = new ArrayList<IoSession>(acceptor.getManagedSessions().values());
        GracefulShutdownRequest gsreq = (GracefulShutdownRequest)req;
        GracefulDisconnect notice = GracefulShutdownHandler.getGracefulDisconnect(gsreq.getTimeOffline(), gsreq.getDelay());
        GracefulShutdownHandler.sendGracefulDisconnect(sessions, notice, requestor.getIoSession());
        GracefulShutdownHandler.waitForDelay(gsreq.getDelay());
        acceptor.unbind(requestor.getIoSession().getServiceAddress());
        GracefulShutdownHandler.sendNoticeOfDisconnect(sessions, requestor.getIoSession());
        GracefulShutdownHandler.sendShutdownResponse(requestor.getIoSession(), req.getMessageId());
    }

    public static void sendShutdownResponse(IoSession requestor, int messageId) {
        GracefulShutdownResponse msg = new GracefulShutdownResponse(messageId, ResultCodeEnum.SUCCESS);
        WriteFuture future = requestor.write(msg);
        future.awaitUninterruptibly();
        if (future.isWritten()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Sent GracefulShutdownResponse to client: " + requestor.getRemoteAddress());
            }
        } else {
            LOG.error("Failed to write GracefulShutdownResponse to client: " + requestor.getRemoteAddress());
        }
        requestor.close(true);
    }

    public static void sendGracefulDisconnect(List<IoSession> sessions, GracefulDisconnect msg, IoSession requestor) {
        ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
        if (sessions != null) {
            for (IoSession session : sessions) {
                if (session.equals(requestor)) continue;
                try {
                    writeFutures.add(session.write(msg));
                }
                catch (Exception e) {
                    LOG.warn("Failed to write GracefulDisconnect to client session: " + session, e);
                }
            }
        }
        for (WriteFuture future : writeFutures) {
            try {
                future.awaitUninterruptibly(1000L);
            }
            catch (Exception e) {
                LOG.warn("Failed to sent GracefulDisconnect", e);
            }
        }
    }

    public static void sendNoticeOfDisconnect(List<IoSession> sessions, IoSession requestor) {
        ArrayList<WriteFuture> writeFutures = new ArrayList<WriteFuture>();
        if (sessions != null) {
            for (IoSession session : sessions) {
                if (session.equals(requestor)) continue;
                try {
                    writeFutures.add(session.write(NoticeOfDisconnect.UNAVAILABLE));
                }
                catch (Exception e) {
                    LOG.warn("Failed to sent NoD for client: " + session, e);
                }
            }
        }
        Iterator<IoSession> sessionIt = sessions.iterator();
        for (WriteFuture future : writeFutures) {
            try {
                future.awaitUninterruptibly(1000L);
                sessionIt.next().close(true);
            }
            catch (Exception e) {
                LOG.warn("Failed to sent NoD.", e);
            }
        }
    }

    public static GracefulDisconnect getGracefulDisconnect(int timeOffline, int delay) {
        return new GracefulDisconnect(timeOffline, delay);
    }

    public static void waitForDelay(int delay) {
        if (delay > 0) {
            long delayMillis = (long)delay * 1000L;
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < delayMillis) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Got interrupted while waiting for delay before shutdown", e);
                }
            }
        }
    }

    @Override
    public Set<String> getExtensionOids() {
        return EXTENSION_OIDS;
    }

    @Override
    public void setLdapServer(LdapServer ldapServer) {
    }

    static {
        HashSet<String> set = new HashSet<String>(3);
        set.add("1.3.6.1.4.1.18060.0.1.3");
        set.add("1.3.6.1.4.1.18060.0.1.4");
        set.add("1.3.6.1.4.1.18060.0.1.5");
        EXTENSION_OIDS = Collections.unmodifiableSet(set);
    }
}

