/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import java.io.UnsupportedEncodingException;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.name.NameComponentNormalizer;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.normalizers.NoOpNormalizer;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcreteNameComponentNormalizer
implements NameComponentNormalizer {
    private static Logger LOG = LoggerFactory.getLogger(ConcreteNameComponentNormalizer.class);
    private final AttributeTypeRegistry attributeRegistry;
    private final OidRegistry oidRegistry;

    public ConcreteNameComponentNormalizer(AttributeTypeRegistry registry, OidRegistry oidRegistry) {
        this.attributeRegistry = registry;
        this.oidRegistry = oidRegistry;
    }

    private String unescape(String value) {
        char[] newVal = new char[value.length()];
        int escaped = 0;
        char high = '\u0000';
        char low = '\u0000';
        int pos = 0;
        block5: for (char c : value.toCharArray()) {
            switch (escaped) {
                case 0: {
                    if (c == '\\') {
                        escaped = 1;
                        continue block5;
                    }
                    newVal[pos++] = c;
                    continue block5;
                }
                case 1: {
                    ++escaped;
                    high = c;
                    continue block5;
                }
                case 2: {
                    escaped = 0;
                    low = c;
                    newVal[pos++] = (char)StringTools.getHexValue(high, low);
                }
            }
        }
        return new String(newVal, 0, pos);
    }

    public Object normalizeByName(String name, String value) throws NamingException {
        AttributeType attributeType = this.attributeRegistry.lookup(name);
        if (attributeType.getSyntax().isHumanReadable()) {
            return this.lookup(name).normalize(value);
        }
        try {
            String unescaped = this.unescape(value);
            byte[] valBytes = unescaped.getBytes("UTF-8");
            return this.lookup(name).normalize(new ClientBinaryValue(valBytes));
        }
        catch (UnsupportedEncodingException uee) {
            String message = "The value stored in a non Human Readable attribute as a String should be convertible to a byte[]";
            LOG.error(message);
            throw new NamingException(message);
        }
    }

    public Object normalizeByName(String name, byte[] value) throws NamingException {
        AttributeType attributeType = this.attributeRegistry.lookup(name);
        if (!attributeType.getSyntax().isHumanReadable()) {
            return this.lookup(name).normalize(new ClientBinaryValue(value));
        }
        try {
            String valStr = new String(value, "UTF-8");
            return this.lookup(name).normalize(valStr);
        }
        catch (UnsupportedEncodingException uee) {
            String message = "The value stored in an Human Readable attribute as a byte[] should be convertible to a String";
            LOG.error(message);
            throw new NamingException(message);
        }
    }

    public Object normalizeByOid(String oid, String value) throws NamingException {
        return this.lookup(oid).normalize(value);
    }

    public Object normalizeByOid(String oid, byte[] value) throws NamingException {
        return this.lookup(oid).normalize(new ClientBinaryValue(value));
    }

    private Normalizer lookup(String id) throws NamingException {
        AttributeType type = this.attributeRegistry.lookup(id);
        MatchingRule mrule = type.getEquality();
        if (mrule == null) {
            return NoOpNormalizer.INSTANCE;
        }
        return type.getEquality().getNormalizer();
    }

    public boolean isDefined(String id) {
        return this.attributeRegistry.hasAttributeType(id);
    }

    public String normalizeName(String attributeName) throws NamingException {
        return this.oidRegistry.getOid(attributeName);
    }
}

