/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.server.schema.bootstrap.ApachemetaSyntaxProducer;
import org.apache.directory.server.schema.bootstrap.NameOrNumericIdComparator;
import org.apache.directory.server.schema.bootstrap.NameOrNumericIdNormalizer;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.Syntax;

public class NameOrNumericIdMatch
implements MatchingRule {
    private static final long serialVersionUID = 1L;
    private static final String[] NAMES = new String[]{"nameOrNumericIdMatch"};
    private static final String OID = "1.3.6.1.4.1.18060.0.4.0.1.0";
    private transient Normalizer normalizer;
    private transient Comparator comparator;
    private transient Syntax syntax;
    private final String schema;

    public NameOrNumericIdMatch(String schema) {
        this.syntax = new ApachemetaSyntaxProducer.NameOrNumericIdSyntax();
        this.schema = schema;
    }

    public NameOrNumericIdMatch(OidRegistry registry, String schema) {
        this.normalizer = new NameOrNumericIdNormalizer(registry);
        this.comparator = new NameOrNumericIdComparator(registry);
        this.syntax = new ApachemetaSyntaxProducer.NameOrNumericIdSyntax();
        this.schema = schema;
    }

    public void setRegistries(Registries registries) {
        this.normalizer = new NameOrNumericIdNormalizer(registries.getOidRegistry());
        this.comparator = new NameOrNumericIdComparator(registries.getOidRegistry());
        this.syntax = new ApachemetaSyntaxProducer.NameOrNumericIdSyntax();
    }

    public Comparator getComparator() throws NamingException {
        return this.comparator;
    }

    public Normalizer getNormalizer() throws NamingException {
        return this.normalizer;
    }

    public Syntax getSyntax() throws NamingException {
        return this.syntax;
    }

    public String getDescription() {
        return "A name or numeric id matchingRule";
    }

    public String getName() {
        return NAMES[0];
    }

    public String[] getNamesRef() {
        return NAMES;
    }

    public String getOid() {
        return OID;
    }

    public boolean isObsolete() {
        return false;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schemaName) {
        throw new NotImplementedException();
    }
}

