/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.naming.directory.NoSuchAttributeException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.normalizers.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.normalizers.OidNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAttributeTypeRegistry
implements AttributeTypeRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAttributeTypeRegistry.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private final Map<String, AttributeType> byOidAT = new ConcurrentHashMap<String, AttributeType>();
    private final Map<String, Set<AttributeType>> oidToDescendantSet = new ConcurrentHashMap<String, Set<AttributeType>>();
    private final OidRegistry oidRegistry;
    private transient Map<String, OidNormalizer> oidNormalizerMap = new ConcurrentHashMap<String, OidNormalizer>();

    public DefaultAttributeTypeRegistry(OidRegistry oidRegistry) {
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(AttributeType attributeType) throws NamingException {
        if (this.byOidAT.containsKey(attributeType.getOid())) {
            String msg = "attributeType " + attributeType.getName() + " w/ OID " + attributeType.getOid() + " has already been registered!";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        String[] names = attributeType.getNamesRef();
        String oid = attributeType.getOid();
        for (String name : names) {
            this.oidRegistry.register(name, oid);
        }
        this.oidRegistry.register(oid, oid);
        this.addMappingFor(attributeType);
        this.registerDescendants(attributeType);
        this.byOidAT.put(attributeType.getOid(), attributeType);
        if (IS_DEBUG) {
            LOG.debug("registred attributeType: {}", attributeType);
        }
    }

    public void registerDescendants(AttributeType attributeType) throws NamingException {
        this.onRegisterAddToAncestorDescendants(attributeType, attributeType.getSuperior());
    }

    protected void onRegisterAddToAncestorDescendants(AttributeType newType, AttributeType ancestor) throws NamingException {
        if (ancestor == null) {
            return;
        }
        Set<AttributeType> descendants = this.oidToDescendantSet.get(ancestor.getOid());
        if (descendants == null) {
            descendants = new HashSet<AttributeType>(1);
            this.oidToDescendantSet.put(ancestor.getOid(), descendants);
        }
        descendants.add(newType);
        this.onRegisterAddToAncestorDescendants(newType, ancestor.getSuperior());
    }

    @Override
    public AttributeType lookup(String id) throws NamingException {
        String oid = this.oidRegistry.getOid(id);
        AttributeType attributeType = this.byOidAT.get(oid);
        if (attributeType == null) {
            String msg = "attributeType w/ OID " + oid + " not registered!";
            LOG.error(msg);
            throw new NoSuchAttributeException(msg);
        }
        if (IS_DEBUG) {
            LOG.debug("lookup with id '{}' for attributeType: {}", (Object)oid, (Object)attributeType);
        }
        return attributeType;
    }

    @Override
    public boolean hasAttributeType(String id) {
        try {
            String oid = this.oidRegistry.getOid(id);
            if (oid != null) {
                return this.byOidAT.containsKey(oid);
            }
            return false;
        }
        catch (NamingException e) {
            return false;
        }
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        AttributeType at = this.byOidAT.get(this.oidRegistry.getOid(id));
        if (at != null) {
            return at.getSchema();
        }
        String msg = "OID " + id + " not found in oid to " + "AttributeType map!";
        LOG.debug(msg);
        throw new NamingException(msg);
    }

    private void removeMappingFor(AttributeType type) throws NamingException {
        String[] aliases;
        if (type == null) {
            return;
        }
        this.oidNormalizerMap.remove(type.getOid());
        for (String aliase : aliases = type.getNamesRef()) {
            this.oidNormalizerMap.remove(aliase);
            this.oidNormalizerMap.remove(aliase.toLowerCase());
        }
    }

    private void addMappingFor(AttributeType type) throws NamingException {
        String[] aliases;
        OidNormalizer oidNormalizer;
        MatchingRule matchingRule = type.getEquality();
        String oid = type.getOid();
        if (matchingRule == null) {
            LOG.debug("Attribute {} does not have normalizer : using NoopNormalizer", (Object)type.getName());
            oidNormalizer = new OidNormalizer(oid, new NoOpNormalizer());
        } else {
            oidNormalizer = new OidNormalizer(oid, matchingRule.getNormalizer());
        }
        this.oidNormalizerMap.put(oid, oidNormalizer);
        for (String aliase : aliases = type.getNamesRef()) {
            this.oidNormalizerMap.put(aliase, oidNormalizer);
            this.oidNormalizerMap.put(aliase.toLowerCase(), oidNormalizer);
        }
    }

    @Override
    public Map<String, OidNormalizer> getNormalizerMapping() throws NamingException {
        return Collections.unmodifiableMap(this.oidNormalizerMap);
    }

    @Override
    public Iterator<AttributeType> descendants(String ancestorId) throws NamingException {
        String oid = this.oidRegistry.getOid(ancestorId);
        Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
        if (descendants == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return descendants.iterator();
    }

    @Override
    public boolean hasDescendants(String ancestorId) throws NamingException {
        String oid = this.oidRegistry.getOid(ancestorId);
        Set<AttributeType> descendants = this.oidToDescendantSet.get(oid);
        return descendants != null && !descendants.isEmpty();
    }

    @Override
    public Iterator<AttributeType> iterator() {
        return this.byOidAT.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!OID.isOID(numericOid)) {
            String msg = "Looks like the arg " + numericOid + " is not a numeric OID";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        this.removeMappingFor(this.byOidAT.get(numericOid));
        this.byOidAT.remove(numericOid);
        this.oidToDescendantSet.remove(numericOid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String value : this.byOidAT.keySet()) {
            sb.append(value).append(":").append(this.byOidAT.get(value)).append('\n');
        }
        return sb.toString();
    }
}

