/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.DITStructureRuleRegistry;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDitStructureRuleRegistry
implements DITStructureRuleRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDitStructureRuleRegistry.class);
    private final Map<String, DITStructureRule> byOid;
    private final Map<Integer, DITStructureRule> byRuleId = new HashMap<Integer, DITStructureRule>();
    private final OidRegistry oidRegistry;

    public DefaultDitStructureRuleRegistry(OidRegistry oidRegistry) {
        this.byOid = new HashMap<String, DITStructureRule>();
        this.oidRegistry = oidRegistry;
    }

    @Override
    public void register(DITStructureRule dITStructureRule) throws NamingException {
        if (this.byOid.containsKey(dITStructureRule.getOid())) {
            throw new NamingException("dITStructureRule w/ OID " + dITStructureRule.getOid() + " has already been registered!");
        }
        this.oidRegistry.register(dITStructureRule.getName(), dITStructureRule.getOid());
        this.byOid.put(dITStructureRule.getOid(), dITStructureRule);
        this.byRuleId.put(dITStructureRule.getRuleId(), dITStructureRule);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registered dITStructureRule: " + dITStructureRule);
        }
    }

    @Override
    public DITStructureRule lookup(String id) throws NamingException {
        if (!this.byOid.containsKey(id = this.oidRegistry.getOid(id))) {
            throw new NamingException("dITStructureRule w/ OID " + id + " not registered!");
        }
        DITStructureRule dITStructureRule = this.byOid.get(id);
        if (LOG.isDebugEnabled()) {
            LOG.debug("lookup with id '" + id + "' for dITStructureRule: " + dITStructureRule);
        }
        return dITStructureRule;
    }

    @Override
    public boolean hasDITStructureRule(String id) {
        if (this.oidRegistry.hasOid(id)) {
            try {
                return this.byOid.containsKey(this.oidRegistry.getOid(id));
            }
            catch (NamingException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public String getSchemaName(String id) throws NamingException {
        DITStructureRule dsr = this.byOid.get(id = this.oidRegistry.getOid(id));
        if (dsr != null) {
            return dsr.getSchema();
        }
        throw new NamingException("OID " + id + " not found in oid to " + "DITStructureRule map!");
    }

    @Override
    public String getSchemaName(Integer ruleId) throws NamingException {
        DITStructureRule dsr = this.byRuleId.get(ruleId);
        if (dsr != null) {
            return dsr.getSchema();
        }
        throw new NamingException("A DitStructureRule with ruleId " + ruleId + " not found in the DITStructureRule map!");
    }

    @Override
    public Iterator<DITStructureRule> iterator() {
        return this.byOid.values().iterator();
    }

    @Override
    public void unregister(Integer ruleId) throws NamingException {
        DITStructureRule dsr = this.byRuleId.remove(ruleId);
        if (dsr == null && dsr == null) {
            throw new LdapNamingException("No such DITStructureRule for rule identifier: " + ruleId, ResultCodeEnum.OTHER);
        }
        this.byOid.remove(dsr.getOid());
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!Character.isDigit(numericOid.charAt(0))) {
            throw new NamingException("Looks like the arg is not a numeric OID");
        }
        DITStructureRule dsr = this.byOid.remove(numericOid);
        this.byRuleId.remove(dsr.getRuleId());
    }

    @Override
    public boolean hasDITStructureRule(Integer ruleId) {
        DITStructureRule dsr = this.byRuleId.get(ruleId);
        return dsr != null;
    }

    @Override
    public DITStructureRule lookup(Integer ruleId) throws NamingException {
        DITStructureRule dsr = this.byRuleId.get(ruleId);
        if (dsr == null) {
            throw new LdapNamingException("No such DITStructureRule for rule identifier: " + ruleId, ResultCodeEnum.OTHER);
        }
        return dsr;
    }
}

