/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.utils;

import java.util.Comparator;
import javax.naming.NamingException;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.DITContentRule;
import org.apache.directory.shared.ldap.schema.DITStructureRule;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.MatchingRuleUse;
import org.apache.directory.shared.ldap.schema.NameForm;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.SchemaObject;
import org.apache.directory.shared.ldap.schema.Syntax;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.util.DateUtils;

public class AttributesFactory {
    public ServerEntry getAttributes(SchemaObject obj, Schema schema, Registries registries) throws NamingException {
        if (obj instanceof Syntax) {
            return this.getAttributes((Syntax)obj, schema, registries);
        }
        if (obj instanceof MatchingRule) {
            return this.getAttributes((MatchingRule)obj, schema, registries);
        }
        if (obj instanceof AttributeType) {
            return this.getAttributes((AttributeType)obj, schema, registries);
        }
        if (obj instanceof ObjectClass) {
            return this.getAttributes((ObjectClass)obj, schema, registries);
        }
        if (obj instanceof MatchingRuleUse) {
            return this.getAttributes((MatchingRuleUse)obj, schema, registries);
        }
        if (obj instanceof DITStructureRule) {
            return this.getAttributes((DITStructureRule)obj, schema, registries);
        }
        if (obj instanceof DITContentRule) {
            return this.getAttributes((DITContentRule)obj, schema, registries);
        }
        if (obj instanceof NameForm) {
            return this.getAttributes((NameForm)obj, schema, registries);
        }
        throw new IllegalArgumentException("Unknown SchemaObject type: " + obj.getClass());
    }

    public ServerEntry getAttributes(Schema schema, Registries registries) throws NamingException {
        String[] dependencies;
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "metaSchema");
        entry.put("cn", schema.getSchemaName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        if (schema.isDisabled()) {
            entry.put("m-disabled", "TRUE");
        }
        if ((dependencies = schema.getDependencies()) != null && dependencies.length > 0) {
            DefaultServerAttribute attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-dependencies"));
            for (String dependency : dependencies) {
                attr.add(dependency);
            }
            entry.put(attr);
        }
        return entry;
    }

    public ServerEntry getAttributes(SyntaxChecker syntaxChecker, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "metaSyntaxChecker");
        entry.put("m-oid", syntaxChecker.getSyntaxOid());
        entry.put("m-fqcn", syntaxChecker.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public ServerEntry getAttributes(Syntax syntax, Schema schema, Registries registries) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "metaSyntax");
        entry.put("x-humanReadable", this.getBoolean(syntax.isHumanReadable()));
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(syntax, entry, registries);
        return entry;
    }

    public ServerEntry getAttributes(String oid, Normalizer normalizer, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "metaNormalizer");
        entry.put("m-oid", oid);
        entry.put("m-fqcn", normalizer.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public ServerEntry getAttributes(String oid, Comparator comparator, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "metaComparator");
        entry.put("m-oid", oid);
        entry.put("m-fqcn", comparator.getClass().getName());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public ServerEntry getAttributes(MatchingRule matchingRule, Schema schema, Registries registries) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "metaMatchingRule");
        entry.put("m-syntax", matchingRule.getSyntax().getOid());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(matchingRule, entry, registries);
        return entry;
    }

    public ServerEntry getAttributes(MatchingRuleUse matchingRuleUse, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public ServerEntry getAttributes(DITStructureRule dITStructureRule, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public ServerEntry getAttributes(DITContentRule dITContentRule, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public ServerEntry getAttributes(NameForm nameForm, Schema schema, Registries registries) {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "");
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        return entry;
    }

    public ServerEntry getAttributes(AttributeType attributeType, Schema schema, Registries registries) throws NamingException {
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "metaAttributeType");
        entry.put("m-syntax", attributeType.getSyntax().getOid());
        entry.put("m-collective", this.getBoolean(attributeType.isCollective()));
        entry.put("m-noUserModification", this.getBoolean(!attributeType.isCanUserModify()));
        entry.put("m-singleValue", this.getBoolean(attributeType.isSingleValue()));
        entry.put("m-usage", attributeType.getUsage().toString());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(attributeType, entry, registries);
        AttributeType superior = attributeType.getSuperior();
        if (superior != null) {
            String sup = superior.getName();
            if (sup == null) {
                sup = superior.getOid();
            }
            entry.put("m-supAttributeType", sup);
        }
        if (attributeType.getEquality() != null) {
            String equality = attributeType.getEquality().getName();
            if (equality == null) {
                equality = attributeType.getEquality().getOid();
            }
            entry.put("m-equality", equality);
        }
        if (attributeType.getSubstr() != null) {
            String substr = attributeType.getSubstr().getName();
            if (substr == null) {
                substr = attributeType.getSubstr().getOid();
            }
            entry.put("m-substr", substr);
        }
        if (attributeType.getOrdering() != null) {
            String ordering = attributeType.getOrdering().getName();
            if (ordering == null) {
                ordering = attributeType.getOrdering().getOid();
            }
            entry.put("m-ordering", ordering);
        }
        return entry;
    }

    public ServerEntry getAttributes(ObjectClass objectClass, Schema schema, Registries registries) throws NamingException {
        DefaultServerAttribute attr;
        DefaultServerEntry entry = new DefaultServerEntry(registries);
        entry.put("objectClass", "top", "metaObjectClass");
        entry.put("m-typeObjectClass", objectClass.getType().toString());
        entry.put("creatorsName", schema.getOwner());
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        this.injectCommon(objectClass, entry, registries);
        if (objectClass.getSuperClasses() != null && objectClass.getSuperClasses().length != 0) {
            attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-supObjectClass"));
            ObjectClass[] superClasses = objectClass.getSuperClasses();
            for (SchemaObject schemaObject : superClasses) {
                attr.add(this.getNameOrNumericoid(schemaObject));
            }
            entry.put(attr);
        }
        if (objectClass.getMustList() != null && objectClass.getMustList().length != 0) {
            attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-must"));
            AttributeType[] mustList = objectClass.getMustList();
            for (SchemaObject schemaObject : mustList) {
                attr.add(this.getNameOrNumericoid(schemaObject));
            }
            entry.put(attr);
        }
        if (objectClass.getMayList() != null && objectClass.getMayList().length != 0) {
            attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-may"));
            AttributeType[] mayList = objectClass.getMayList();
            for (SchemaObject schemaObject : mayList) {
                attr.add(this.getNameOrNumericoid(schemaObject));
            }
            entry.put(attr);
        }
        return entry;
    }

    private final String getNameOrNumericoid(SchemaObject object) {
        if (object.getName() != null) {
            return object.getName();
        }
        return object.getOid();
    }

    private final void injectCommon(SchemaObject object, ServerEntry entry, Registries registries) throws NamingException {
        this.injectNames(object.getNamesRef(), entry, registries);
        entry.put("m-obsolete", this.getBoolean(object.isObsolete()));
        entry.put("m-oid", object.getOid());
        if (object.getDescription() != null) {
            entry.put("m-description", object.getDescription());
        }
    }

    private final void injectNames(String[] names, ServerEntry entry, Registries registries) throws NamingException {
        if (names == null || names.length == 0) {
            return;
        }
        DefaultServerAttribute attr = new DefaultServerAttribute(registries.getAttributeTypeRegistry().lookup("m-name"));
        for (String name : names) {
            attr.add(name);
        }
        entry.put(attr);
    }

    private final String getBoolean(boolean value) {
        if (value) {
            return "TRUE";
        }
        return "FALSE";
    }
}

