/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.ldap.Control;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifControl;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.LdapDnParser;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifReader
implements Iterable<LdifEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(LdifReader.class);
    protected List<String> lines;
    protected Position position;
    protected static final int DEFAULT_VERSION = 1;
    protected int version;
    protected static final int LDIF_ENTRY = 0;
    protected static final int CHANGE = 1;
    protected static final int UNKNOWN = 2;
    protected long sizeLimit = 1024000L;
    protected static final long SIZE_LIMIT_DEFAULT = 1024000L;
    protected static final int MOD_SPEC = 0;
    protected static final int ATTRVAL_SPEC = 1;
    protected static final int ATTRVAL_SPEC_OR_SEP = 2;
    protected LdifEntry prefetched;
    protected Reader in;
    protected boolean containsEntries;
    protected boolean containsChanges;
    protected Exception error;

    public LdifReader() {
        this.lines = new ArrayList<String>();
        this.position = new Position();
        this.version = 1;
    }

    private void init(BufferedReader inf) throws NamingException {
        this.in = inf;
        this.lines = new ArrayList<String>();
        this.position = new Position();
        this.version = 1;
        this.containsChanges = false;
        this.containsEntries = false;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
    }

    public LdifReader(String ldifFileName) throws NamingException {
        File inf = new File(ldifFileName);
        if (!inf.exists()) {
            LOG.error("File {} cannot be found", inf.getAbsoluteFile());
            throw new NamingException("Cannot find file " + inf.getAbsoluteFile());
        }
        if (!inf.canRead()) {
            LOG.error("File {} cannot be read", (Object)inf.getName());
            throw new NamingException("Cannot read file " + inf.getName());
        }
        try {
            this.init(new BufferedReader(new FileReader(inf)));
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("File {} cannot be found", inf.getAbsoluteFile());
            throw new NamingException("Cannot find file " + inf.getAbsoluteFile());
        }
    }

    public LdifReader(BufferedReader in) throws NamingException {
        this.init(in);
    }

    public LdifReader(Reader in) throws NamingException {
        this.init(new BufferedReader(in));
    }

    public LdifReader(InputStream in) throws NamingException {
        this.init(new BufferedReader(new InputStreamReader(in)));
    }

    public LdifReader(File in) throws NamingException {
        if (!in.exists()) {
            LOG.error("File {} cannot be found", in.getAbsoluteFile());
            throw new NamingException("Cannot find file " + in.getAbsoluteFile());
        }
        if (!in.canRead()) {
            LOG.error("File {} cannot be read", (Object)in.getName());
            throw new NamingException("Cannot read file " + in.getName());
        }
        try {
            this.init(new BufferedReader(new FileReader(in)));
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("File {} cannot be found", in.getAbsoluteFile());
            throw new NamingException("Cannot find file " + in.getAbsoluteFile());
        }
    }

    public int getVersion() {
        return this.version;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    private static void parseFill(char[] document, Position position) {
        while (StringTools.isCharASCII(document, position.pos, ' ')) {
            position.inc();
        }
    }

    private static String parseNumber(char[] document, Position position) {
        int initPos = position.pos;
        while (StringTools.isDigit(document, position.pos)) {
            position.inc();
        }
        if (position.pos == initPos) {
            return null;
        }
        return new String(document, initPos, position.pos - initPos);
    }

    private ChangeType parseChangeType(String line) {
        ChangeType operation = ChangeType.Add;
        String modOp = StringTools.trim(line.substring("changetype:".length() + 1));
        if ("add".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Add;
        } else if ("delete".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Delete;
        } else if ("modify".equalsIgnoreCase(modOp)) {
            operation = ChangeType.Modify;
        } else if ("moddn".equalsIgnoreCase(modOp)) {
            operation = ChangeType.ModDn;
        } else if ("modrdn".equalsIgnoreCase(modOp)) {
            operation = ChangeType.ModRdn;
        }
        return operation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseDn(String line) throws NamingException {
        String dn = null;
        String lowerLine = line.toLowerCase();
        if (!lowerLine.startsWith("dn:") && !lowerLine.startsWith("DN:")) {
            LOG.error("A ldif entry must start with a DN");
            throw new NamingException("No DN for entry");
        }
        int length = line.length();
        if (length == 3) {
            LOG.error("A ldif entry must have a non empty DN");
            throw new NamingException("No DN for entry");
        }
        if (line.charAt(3) == ':') {
            if (length <= 4) {
                LOG.error("A ldif entry must have a non empty DN");
                throw new NamingException("No DN for entry");
            }
            String trimmedLine = line.substring(4).trim();
            try {
                dn = new String(Base64.decode(trimmedLine.toCharArray()), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.error("The ldif entry is supposed to have a base 64 encoded DN");
                throw new NamingException("Invalid base 64 encoded DN");
            }
        } else {
            dn = line.substring(3).trim();
        }
        try {
            LdapDnParser.parseInternal(dn, new ArrayList<Rdn>());
            return dn;
        }
        catch (InvalidNameException ine) {
            LOG.error("The DN {} is not valid");
            throw ine;
        }
    }

    protected static Object parseSimpleValue(String line, int pos) {
        if (line.length() > pos + 1) {
            char c = line.charAt(pos + 1);
            if (c == ':') {
                String value = StringTools.trim(line.substring(pos + 2));
                return Base64.decode(value.toCharArray());
            }
            return StringTools.trim(line.substring(pos + 1));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object parseValue(String line, int pos) throws NamingException {
        if (line.length() <= pos + 1) return null;
        char c = line.charAt(pos + 1);
        if (c == ':') {
            String value = StringTools.trim(line.substring(pos + 2));
            return Base64.decode(value.toCharArray());
        }
        if (c != '<') return StringTools.trim(line.substring(pos + 1));
        String urlName = StringTools.trim(line.substring(pos + 2));
        try {
            URL url = new URL(urlName);
            if (!"file".equals(url.getProtocol())) {
                LOG.error("Protocols other than file: are not supported");
                throw new NamingException("Unsupported URL protocol");
            }
            String fileName = url.getFile();
            File file = new File(fileName);
            if (!file.exists()) {
                LOG.error("File {} not found", (Object)fileName);
                throw new NamingException("Bad URL, file not found");
            }
            long length = file.length();
            if (length > this.sizeLimit) {
                LOG.error("File {} is too big", (Object)fileName);
                throw new NamingException("File too big");
            }
            byte[] data = new byte[(int)length];
            FilterInputStream inf = null;
            try {
                inf = new DataInputStream(new FileInputStream(file));
                ((DataInputStream)inf).read(data);
                byte[] byArray = data;
                return byArray;
            }
            catch (FileNotFoundException fnfe) {
                LOG.error("File {} not found", (Object)fileName);
                throw new NamingException("Bad URL, file not found");
            }
            catch (IOException ioe) {
                LOG.error("File {} error reading", (Object)fileName);
                throw new NamingException("Bad URL, file can't be read");
            }
            finally {
                try {
                    inf.close();
                }
                catch (IOException ioe) {
                    LOG.error("Error while closing the stream : {}", (Object)ioe.getMessage());
                }
            }
        }
        catch (MalformedURLException mue) {
            LOG.error("Bad URL {}", (Object)urlName);
            throw new NamingException("Bad URL");
        }
    }

    private Control parseControl(String line) throws NamingException {
        String lowerLine = line.toLowerCase().trim();
        int pos = 0;
        char[] controlValue = line.trim().toCharArray();
        int length = controlValue.length;
        if (pos > length) {
            LOG.error("The control does not have an OID");
            throw new NamingException("Bad control, no oid");
        }
        int initPos = pos;
        while (StringTools.isCharASCII(controlValue, pos, '.') || StringTools.isDigit(controlValue, pos)) {
            ++pos;
        }
        if (pos == initPos) {
            LOG.error("The control does not have an OID");
            throw new NamingException("Bad control, no oid");
        }
        String oidString = lowerLine.substring(0, pos);
        OID oid = null;
        try {
            oid = new OID(oidString);
        }
        catch (DecoderException de) {
            LOG.error("The OID {} is not valid", (Object)oidString);
            throw new NamingException("Bad control oid");
        }
        LdifControl control = new LdifControl(oid);
        while (StringTools.isCharASCII(controlValue, pos, ' ')) {
            ++pos;
        }
        int criticalPos = lowerLine.indexOf(58);
        int criticalLength = 0;
        criticalLength = criticalPos == -1 ? length - pos : criticalPos - pos;
        if (criticalLength == 4 && "true".equalsIgnoreCase(lowerLine.substring(pos, pos + 4))) {
            control.setCriticality(true);
        } else if (criticalLength == 5 && "false".equalsIgnoreCase(lowerLine.substring(pos, pos + 5))) {
            control.setCriticality(false);
        } else if (criticalLength != 0) {
            LOG.error("The control muts have a valid criticality");
            throw new NamingException("Bad control criticality");
        }
        if (criticalPos > 0) {
            if (StringTools.isCharASCII(controlValue, criticalPos + 1, ':')) {
                byte[] value = Base64.decode(line.substring(criticalPos + 2).toCharArray());
                control.setValue(value);
            } else if (!StringTools.isCharASCII(controlValue, criticalPos + 1, '<')) {
                byte[] value = new byte[length - criticalPos - 1];
                for (int i = 0; i < length - criticalPos - 1; ++i) {
                    value[i] = (byte)controlValue[i + criticalPos + 1];
                }
                control.setValue(value);
            }
        }
        return control;
    }

    public static Attribute parseAttributeValue(String line) {
        int colonIndex = line.indexOf(58);
        if (colonIndex != -1) {
            String attributeType = line.toLowerCase().substring(0, colonIndex);
            Object attributeValue = LdifReader.parseSimpleValue(line, colonIndex);
            return new BasicAttribute(attributeType, attributeValue);
        }
        return null;
    }

    public void parseAttributeValue(LdifEntry entry, String line, String lowerLine) throws NamingException {
        int colonIndex = line.indexOf(58);
        String attributeType = lowerLine.substring(0, colonIndex);
        if (attributeType.equals("dn")) {
            LOG.error("An entry must not have two DNs");
            throw new NamingException("A ldif entry should not have two DN");
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        entry.addAttribute(attributeType, attributeValue);
    }

    private void parseModRdn(LdifEntry entry, Iterator<String> iter) throws NamingException {
        String lowerLine;
        String line;
        if (iter.hasNext()) {
            line = iter.next();
            lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("newrdn::") && !lowerLine.startsWith("newrdn:")) {
                LOG.error("A modrdn operation must start with a \"newrdn:\"");
                throw new NamingException("Bad modrdn operation");
            }
        } else {
            LOG.error("A modrdn operation must start with a \"newrdn:\"");
            throw new NamingException("Bad modrdn operation, no newrdn");
        }
        int colonIndex = line.indexOf(58);
        Object attributeValue = this.parseValue(line, colonIndex);
        entry.setNewRdn(attributeValue instanceof String ? (String)attributeValue : StringTools.utf8ToString((byte[])attributeValue));
        if (iter.hasNext()) {
            line = iter.next();
            lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("deleteoldrdn:")) {
                LOG.error("A modrdn operation must contains a \"deleteoldrdn:\"");
                throw new NamingException("Bad modrdn operation, no deleteoldrdn");
            }
        } else {
            LOG.error("A modrdn operation must contains a \"deleteoldrdn:\"");
            throw new NamingException("Bad modrdn operation, no deleteoldrdn");
        }
        colonIndex = line.indexOf(58);
        attributeValue = this.parseValue(line, colonIndex);
        entry.setDeleteOldRdn("1".equals(attributeValue));
    }

    private void parseModify(LdifEntry entry, Iterator<String> iter) throws NamingException {
        int state = 0;
        String modified = null;
        ModificationOperation modificationType = ModificationOperation.ADD_ATTRIBUTE;
        DefaultClientAttribute attribute = null;
        boolean isEmptyValue = true;
        while (iter.hasNext()) {
            String line = iter.next();
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("-")) {
                if (state != 2) {
                    LOG.error("Bad state : we should have come from an ATTRVAL_SPEC");
                    throw new NamingException("Bad modify separator");
                }
                if (isEmptyValue) {
                    entry.addModificationItem(modificationType, modified, null);
                } else {
                    entry.addModificationItem(modificationType, attribute);
                }
                state = 0;
                isEmptyValue = true;
                continue;
            }
            if (lowerLine.startsWith("add:")) {
                if (state != 0 && state != 1) {
                    LOG.error("Bad state : we should have come from a MOD_SPEC or an ATTRVAL_SPEC");
                    throw new NamingException("Bad modify state");
                }
                modified = StringTools.trim(line.substring("add:".length()));
                modificationType = ModificationOperation.ADD_ATTRIBUTE;
                attribute = new DefaultClientAttribute(modified);
                state = 1;
                continue;
            }
            if (lowerLine.startsWith("delete:")) {
                if (state != 0 && state != 1) {
                    LOG.error("Bad state : we should have come from a MOD_SPEC or an ATTRVAL_SPEC");
                    throw new NamingException("Bad modify state");
                }
                modified = StringTools.trim(line.substring("delete:".length()));
                modificationType = ModificationOperation.REMOVE_ATTRIBUTE;
                attribute = new DefaultClientAttribute(modified);
                state = 2;
                continue;
            }
            if (lowerLine.startsWith("replace:")) {
                if (state != 0 && state != 1) {
                    LOG.error("Bad state : we should have come from a MOD_SPEC or an ATTRVAL_SPEC");
                    throw new NamingException("Bad modify state");
                }
                modified = StringTools.trim(line.substring("replace:".length()));
                modificationType = ModificationOperation.REPLACE_ATTRIBUTE;
                attribute = new DefaultClientAttribute(modified);
                state = 2;
                continue;
            }
            if (state != 1 && state != 2) {
                LOG.error("Bad state : we should have come from an ATTRVAL_SPEC");
                throw new NamingException("Bad modify state");
            }
            int colonIndex = line.indexOf(58);
            String attributeType = line.substring(0, colonIndex);
            if (!attributeType.equalsIgnoreCase(modified)) {
                LOG.error("The modified attribute and the attribute value spec must be equal");
                throw new NamingException("Bad modify attribute");
            }
            if (attributeType.equalsIgnoreCase("dn")) {
                LOG.error("An entry must not have two DNs");
                throw new NamingException("A ldif entry should not have two DN");
            }
            Object attributeValue = this.parseValue(line, colonIndex);
            if (attributeValue instanceof String) {
                attribute.add((String)attributeValue);
            } else {
                attribute.add(new byte[][]{(byte[])attributeValue});
            }
            isEmptyValue = false;
            state = 2;
        }
    }

    private void parseChange(LdifEntry entry, Iterator<String> iter, ChangeType operation) throws NamingException {
        entry.setChangeType(operation);
        switch (operation.getChangeType()) {
            case 4: {
                return;
            }
            case 0: {
                while (iter.hasNext()) {
                    String line = iter.next();
                    String lowerLine = line.toLowerCase();
                    this.parseAttributeValue(entry, line, lowerLine);
                }
                return;
            }
            case 1: {
                this.parseModify(entry, iter);
                return;
            }
            case 2: 
            case 3: {
                this.parseModRdn(entry, iter);
                if (iter.hasNext()) {
                    String line = iter.next();
                    String lowerLine = line.toLowerCase();
                    if (lowerLine.startsWith("newsuperior:")) {
                        int colonIndex = line.indexOf(58);
                        Object attributeValue = this.parseValue(line, colonIndex);
                        entry.setNewSuperior(attributeValue instanceof String ? (String)attributeValue : StringTools.utf8ToString((byte[])attributeValue));
                    } else if (operation == ChangeType.ModDn) {
                        LOG.error("A moddn operation must contains a \"newsuperior:\"");
                        throw new NamingException("Bad moddn operation, no newsuperior");
                    }
                } else if (operation == ChangeType.ModDn) {
                    LOG.error("A moddn operation must contains a \"newsuperior:\"");
                    throw new NamingException("Bad moddn operation, no newsuperior");
                }
                return;
            }
        }
        LOG.error("Unknown operation");
        throw new NamingException("Bad operation");
    }

    private LdifEntry parseEntry() throws NamingException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        String line = this.lines.get(0);
        String name = this.parseDn(line);
        LdapDN dn = new LdapDN(name);
        LdifEntry entry = new LdifEntry();
        entry.setDn(dn);
        this.lines.remove(0);
        Iterator<String> iter = this.lines.iterator();
        int type = 2;
        boolean controlSeen = false;
        boolean changeTypeSeen = false;
        ChangeType operation = ChangeType.Add;
        String lowerLine = null;
        Control control = null;
        while (iter.hasNext()) {
            line = iter.next();
            lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("control:")) {
                if (this.containsEntries) {
                    LOG.error("We cannot have changes when reading a file which already contains entries");
                    throw new NamingException("No changes withing entries");
                }
                this.containsChanges = true;
                if (controlSeen) {
                    LOG.error("We already have had a control");
                    throw new NamingException("Control misplaced");
                }
                control = this.parseControl(line.substring("control:".length()));
                entry.setControl(control);
                continue;
            }
            if (lowerLine.startsWith("changetype:")) {
                if (this.containsEntries) {
                    LOG.error("We cannot have changes when reading a file which already contains entries");
                    throw new NamingException("No changes withing entries");
                }
                this.containsChanges = true;
                if (changeTypeSeen) {
                    LOG.error("We already have had a changeType");
                    throw new NamingException("ChangeType misplaced");
                }
                type = 1;
                controlSeen = true;
                operation = this.parseChangeType(line);
                this.parseChange(entry, iter, operation);
                changeTypeSeen = true;
                continue;
            }
            if (line.indexOf(58) > 0) {
                if (this.containsChanges) {
                    LOG.error("We cannot have entries when reading a file which already contains changes");
                    throw new NamingException("No entries within changes");
                }
                this.containsEntries = true;
                if (controlSeen || changeTypeSeen) {
                    LOG.error("We can't have a Attribute/Value pair after a control or a changeType");
                    throw new NamingException("AttributeType misplaced");
                }
                this.parseAttributeValue(entry, line, lowerLine);
                type = 0;
                continue;
            }
            LOG.error("Expecting an attribute type");
            throw new NamingException("Bad attribute");
        }
        if (type == 0) {
            LOG.debug("Read an entry : {}", entry);
        } else if (type == 1) {
            entry.setChangeType(operation);
            LOG.debug("Read a modification : {}", entry);
        } else {
            LOG.error("Unknown entry type");
            throw new NamingException("Unknown entry");
        }
        return entry;
    }

    private int parseVersion() throws NamingException {
        int ver = 1;
        this.readLines();
        if (this.lines.size() == 0) {
            LOG.warn("The ldif file is empty");
            return ver;
        }
        String line = this.lines.get(0);
        char[] document = line.toCharArray();
        String versionNumber = null;
        if (line.startsWith("version:")) {
            this.position.inc("version:".length());
            LdifReader.parseFill(document, this.position);
            versionNumber = LdifReader.parseNumber(document, this.position);
            if (this.position.pos != document.length) {
                LOG.error("The version is not a number");
                throw new NamingException("Ldif parsing error");
            }
            try {
                ver = Integer.parseInt(versionNumber);
            }
            catch (NumberFormatException nfe) {
                LOG.error("The version is not a number");
                throw new NamingException("Ldif parsing error");
            }
            LOG.debug("Ldif version : {}", (Object)versionNumber);
            this.lines.remove(0);
            if (this.lines.size() == 0) {
                this.readLines();
            }
        } else {
            LOG.warn("No version information : assuming version: 1");
        }
        return ver;
    }

    protected void readLines() throws NamingException {
        String line = null;
        boolean insideComment = true;
        boolean isFirstLine = true;
        this.lines.clear();
        StringBuffer sb = new StringBuffer();
        try {
            block6: while ((line = ((BufferedReader)this.in).readLine()) != null) {
                if (line.length() == 0) {
                    if (isFirstLine) continue;
                    insideComment = false;
                    break;
                }
                switch (line.charAt(0)) {
                    case '#': {
                        insideComment = true;
                        continue block6;
                    }
                    case ' ': {
                        isFirstLine = false;
                        if (insideComment) continue block6;
                        if (sb.length() == 0) {
                            LOG.error("Cannot have an empty continuation line");
                            throw new NamingException("Ldif Parsing error");
                        }
                        sb.append(line.substring(1));
                        insideComment = false;
                        continue block6;
                    }
                }
                isFirstLine = false;
                if (sb.length() != 0) {
                    this.lines.add(sb.toString());
                }
                sb = new StringBuffer(line);
                insideComment = false;
            }
        }
        catch (IOException ioe) {
            throw new NamingException("Error while reading ldif lines");
        }
        if (sb.length() != 0) {
            this.lines.add(sb.toString());
        }
    }

    public List<LdifEntry> parseLdifFile(String fileName) throws NamingException {
        return this.parseLdifFile(fileName, Charset.forName(StringTools.getDefaultCharsetName()).toString());
    }

    public List<LdifEntry> parseLdifFile(String fileName, String encoding) throws NamingException {
        if (StringTools.isEmpty(fileName)) {
            LOG.error("Cannot parse an empty file name !");
            throw new NamingException("Empty filename");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            LOG.error("Cannot parse the file {}, it does not exist", (Object)fileName);
            throw new NamingException("Filename " + fileName + " not found.");
        }
        try {
            BufferedReader inf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName(encoding)));
            return this.parseLdif(inf);
        }
        catch (FileNotFoundException fnfe) {
            LOG.error("Cannot find file {}", (Object)fileName);
            throw new NamingException("Filename " + fileName + " not found.");
        }
    }

    public List<LdifEntry> parseLdif(String ldif) throws NamingException {
        LOG.debug("Starts parsing ldif buffer");
        if (StringTools.isEmpty(ldif)) {
            return new ArrayList<LdifEntry>();
        }
        StringReader strIn = new StringReader(ldif);
        BufferedReader inf = new BufferedReader(strIn);
        try {
            List<LdifEntry> entries = this.parseLdif(inf);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed {} entries.", entries == null ? Integer.valueOf(0) : Integer.valueOf(entries.size()));
            }
            return entries;
        }
        catch (NamingException ne) {
            LOG.error("Cannot parse the ldif buffer : {}", (Object)ne.getMessage());
            throw new NamingException("Error while parsing the ldif buffer");
        }
    }

    private LdifEntry nextInternal() {
        try {
            LOG.debug("next(): -- called");
            LdifEntry entry = this.prefetched;
            this.readLines();
            try {
                this.prefetched = this.parseEntry();
            }
            catch (NamingException ne) {
                this.error = ne;
                throw new NoSuchElementException(ne.getMessage());
            }
            LOG.debug("next(): -- returning ldif {}\n", entry);
            return entry;
        }
        catch (NamingException ne) {
            LOG.error("Premature termination of LDIF iterator");
            this.error = ne;
            return null;
        }
    }

    public LdifEntry next() {
        return this.nextInternal();
    }

    private boolean hasNextInternal() {
        return null != this.prefetched;
    }

    public boolean hasNext() {
        LOG.debug("hasNext(): -- returning {}", this.prefetched != null ? Boolean.TRUE : Boolean.FALSE);
        return this.hasNextInternal();
    }

    private void removeInternal() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        this.removeInternal();
    }

    @Override
    public Iterator<LdifEntry> iterator() {
        return new Iterator<LdifEntry>(){

            @Override
            public boolean hasNext() {
                return LdifReader.this.hasNextInternal();
            }

            @Override
            public LdifEntry next() {
                return LdifReader.this.nextInternal();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public List<LdifEntry> parseLdif(BufferedReader inf) throws NamingException {
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>();
        this.in = inf;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
        try {
            for (LdifEntry entry : this) {
                if (entry == null) continue;
                entries.add(entry);
            }
        }
        catch (NoSuchElementException nsee) {
            throw new NamingException("Error while parsing ldif : " + this.error.getMessage());
        }
        return entries;
    }

    public boolean containsEntries() {
        return this.containsEntries;
    }

    public class Position {
        private int pos = 0;

        public void inc() {
            ++this.pos;
        }

        public void inc(int val) {
            this.pos += val;
        }
    }
}

