/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.message.AbstractAbandonableRequest;
import org.apache.directory.shared.ldap.message.InternalModifyRequest;
import org.apache.directory.shared.ldap.message.InternalModifyResponse;
import org.apache.directory.shared.ldap.message.InternalResultResponse;
import org.apache.directory.shared.ldap.message.MessageTypeEnum;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyRequestImpl
extends AbstractAbandonableRequest
implements InternalModifyRequest {
    static final long serialVersionUID = -505803669028990304L;
    private static final transient Logger LOG = LoggerFactory.getLogger(ModifyRequestImpl.class);
    private LdapDN name;
    private List<Modification> mods = new ArrayList<Modification>();
    private InternalModifyResponse response;

    public ModifyRequestImpl(int id) {
        super(id, TYPE);
    }

    @Override
    public Collection<Modification> getModificationItems() {
        return Collections.unmodifiableCollection(this.mods);
    }

    @Override
    public LdapDN getName() {
        return this.name;
    }

    @Override
    public void setName(LdapDN name) {
        this.name = name;
    }

    @Override
    public void addModification(Modification mod) {
        this.mods.add(mod);
    }

    @Override
    public void removeModification(Modification mod) {
        this.mods.remove(mod);
    }

    @Override
    public MessageTypeEnum getResponseType() {
        return RESP_TYPE;
    }

    @Override
    public InternalResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new ModifyResponseImpl(this.getMessageId());
        }
        return this.response;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalModifyRequest req = (InternalModifyRequest)obj;
        if (this.name != null && req.getName() == null) {
            return false;
        }
        if (this.name == null && req.getName() != null) {
            return false;
        }
        if (this.name != null && req.getName() != null && !this.name.equals(req.getName())) {
            return false;
        }
        if (req.getModificationItems().size() != this.mods.size()) {
            return false;
        }
        Iterator<Modification> list = req.getModificationItems().iterator();
        for (int i = 0; i < this.mods.size(); ++i) {
            Modification item = list.next();
            if (!(item == null ? this.mods.get(i) != null : !item.equals((ClientModification)this.mods.get(i)))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Modify Request\n");
        sb.append("        Object : '").append(this.name).append("'\n");
        if (this.mods != null) {
            for (int i = 0; i < this.mods.size(); ++i) {
                ClientModification modification = (ClientModification)this.mods.get(i);
                sb.append("            Modification[").append(i).append("]\n");
                sb.append("                Operation : ");
                switch (modification.getOperation()) {
                    case ADD_ATTRIBUTE: {
                        sb.append(" add\n");
                        break;
                    }
                    case REPLACE_ATTRIBUTE: {
                        sb.append(" replace\n");
                        break;
                    }
                    case REMOVE_ATTRIBUTE: {
                        sb.append(" delete\n");
                    }
                }
                sb.append("                Modification\n");
                sb.append(modification.getAttribute());
            }
        }
        return sb.toString();
    }
}

