/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntaxes;

import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.schema.syntaxes.BitStringSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class NameAndOptionalUIDSyntaxChecker
extends AbstractSyntaxChecker {
    public NameAndOptionalUIDSyntaxChecker() {
        super("1.3.6.1.4.1.1466.115.121.1.34");
    }

    protected NameAndOptionalUIDSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        int sharpPos = strValue.lastIndexOf(35);
        if (sharpPos != -1) {
            if (strValue.indexOf(35) != sharpPos) {
                return false;
            }
            if (BitStringSyntaxChecker.isValid(strValue.substring(sharpPos + 1)) && sharpPos < strValue.length()) {
                if (sharpPos > 0) {
                    return LdapDN.isValid(strValue.substring(0, sharpPos));
                }
                return false;
            }
            return false;
        }
        return LdapDN.isValid(strValue);
    }
}

