/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ.state;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.integ.InheritableServerSettings;
import org.apache.directory.server.integ.state.TestServerContext;
import org.apache.directory.server.integ.state.TestServerState;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractState
implements TestServerState {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractState.class);
    protected final TestServerContext context;
    private static final String DESTROY_ERR = "Cannot destroy when service is in NonExistant state";
    private static final String CLEANUP_ERROR = "Cannot cleanup when service is in NonExistant state";
    private static final String STARTUP_ERR = "Cannot startup when service is in NonExistant state";
    private static final String SHUTDOWN_ERR = "Cannot shutdown service in NonExistant state.";
    private static final String REVERT_ERROR = "Cannot revert when service is in NonExistant state";

    protected AbstractState(TestServerContext context) {
        this.context = context;
    }

    public void create(InheritableServerSettings settings) throws NamingException {
    }

    public void destroy() {
        LOG.error(DESTROY_ERR);
        throw new IllegalStateException(DESTROY_ERR);
    }

    public void cleanup() throws IOException {
        LOG.error(CLEANUP_ERROR);
        throw new IllegalStateException(CLEANUP_ERROR);
    }

    public void startup() throws Exception {
        LOG.error(STARTUP_ERR);
        throw new IllegalStateException(STARTUP_ERR);
    }

    public void shutdown() throws Exception {
        LOG.error(SHUTDOWN_ERR);
        throw new IllegalStateException(SHUTDOWN_ERR);
    }

    public void test(TestClass testClass, Statement statement, RunNotifier notifier, InheritableServerSettings settings) {
    }

    public void revert() throws Exception {
        LOG.error(REVERT_ERROR);
        throw new IllegalStateException(REVERT_ERROR);
    }

    protected void injectLdifs(DirectoryService service, InheritableServerSettings settings) throws Exception {
        List<String> ldifs = new ArrayList<String>();
        List<String> ldifFiles = new ArrayList<String>();
        if ((ldifFiles = settings.getLdifFiles(ldifFiles)).size() != 0) {
            for (String ldifFile : ldifFiles) {
                String message;
                String className = settings.getParent().getDescription().getDisplayName();
                if (className == null) {
                    String message2 = "Cannot inject a LDIF file with a null name";
                    LOG.error(message2);
                    throw new FileNotFoundException(message2);
                }
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException cnfe) {
                    message = "Cannot inject a LDIF file for this class : " + className;
                    LOG.error(message);
                    throw new FileNotFoundException(message);
                }
                InputStream in = clazz.getResourceAsStream(ldifFile);
                if (in == null) {
                    message = "Cannot inject a LDIF for the file " + ldifFile;
                    LOG.error(message);
                    throw new FileNotFoundException(message);
                }
                LdifReader ldifReader = new LdifReader(in);
                for (LdifEntry entry : ldifReader) {
                    service.getAdminSession().add((ServerEntry)new DefaultServerEntry(service.getRegistries(), entry.getEntry()));
                    LOG.debug("Successfully injected LDIF enry for test {}: {}", (Object)settings.getDescription(), (Object)entry);
                }
            }
        }
        if ((ldifs = settings.getLdifs(ldifs)).size() != 0) {
            for (String ldif : ldifs) {
                StringReader in = new StringReader(ldif);
                LdifReader ldifReader = new LdifReader((Reader)in);
                for (LdifEntry entry : ldifReader) {
                    service.getAdminSession().add((ServerEntry)new DefaultServerEntry(service.getRegistries(), entry.getEntry()));
                    LOG.debug("Successfully injected LDIF enry for test {}: {}", (Object)settings.getDescription(), (Object)entry);
                }
            }
        }
    }

    protected void testAborted(RunNotifier notifier, Description description, Throwable cause) {
        notifier.fireTestStarted(description);
        notifier.fireTestFailure(new Failure(description, cause));
        notifier.fireTestFinished(description);
    }
}

