/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.normalizers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.Normalizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    private final Pattern[] regexes;
    private final Matcher[] matchers;

    public RegexNormalizer(Pattern[] regexes) {
        if (regexes != null) {
            this.regexes = new Pattern[regexes.length];
            System.arraycopy(regexes, 0, this.regexes, 0, regexes.length);
            this.matchers = new Matcher[regexes.length];
            for (int i = 0; i < regexes.length; ++i) {
                this.matchers[i] = regexes[i].matcher("");
            }
        } else {
            this.regexes = null;
            this.matchers = new Matcher[0];
        }
    }

    @Override
    public Value<?> normalize(Value<?> value) {
        if (value == null) {
            return null;
        }
        if (!value.isBinary()) {
            String str = value.getString();
            for (int i = 0; i < this.matchers.length; ++i) {
                str = this.matchers[i].replaceAll(str);
            }
            return new ClientStringValue(str);
        }
        return value;
    }

    @Override
    public String normalize(String value) {
        if (value == null) {
            return null;
        }
        String str = value;
        for (int i = 0; i < this.matchers.length; ++i) {
            str = this.matchers[i].replaceAll(str);
        }
        return str;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("RegexNormalizer( ");
        for (int i = 0; i < this.regexes.length; ++i) {
            buf.append(this.regexes[i]);
            if (i >= this.regexes.length - 1) continue;
            buf.append(", ");
        }
        buf.append(" )");
        return buf.toString();
    }
}

