/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadResponseBody;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;

public class JarUploadHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, JarUploadResponseBody, EmptyMessageParameters> {
    private final Path jarDir;
    private final Executor executor;

    public JarUploadHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JarUploadResponseBody, EmptyMessageParameters> messageHeaders, Path jarDir, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.jarDir = Objects.requireNonNull(jarDir);
        this.executor = Objects.requireNonNull(executor);
    }

    @VisibleForTesting
    public CompletableFuture<JarUploadResponseBody> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        Collection uploadedFiles = request.getUploadedFiles();
        if (uploadedFiles.size() != 1) {
            throw new RestHandlerException("Exactly 1 file must be sent, received " + uploadedFiles.size() + '.', HttpResponseStatus.BAD_REQUEST);
        }
        Path fileUpload = ((File)uploadedFiles.iterator().next()).toPath();
        return CompletableFuture.supplyAsync(() -> {
            if (!fileUpload.getFileName().toString().endsWith(".jar")) {
                throw new CompletionException((Throwable)new RestHandlerException("Only Jar files are allowed.", HttpResponseStatus.BAD_REQUEST));
            }
            Path destination = this.jarDir.resolve(UUID.randomUUID() + "_" + fileUpload.getFileName());
            try {
                Files.move(fileUpload, destination, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new CompletionException((Throwable)new RestHandlerException(String.format("Could not move uploaded jar file [%s] to [%s].", fileUpload, destination), HttpResponseStatus.INTERNAL_SERVER_ERROR, (Throwable)e));
            }
            return new JarUploadResponseBody(destination.normalize().toString());
        }, this.executor);
    }
}

