/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobServerTest
extends TestLogger {
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testFailureIfStorageDirectoryCannotBeCreated() throws IOException {
        Configuration configuration = new Configuration();
        File blobStorageDirectory = this.createNonWritableDirectory();
        String nonExistDirectory = new File(blobStorageDirectory, "does_not_exist_for_sure").getAbsolutePath();
        configuration.setString(BlobServerOptions.STORAGE_DIRECTORY, nonExistDirectory);
        try (BlobServer ignored = new BlobServer(configuration, (BlobStore)new VoidBlobStore());){
            Assert.fail((String)"Expected that the BlobServer initialization fails.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nonnull
    private File createNonWritableDirectory() throws IOException {
        Assume.assumeFalse((boolean)OperatingSystem.isWindows());
        File blobStorageDirectory = temporaryFolder.newFolder();
        Assert.assertTrue((boolean)blobStorageDirectory.setExecutable(true, false));
        Assert.assertTrue((boolean)blobStorageDirectory.setReadable(true, false));
        Assert.assertTrue((boolean)blobStorageDirectory.setWritable(false, false));
        return blobStorageDirectory;
    }
}

