/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.executiongraph.DefaultSubtaskAttemptNumberStore;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSubtaskAttemptNumberStoreTest
extends TestLogger {
    @Test
    public void testGetAttemptCount() {
        List<Integer> initialAttemptCounts = Arrays.asList(1, 2, 3);
        DefaultSubtaskAttemptNumberStore subtaskAttemptNumberStore = new DefaultSubtaskAttemptNumberStore(initialAttemptCounts);
        Assert.assertThat((Object)subtaskAttemptNumberStore.getAttemptCount(1), (Matcher)CoreMatchers.is((Object)initialAttemptCounts.get(1)));
    }

    @Test
    public void testOutOfBoundsSubtaskIndexReturnsZero() {
        List<Integer> initialAttemptCounts = Arrays.asList(1, 2, 3);
        DefaultSubtaskAttemptNumberStore subtaskAttemptNumberStore = new DefaultSubtaskAttemptNumberStore(initialAttemptCounts);
        Assert.assertThat((Object)subtaskAttemptNumberStore.getAttemptCount(initialAttemptCounts.size() * 2), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeSubtaskIndexRejected() {
        DefaultSubtaskAttemptNumberStore subtaskAttemptNumberStore = new DefaultSubtaskAttemptNumberStore(Collections.emptyList());
        subtaskAttemptNumberStore.getAttemptCount(-1);
    }
}

