/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashMap;
import java.util.function.Function;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphResultPartitionAvailabilityChecker;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.TestingJobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionGraphResultPartitionAvailabilityCheckerTest
extends TestLogger {
    @Test
    public void testPartitionAvailabilityCheck() {
        final IntermediateResultPartitionID irp1ID = new IntermediateResultPartitionID();
        final IntermediateResultPartitionID irp2ID = new IntermediateResultPartitionID();
        final IntermediateResultPartitionID irp3ID = new IntermediateResultPartitionID();
        final IntermediateResultPartitionID irp4ID = new IntermediateResultPartitionID();
        HashMap<IntermediateResultPartitionID, Boolean> expectedAvailability = new HashMap<IntermediateResultPartitionID, Boolean>(){
            {
                this.put(irp1ID, true);
                this.put(irp2ID, false);
                this.put(irp3ID, false);
                this.put(irp4ID, true);
            }
        };
        TestingJobMasterPartitionTracker partitionTracker = new TestingJobMasterPartitionTracker();
        partitionTracker.setIsPartitionTrackedFunction(rpID -> (Boolean)expectedAvailability.get(rpID.getPartitionId()));
        Function<IntermediateResultPartitionID, ResultPartitionID> partitionIDMapper = intermediateResultPartitionID -> new ResultPartitionID(intermediateResultPartitionID, new ExecutionAttemptID());
        ExecutionGraphResultPartitionAvailabilityChecker resultPartitionAvailabilityChecker = new ExecutionGraphResultPartitionAvailabilityChecker(partitionIDMapper, (JobMasterPartitionTracker)partitionTracker);
        for (IntermediateResultPartitionID irpID : expectedAvailability.keySet()) {
            Assert.assertEquals(expectedAvailability.get(irpID), (Object)resultPartitionAvailabilityChecker.isAvailable(irpID));
        }
    }
}

