/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionVertexDeploymentTest
extends TestLogger {
    private static final String ERROR_MESSAGE = "test_failure_error_message";

    @Test
    public void testDeployCall() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot((LogicalSlot)slot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            try {
                vertex.deployToSlot((LogicalSlot)slot);
                Assert.fail((String)"Scheduled from wrong state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeployWithSynchronousAnswer() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot((LogicalSlot)slot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            try {
                vertex.deployToSlot((LogicalSlot)slot);
                Assert.fail((String)"Scheduled from wrong state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertFalse((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.RUNNING) == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeployWithAsynchronousAnswer() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().createTestingLogicalSlot();
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot((LogicalSlot)slot);
            try {
                vertex.deployToSlot((LogicalSlot)slot);
                Assert.fail((String)"Scheduled from wrong state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            try {
                vertex.deployToSlot((LogicalSlot)slot);
                Assert.fail((String)"Scheduled from wrong state");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.RUNNING) == 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeployFailedSynchronous() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().setTaskManagerGateway(new SubmitFailingSimpleAckingTaskManagerGateway()).createTestingLogicalSlot();
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot((LogicalSlot)slot);
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
            Assert.assertTrue((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertThat((Object)vertex.getFailureInfo().map(ErrorInfo::getExceptionAsString).get(), (Matcher)StringContains.containsString((String)ERROR_MESSAGE));
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.FAILED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDeployFailedAsynchronously() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot slot = new TestingLogicalSlotBuilder().setTaskManagerGateway(new SubmitFailingSimpleAckingTaskManagerGateway()).createTestingLogicalSlot();
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot((LogicalSlot)slot);
            for (int i = 0; !(i >= 100 || vertex.getExecutionState() == ExecutionState.FAILED && vertex.getFailureInfo().isPresent()); ++i) {
                Thread.sleep(10L);
            }
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
            Assert.assertTrue((boolean)vertex.getFailureInfo().isPresent());
            Assert.assertThat((Object)vertex.getFailureInfo().map(ErrorInfo::getExceptionAsString).get(), (Matcher)StringContains.containsString((String)ERROR_MESSAGE));
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.FAILED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testFailExternallyDuringDeploy() {
        try {
            ExecutionVertex vertex = ExecutionGraphTestUtils.getExecutionVertex();
            TestingLogicalSlot testingLogicalSlot = new TestingLogicalSlotBuilder().setTaskManagerGateway(new SubmitBlockingSimpleAckingTaskManagerGateway()).createTestingLogicalSlot();
            Assert.assertEquals((Object)ExecutionState.CREATED, (Object)vertex.getExecutionState());
            vertex.deployToSlot((LogicalSlot)testingLogicalSlot);
            Assert.assertEquals((Object)ExecutionState.DEPLOYING, (Object)vertex.getExecutionState());
            Exception testError = new Exception("test error");
            vertex.fail((Throwable)testError);
            Assert.assertEquals((Object)ExecutionState.FAILED, (Object)vertex.getExecutionState());
            Assert.assertThat((Object)vertex.getFailureInfo().map(ErrorInfo::getException).get().deserializeError(ClassLoader.getSystemClassLoader()), (Matcher)CoreMatchers.is((Object)testError));
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.CREATED) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.DEPLOYING) > 0L ? 1 : 0) != 0);
            Assert.assertTrue((vertex.getStateTimestamp(ExecutionState.FAILED) > 0L ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static class SubmitBlockingSimpleAckingTaskManagerGateway
    extends SimpleAckingTaskManagerGateway {
        private SubmitBlockingSimpleAckingTaskManagerGateway() {
        }

        @Override
        public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, Time timeout) {
            return new CompletableFuture<Acknowledge>();
        }
    }

    public static class SubmitFailingSimpleAckingTaskManagerGateway
    extends SimpleAckingTaskManagerGateway {
        @Override
        public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, Time timeout) {
            CompletableFuture<Acknowledge> future = new CompletableFuture<Acknowledge>();
            future.completeExceptionally(new Exception(ExecutionVertexDeploymentTest.ERROR_MESSAGE));
            return future;
        }
    }
}

